/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend;

import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import java.util.concurrent.Future;

public abstract class ResponseHandler<R> {
    protected final ForestRequest request;
    protected final LifeCycleHandler lifeCycleHandler;

    public ResponseHandler(ForestRequest request, LifeCycleHandler lifeCycleHandler) {
        this.request = request;
        this.lifeCycleHandler = lifeCycleHandler;
    }

    public Object handleSync(ForestResponse response, int statusCode, String msg) {
        if (this.request.isAutoRedirection() && response.isRedirection()) {
            ForestRequest redirectionRequest = response.redirectionRequest();
            return redirectionRequest.execute();
        }
        Object result = this.lifeCycleHandler.handleSync(this.request, response);
        if (result instanceof ForestResponse) {
            return result;
        }
        return result;
    }

    public void handleError(ForestResponse response, Throwable ex) {
        this.lifeCycleHandler.handleError(this.request, response, ex);
    }

    public abstract void handleFuture(ForestRequest var1, Future<R> var2);
}

