/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.body;

import com.dtflys.forest.backend.BodyBuilder;
import com.dtflys.forest.backend.ContentType;
import com.dtflys.forest.converter.ForestEncoder;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestBody;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import java.nio.charset.Charset;

public abstract class AbstractBodyBuilder<T>
implements BodyBuilder<T> {
    @Override
    public void buildBody(T httpRequest, ForestRequest request, LifeCycleHandler lifeCycleHandler) {
        boolean needRequestBody;
        boolean mergeCharset;
        String contentType = request.getContentType();
        if (StringUtils.isEmpty(contentType)) {
            contentType = "application/x-www-form-urlencoded";
        }
        String[] typeGroup = contentType.split(";[ ]*charset=");
        String mineType = typeGroup[0];
        String strCharset = request.getCharset();
        Charset charset = null;
        boolean bl = mergeCharset = typeGroup.length > 1;
        if (StringUtils.isEmpty(strCharset)) {
            if (typeGroup.length > 1) {
                strCharset = typeGroup[1];
                charset = Charset.forName(strCharset);
            } else {
                strCharset = request.getConfiguration().getCharset();
                if (StringUtils.isEmpty(strCharset)) {
                    strCharset = "UTF-8";
                }
                charset = Charset.forName(strCharset);
            }
        } else {
            charset = Charset.forName(strCharset);
        }
        if (StringUtils.isEmpty(mineType)) {
            mineType = "application/x-www-form-urlencoded";
        }
        ContentType mineContentType = new ContentType(mineType);
        String ctypeWithoutParams = mineContentType.toStringWithoutParameters();
        ForestEncoder encoder = request.getEncoder();
        if (encoder != null) {
            byte[] bodyBytes = encoder.encodeRequestBody(request, charset);
            bodyBytes = lifeCycleHandler.handleBodyEncode(request, encoder, bodyBytes);
            this.setBinaryBody(httpRequest, request, strCharset, ctypeWithoutParams, bodyBytes, mergeCharset);
            return;
        }
        ForestBody reqBody = request.getBody();
        boolean bl2 = needRequestBody = request.getType().isNeedBody() || !reqBody.isEmpty() || !request.getMultiparts().isEmpty();
        if (needRequestBody) {
            ForestDataType bodyType = request.bodyType();
            if (bodyType == null || bodyType == ForestDataType.AUTO) {
                bodyType = request.getContentType() == null ? (reqBody.getBodyType() == null ? reqBody.getDefaultBodyType() : reqBody.getBodyType()) : mineContentType.bodyType();
            }
            if (bodyType == ForestDataType.MULTIPART) {
                this.setFileBody(httpRequest, request, charset, ctypeWithoutParams, lifeCycleHandler);
                return;
            }
            ForestEncoder bodyEncoder = (ForestEncoder)((Object)request.getConfiguration().getConverterMap().get(bodyType));
            if (bodyEncoder == null) {
                bodyEncoder = (ForestEncoder)((Object)request.getConfiguration().getConverterMap().get(ForestDataType.TEXT));
            }
            byte[] bodyBytes = bodyEncoder.encodeRequestBody(request, charset);
            bodyBytes = lifeCycleHandler.handleBodyEncode(request, bodyEncoder, bodyBytes);
            this.setBinaryBody(httpRequest, request, strCharset, ctypeWithoutParams, bodyBytes, mergeCharset);
        }
    }

    public void setBody(T httpReq, ForestRequest request, byte[] bytes, String charset, String contentType, boolean mergeCharset) {
        if (charset != null) {
            String text = new String(bytes, Charset.forName(charset));
            this.setStringBody(httpReq, request, text, charset, contentType, mergeCharset);
        } else {
            this.setBinaryBody(httpReq, request, charset, contentType, bytes, mergeCharset);
        }
    }

    protected abstract void setStringBody(T var1, ForestRequest var2, String var3, String var4, String var5, boolean var6);

    protected abstract void setFileBody(T var1, ForestRequest var2, Charset var3, String var4, LifeCycleHandler var5);

    protected abstract void setBinaryBody(T var1, ForestRequest var2, String var3, String var4, byte[] var5, boolean var6);
}

