/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient.body;

import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.multipart.ForestMultipart;
import com.dtflys.forest.utils.ForestProgress;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.util.Args;

public class HttpclientMultipartCommonBody
extends AbstractContentBody {
    private final ForestRequest request;
    private final LifeCycleHandler handler;
    private final ForestMultipart multipart;
    private final String filename;
    private long contentLength = -1L;
    private long writtenBytes;
    private final long progressStep;
    private long currentStep = 0L;

    public HttpclientMultipartCommonBody(ForestRequest request, ForestMultipart multipart, ContentType contentType, String filename, LifeCycleHandler handler) {
        super(contentType);
        this.request = request;
        this.multipart = multipart;
        this.filename = multipart.getOriginalFileName();
        this.handler = handler;
        this.progressStep = request.getProgressStep();
    }

    public String getTransferEncoding() {
        return "binary";
    }

    public long getContentLength() {
        return this.multipart.getSize();
    }

    public InputStream getInputStream() {
        return this.multipart.getInputStream();
    }

    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        Args.notNull((Object)out, (String)"Output stream");
        if (this.contentLength < 0L) {
            this.contentLength = this.getContentLength();
        }
        ForestProgress progress = new ForestProgress(this.request, this.contentLength);
        try (InputStream in = this.getInputStream();){
            int len;
            byte[] tmp = new byte[4096];
            progress.setBegin(true);
            while ((len = in.read(tmp)) != -1) {
                this.writtenBytes += (long)len;
                progress.setCurrentBytes(this.writtenBytes);
                if (this.contentLength >= 0L) {
                    this.currentStep += (long)len;
                    if (this.writtenBytes == this.contentLength) {
                        progress.setDone(true);
                        this.handler.handleProgress(this.request, progress);
                    } else {
                        while (this.currentStep >= this.progressStep) {
                            this.currentStep -= this.progressStep;
                            progress.setDone(false);
                            this.handler.handleProgress(this.request, progress);
                        }
                    }
                }
                progress.setBegin(false);
                out.write(tmp, 0, len);
            }
            out.flush();
        }
    }
}

