/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient.body;

import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.utils.ForestProgress;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import okio.BufferedSink;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.Args;

public class HttpclientMultipartFileBody
extends FileBody {
    private final ForestRequest request;
    private final LifeCycleHandler handler;
    private final File file;
    private long contentLength = -1L;
    private long writtenBytes;
    private BufferedSink bufferedSink;
    private final long progressStep;
    private long currentStep = 0L;

    public HttpclientMultipartFileBody(ForestRequest request, File file, ContentType contentType, String filename, LifeCycleHandler handler) {
        super(file, contentType, filename);
        this.request = request;
        this.file = file;
        this.handler = handler;
        this.progressStep = request.getProgressStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        Args.notNull((Object)out, (String)"Output stream");
        FileInputStream in = new FileInputStream(this.file);
        if (this.contentLength < 0L) {
            this.contentLength = this.getContentLength();
        }
        ForestProgress progress = new ForestProgress(this.request, this.contentLength);
        try {
            int len;
            byte[] tmp = new byte[4096];
            progress.setBegin(true);
            while ((len = in.read(tmp)) != -1) {
                this.writtenBytes += (long)len;
                progress.setCurrentBytes(this.writtenBytes);
                if (this.contentLength >= 0L) {
                    this.currentStep += (long)len;
                    if (this.writtenBytes == this.contentLength) {
                        progress.setDone(true);
                        this.handler.handleProgress(this.request, progress);
                        progress.setBegin(false);
                    } else {
                        while (this.currentStep >= this.progressStep) {
                            this.currentStep -= this.progressStep;
                            progress.setDone(false);
                            this.handler.handleProgress(this.request, progress);
                            progress.setBegin(false);
                        }
                    }
                }
                out.write(tmp, 0, len);
            }
            out.flush();
        }
        finally {
            in.close();
        }
    }
}

