/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient.executor;

import com.dtflys.forest.backend.AbstractHttpExecutor;
import com.dtflys.forest.backend.BodyBuilder;
import com.dtflys.forest.backend.ResponseHandler;
import com.dtflys.forest.backend.httpclient.body.HttpclientBodyBuilder;
import com.dtflys.forest.backend.httpclient.entity.HttpclientRequestWithBodyEntity;
import com.dtflys.forest.backend.httpclient.request.HttpclientRequestSender;
import com.dtflys.forest.backend.httpclient.response.HttpclientForestResponseFactory;
import com.dtflys.forest.backend.httpclient.response.HttpclientResponseHandler;
import com.dtflys.forest.backend.url.QueryableURLBuilder;
import com.dtflys.forest.backend.url.URLBuilder;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponseFactory;
import com.dtflys.forest.mapping.MappingTemplate;
import com.dtflys.forest.utils.RequestNameValue;
import com.dtflys.forest.utils.StringUtils;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.http.client.methods.HttpUriRequest;

public class HttpclientExecutor
extends AbstractHttpExecutor {
    private static final URLBuilder URL_BUILDER = new QueryableURLBuilder();
    private final HttpclientResponseHandler httpclientResponseHandler;
    private HttpUriRequest httpRequest;
    private BodyBuilder<HttpUriRequest> bodyBuilder;

    protected HttpUriRequest buildRequest() {
        String url = this.buildUrl();
        return new HttpclientRequestWithBodyEntity(url, this.request.type().getName());
    }

    private URLBuilder getURLBuilder() {
        return URL_BUILDER;
    }

    protected String buildUrl() {
        return this.getURLBuilder().buildUrl(this.request, true);
    }

    protected void prepareBodyBuilder() {
        this.bodyBuilder = new HttpclientBodyBuilder<HttpUriRequest>();
    }

    protected void prepare(LifeCycleHandler lifeCycleHandler) {
        this.httpRequest = this.buildRequest();
        this.prepareBodyBuilder();
        this.prepareHeaders();
        this.prepareBody(lifeCycleHandler);
    }

    public HttpclientExecutor(ForestRequest request, HttpclientResponseHandler httpclientResponseHandler, HttpclientRequestSender requestSender) {
        super(request, requestSender);
        this.httpclientResponseHandler = httpclientResponseHandler;
    }

    public void prepareHeaders() {
        ForestJsonConverter jsonConverter = this.request.getConfiguration().getJsonConverter();
        List<RequestNameValue> headerList = this.request.getHeaderNameValueList();
        String contentType = this.request.getContentType();
        String contentEncoding = this.request.getContentEncoding();
        String contentTypeHeaderName = "Content-Type";
        String contentEncodingHeaderName = "Content-Encoding";
        if (headerList != null && !headerList.isEmpty()) {
            for (RequestNameValue nameValue : headerList) {
                String name = nameValue.getName();
                if ("Content-Type".equalsIgnoreCase(name)) {
                    contentTypeHeaderName = name;
                    continue;
                }
                if ("Content-Encoding".equalsIgnoreCase(name)) {
                    contentEncodingHeaderName = name;
                    continue;
                }
                this.httpRequest.setHeader(name, MappingTemplate.getParameterValue(jsonConverter, nameValue.getValue()));
            }
        }
        if (StringUtils.isNotEmpty(contentType)) {
            this.httpRequest.setHeader(contentTypeHeaderName, contentType);
        }
        if (StringUtils.isNotEmpty(contentEncoding)) {
            this.httpRequest.setHeader(contentEncodingHeaderName, contentEncoding);
        }
    }

    public void prepareBody(LifeCycleHandler lifeCycleHandler) {
        this.bodyBuilder.buildBody(this.httpRequest, this.request, lifeCycleHandler);
    }

    @Override
    public void execute(LifeCycleHandler lifeCycleHandler) {
        this.prepare(lifeCycleHandler);
        Date startDate = new Date();
        HttpclientForestResponseFactory forestResponseFactory = new HttpclientForestResponseFactory();
        try {
            this.request.pool().awaitRequest(this.request);
            this.requestSender.sendRequest(this.request, this, this.httpclientResponseHandler, this.httpRequest, lifeCycleHandler, startDate);
        }
        catch (IOException e) {
            this.httpRequest.abort();
            this.response = forestResponseFactory.createResponse((ForestRequest<?>)this.request, null, lifeCycleHandler, (Throwable)e, startDate);
            lifeCycleHandler.handleSyncWithException(this.request, this.response, e);
            return;
        }
        catch (ForestRuntimeException e) {
            this.httpRequest.abort();
            throw e;
        }
        finally {
            this.request.pool().finish(this.request);
        }
    }

    @Override
    public ResponseHandler getResponseHandler() {
        return this.httpclientResponseHandler;
    }

    @Override
    public ForestResponseFactory getResponseFactory() {
        return new HttpclientForestResponseFactory();
    }

    @Override
    public void close() {
        if (this.httpRequest != null && !this.httpRequest.isAborted()) {
            this.httpRequest.abort();
        }
    }
}

