/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient.response;

import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.http.ForestResponseFactory;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HttpclientForestFuture<T, R>
implements Future<T> {
    private final ForestRequest request;
    private final Date requestTime;
    private final Class<T> innerType;
    private final LifeCycleHandler lifeCycleHandler;
    private final Future<R> httpResponseFuture;
    private final ForestResponseFactory forestResponseFactory;

    public HttpclientForestFuture(ForestRequest request, Date requestTime, Class<T> innerType, LifeCycleHandler lifeCycleHandler, Future<R> httpResponseFuture, ForestResponseFactory forestResponseFactory) {
        this.request = request;
        this.requestTime = requestTime;
        this.innerType = innerType;
        this.lifeCycleHandler = lifeCycleHandler;
        this.httpResponseFuture = httpResponseFuture;
        this.forestResponseFactory = forestResponseFactory;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.httpResponseFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.httpResponseFuture.isCancelled();
    }

    public Date getRequestTime() {
        return this.requestTime;
    }

    @Override
    public boolean isDone() {
        return this.httpResponseFuture.isDone();
    }

    private T getResult(R httpResponse) throws InterruptedException {
        if (httpResponse != null && this.innerType.isAssignableFrom(httpResponse.getClass())) {
            return (T)httpResponse;
        }
        ForestResponse<?> response = this.forestResponseFactory.createResponse(this.request, httpResponse, this.lifeCycleHandler, null, this.requestTime);
        Object ret = this.lifeCycleHandler.handleResultType(this.request, response, this.innerType, this.innerType);
        return (T)ret;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        R httpResponse = this.httpResponseFuture.get();
        return this.getResult(httpResponse);
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        R httpResponse = this.httpResponseFuture.get(timeout, unit);
        return this.getResult(httpResponse);
    }
}

