/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.okhttp3.body;

import com.dtflys.forest.backend.ContentType;
import com.dtflys.forest.backend.body.AbstractBodyBuilder;
import com.dtflys.forest.backend.okhttp3.body.OkHttpMultipartBody;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.body.NameValueRequestBody;
import com.dtflys.forest.http.body.ObjectRequestBody;
import com.dtflys.forest.mapping.MappingTemplate;
import com.dtflys.forest.multipart.ForestMultipart;
import com.dtflys.forest.utils.StringUtils;
import java.io.File;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public class OkHttp3BodyBuilder
extends AbstractBodyBuilder<Request.Builder> {
    @Override
    protected void setStringBody(Request.Builder builder, ForestRequest request, String text, String charset, String contentType, boolean mergeCharset) {
        MediaType mediaType = MediaType.parse((String)contentType);
        Charset cs = StandardCharsets.UTF_8;
        if (charset != null) {
            cs = Charset.forName(charset);
        }
        if (contentType != null) {
            if (mediaType == null) {
                throw new ForestRuntimeException("[Forest] '" + contentType + "' is not a valid content type");
            }
            Charset mtcs = mediaType.charset();
            if (mtcs == null && charset != null && mergeCharset) {
                mediaType = MediaType.parse((String)(contentType + "; charset=" + charset));
            }
        }
        byte[] bytes = text.getBytes(cs);
        RequestBody body = RequestBody.create((MediaType)mediaType, (byte[])bytes);
        builder.method(request.getType().getName(), body);
    }

    private void addMultipart(MultipartBody.Builder bodyBuilder, String name, Object value, String contentType, Charset charset, ForestJsonConverter jsonConverter) {
        MediaType partMediaType;
        if (value == null) {
            return;
        }
        if (StringUtils.isEmpty(contentType)) {
            contentType = "text/plain";
        }
        if ((partMediaType = MediaType.parse((String)contentType)).charset() == null) {
            partMediaType.charset(charset);
        }
        RequestBody requestBody = RequestBody.create((MediaType)partMediaType, (String)MappingTemplate.getParameterValue(jsonConverter, value));
        MultipartBody.Part part = MultipartBody.Part.createFormData((String)name, null, (RequestBody)requestBody);
        bodyBuilder.addPart(part);
    }

    @Override
    protected void setFileBody(Request.Builder builder, ForestRequest request, Charset charset, String contentType, LifeCycleHandler lifeCycleHandler) {
        String boundary = request.getBoundary();
        MultipartBody.Builder bodyBuilder = null;
        bodyBuilder = StringUtils.isNotEmpty(boundary) ? new MultipartBody.Builder(boundary) : new MultipartBody.Builder();
        ContentType objContentType = new ContentType(contentType);
        MediaType mediaType = MediaType.parse((String)objContentType.toStringWithoutParameters());
        if ("multipart".equals(mediaType.type())) {
            bodyBuilder.setType(mediaType);
        }
        ForestJsonConverter jsonConverter = request.getConfiguration().getJsonConverter();
        List<ForestMultipart> multiparts = request.getMultiparts();
        int partsCount = 0;
        for (ForestRequestBody item : request.body()) {
            Object obj;
            if (item instanceof NameValueRequestBody) {
                NameValueRequestBody nameValueItem = (NameValueRequestBody)item;
                String name = nameValueItem.getName();
                Object value = nameValueItem.getValue();
                String partContentType = nameValueItem.getContentType();
                ++partsCount;
                this.addMultipart(bodyBuilder, name, value, partContentType, charset, jsonConverter);
                continue;
            }
            if (!(item instanceof ObjectRequestBody) || (obj = ((ObjectRequestBody)item).getObject()) == null) continue;
            Map<String, Object> attrs = jsonConverter.convertObjectToMap(obj);
            for (Map.Entry<String, Object> entry : attrs.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                ++partsCount;
                this.addMultipart(bodyBuilder, name, value, null, charset, jsonConverter);
            }
        }
        for (ForestMultipart multipart : multiparts) {
            ++partsCount;
            RequestBody fileBody = this.createFileBody(request, multipart, charset, lifeCycleHandler);
            bodyBuilder.addFormDataPart(multipart.getName(), multipart.getOriginalFileName(), fileBody);
        }
        if (partsCount == 0) {
            this.addMultipart(bodyBuilder, "", "", "text/pain", charset, jsonConverter);
        }
        MultipartBody body = bodyBuilder.build();
        builder.method(request.getType().getName(), (RequestBody)body);
    }

    private RequestBody createFileBody(ForestRequest request, ForestMultipart multipart, Charset charset, LifeCycleHandler lifeCycleHandler) {
        String partContentType = multipart.getContentType();
        MediaType fileMediaType = null;
        if (StringUtils.isNotEmpty(partContentType)) {
            fileMediaType = MediaType.parse((String)partContentType);
        }
        if (fileMediaType == null) {
            String mimeType = URLConnection.guessContentTypeFromName(multipart.getOriginalFileName());
            fileMediaType = mimeType == null ? MediaType.parse((String)"multipart/form-data") : MediaType.parse((String)mimeType);
        }
        if (fileMediaType.charset() == null) {
            fileMediaType.charset(charset);
        }
        RequestBody requestBody = multipart.isFile() ? RequestBody.create((MediaType)fileMediaType, (File)multipart.getFile()) : RequestBody.create((MediaType)fileMediaType, (byte[])multipart.getBytes());
        OkHttpMultipartBody wrappedBody = new OkHttpMultipartBody(request, requestBody, lifeCycleHandler);
        return wrappedBody;
    }

    @Override
    protected void setBinaryBody(Request.Builder builder, ForestRequest request, String charset, String contentType, byte[] bytes, boolean mergeCharset) {
        MediaType mediaType;
        Charset mtcs;
        if (StringUtils.isBlank(contentType)) {
            contentType = "application/octet-stream";
        }
        if ((mtcs = (mediaType = MediaType.parse((String)contentType)).charset()) == null && charset != null && mergeCharset) {
            mediaType = MediaType.parse((String)(contentType + "; charset=" + charset));
        }
        RequestBody body = RequestBody.create((MediaType)mediaType, (byte[])bytes);
        builder.method(request.getType().getName(), body);
    }
}

