/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.okhttp3.body;

import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.utils.ForestProgress;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class OkHttpMultipartBody
extends RequestBody {
    private final ForestRequest request;
    private final RequestBody requestBody;
    private final LifeCycleHandler handler;
    private long contentLength = -1L;
    private long writtenBytes;
    private BufferedSink bufferedSink;
    private final long progressStep;
    private long currentStep = 0L;

    public OkHttpMultipartBody(ForestRequest request, RequestBody requestBody, LifeCycleHandler handler) {
        this.request = request;
        this.requestBody = requestBody;
        this.handler = handler;
        this.progressStep = request.getProgressStep();
    }

    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() {
        if (this.contentLength < 0L) {
            try {
                this.contentLength = this.requestBody.contentLength();
            }
            catch (IOException ex) {
                this.contentLength = -1L;
            }
        }
        return this.contentLength;
    }

    private ForwardingSink getSink(BufferedSink sink) {
        final OkHttpMultipartBody self = this;
        final AtomicReference<Object> progressReference = new AtomicReference<Object>(null);
        final Boolean[] isBegin = new Boolean[]{null};
        ForwardingSink forwardingSink = new ForwardingSink((Sink)sink){

            public void write(Buffer source, long byteCount) throws IOException {
                isBegin[0] = isBegin[0] == null ? Boolean.valueOf(true) : Boolean.valueOf(false);
                self.writtenBytes = self.writtenBytes + byteCount;
                long totalLength = self.contentLength();
                ForestProgress progress = (ForestProgress)progressReference.get();
                if (progress == null) {
                    progress = new ForestProgress(self.request, totalLength);
                    progressReference.set(progress);
                }
                progress.setBegin(isBegin[0]);
                progress.setCurrentBytes(self.writtenBytes);
                if (totalLength >= 0L) {
                    self.currentStep = self.currentStep + byteCount;
                    if (self.writtenBytes == totalLength) {
                        progress.setDone(true);
                        self.handler.handleProgress(self.request, progress);
                    } else {
                        while (self.currentStep >= self.progressStep) {
                            self.currentStep = self.currentStep - self.progressStep;
                            progress.setDone(false);
                            self.handler.handleProgress(self.request, progress);
                        }
                    }
                }
                super.write(source, byteCount);
            }
        };
        return forwardingSink;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.bufferedSink == null) {
            ForwardingSink forwardingSink = this.getSink(sink);
            this.bufferedSink = Okio.buffer((Sink)forwardingSink);
        }
        this.requestBody.writeTo(this.bufferedSink);
        this.bufferedSink.flush();
    }
}

