/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.okhttp3.response;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class OkHttp3ResponseFuture
implements Future<Object> {
    private volatile boolean cancelled;
    private volatile boolean completed;
    private volatile Object result;
    private volatile Exception ex;

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }

    private Object getResult() throws ExecutionException {
        if (this.ex != null) {
            throw new ExecutionException(this.ex);
        }
        return this.result;
    }

    @Override
    public synchronized Object get() throws InterruptedException, ExecutionException {
        while (!this.completed) {
            this.wait();
        }
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long msecs = unit.toMillis(timeout);
        long startTime = msecs <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = msecs;
        if (this.completed) {
            return this.getResult();
        }
        if (waitTime <= 0L) {
            throw new TimeoutException();
        }
        while (true) {
            OkHttp3ResponseFuture okHttp3ResponseFuture = this;
            synchronized (okHttp3ResponseFuture) {
                this.wait(waitTime);
                if (this.completed) {
                    return this.getResult();
                }
                waitTime = msecs - (System.currentTimeMillis() - startTime);
                if (waitTime <= 0L) {
                    throw new TimeoutException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean completed(Object response) {
        OkHttp3ResponseFuture okHttp3ResponseFuture = this;
        synchronized (okHttp3ResponseFuture) {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            this.result = response;
            this.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean failed(Exception exception) {
        OkHttp3ResponseFuture okHttp3ResponseFuture = this;
        synchronized (okHttp3ResponseFuture) {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            this.ex = exception;
            this.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        OkHttp3ResponseFuture okHttp3ResponseFuture = this;
        synchronized (okHttp3ResponseFuture) {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            this.cancelled = true;
            this.notifyAll();
        }
        return true;
    }

    public boolean cancel() {
        return this.cancel(true);
    }
}

