/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.url;

import com.dtflys.forest.backend.url.URLBuilder;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.SimpleQueryParameter;
import com.dtflys.forest.mapping.MappingTemplate;
import com.dtflys.forest.utils.StringUtils;
import com.dtflys.forest.utils.URLUtils;
import java.util.List;

public class QueryableURLBuilder
extends URLBuilder {
    @Override
    public String buildUrl(ForestRequest request, boolean encodeBraceInQueryValue) {
        String ref;
        String url = request.getUrl();
        List<SimpleQueryParameter> queryParameters = request.getQueryValues();
        StringBuilder paramBuilder = new StringBuilder();
        ForestJsonConverter jsonConverter = request.getConfiguration().getJsonConverter();
        for (int i = 0; i < queryParameters.size(); ++i) {
            String value;
            SimpleQueryParameter queryParam = queryParameters.get(i);
            String name = queryParam.getName();
            if (name != null) {
                paramBuilder.append(queryParam.getName());
            }
            if ((value = MappingTemplate.getParameterValue(jsonConverter, queryParam.getValue())) != null) {
                String charset;
                if (name != null) {
                    paramBuilder.append('=');
                }
                if (StringUtils.isBlank(charset = queryParam.getCharset())) {
                    charset = request.getCharset();
                }
                if (StringUtils.isBlank(charset)) {
                    charset = "UTF-8";
                }
                String encodedValue = null;
                encodedValue = queryParam.isUrlencoded() ? URLUtils.allEncode(value, charset) : (encodeBraceInQueryValue ? URLUtils.queryValueEncode(value, charset) : URLUtils.queryValueWithBraceEncode(value, charset));
                if (encodedValue != null) {
                    paramBuilder.append(encodedValue);
                }
            }
            if (i >= queryParameters.size() - 1) continue;
            paramBuilder.append('&');
        }
        StringBuilder urlBuilder = new StringBuilder(url);
        String query = paramBuilder.toString();
        if (StringUtils.isNotEmpty(query)) {
            urlBuilder.append("?").append(query);
        }
        if (StringUtils.isNotEmpty(ref = request.getRef())) {
            urlBuilder.append("#").append(URLUtils.refEncode(ref, "UTF-8"));
        }
        return urlBuilder.toString();
    }
}

