/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.auto;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.converter.ForestEncoder;
import com.dtflys.forest.converter.protobuf.ForestProtobufConverterManager;
import com.dtflys.forest.exceptions.ForestConvertException;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.ReflectUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DefaultAutoConverter
implements ForestConverter<Object> {
    private final ForestConfiguration configuration;
    private final ForestProtobufConverterManager protobufConverterManager = ForestProtobufConverterManager.getInstance();

    public DefaultAutoConverter(ForestConfiguration configuration) {
        this.configuration = configuration;
    }

    private <T> T tryConvert(Object source, Type targetType, ForestDataType dataType) {
        return this.configuration.getConverterMap().get(dataType).convertToJavaObject(source, targetType);
    }

    private byte[] tryEncodeRequest(ForestRequest request, ForestDataType dataType, Charset charset) {
        ForestConverter converter = this.configuration.getConverterMap().get(dataType);
        if (converter == null || !(converter instanceof ForestEncoder)) {
            converter = this.configuration.getConverterMap().get(ForestDataType.TEXT);
        }
        if (converter != null && converter instanceof ForestEncoder) {
            return ((ForestEncoder)((Object)converter)).encodeRequestBody(request, charset);
        }
        throw new ForestRuntimeException("Cannot resolve encoder '" + dataType.getName() + "'");
    }

    @Override
    public <T> T convertToJavaObject(Object source, Type targetType) {
        if (source == null) {
            return null;
        }
        if (source instanceof InputStream || source instanceof byte[] || source instanceof File) {
            if (this.canReadAsBinary(targetType)) {
                return this.tryConvert(source, targetType, ForestDataType.BINARY);
            }
            if (this.protobufConverterManager.isProtobufMessageType(targetType)) {
                return this.tryConvert(source, targetType, ForestDataType.PROTOBUF);
            }
            source = this.readAsString(source);
        }
        Boolean result = null;
        Class<?> clazz = ReflectUtils.toClass(targetType);
        if (source instanceof CharSequence) {
            String str = source.toString();
            if (String.class.isAssignableFrom(clazz)) {
                return (T)str;
            }
            String trimmedStr = str.trim();
            if (trimmedStr.length() == 0) {
                if (CharSequence.class.isAssignableFrom(clazz)) {
                    return this.tryConvert(str, targetType, ForestDataType.TEXT);
                }
                return null;
            }
            char ch = trimmedStr.charAt(0);
            try {
                if (ch == '{' || ch == '[') {
                    result = (Boolean)this.tryConvert(trimmedStr, targetType, ForestDataType.JSON);
                } else if (ch == '<') {
                    result = (Boolean)this.tryConvert(trimmedStr, targetType, ForestDataType.XML);
                } else if (Character.isDigit(ch)) {
                    try {
                        result = (Boolean)this.tryConvert(trimmedStr, targetType, ForestDataType.JSON);
                    }
                    catch (Throwable th) {
                        result = (Boolean)this.tryConvert(source, targetType, ForestDataType.TEXT);
                    }
                } else {
                    result = "true".equalsIgnoreCase(trimmedStr) ? (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) ? Boolean.TRUE : this.tryConvert(trimmedStr, targetType, ForestDataType.TEXT)) : ("false".equalsIgnoreCase(trimmedStr) ? (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) ? Boolean.FALSE : this.tryConvert(trimmedStr, targetType, ForestDataType.TEXT)) : this.tryConvert(source, targetType, ForestDataType.TEXT));
                }
            }
            catch (Throwable th) {
                throw new ForestConvertException(this, th);
            }
        }
        return (T)result;
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Class<T> targetType, Charset charset) {
        return this.convertToJavaObject(source, targetType);
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Type targetType, Charset charset) {
        return this.convertToJavaObject(source, targetType);
    }

    private boolean canReadAsBinary(Class targetType) {
        return byte[].class.isAssignableFrom(targetType) || InputStream.class.isAssignableFrom(targetType) || File.class.isAssignableFrom(targetType);
    }

    private boolean canReadAsBinary(Type targetType) {
        Class<?> type = ReflectUtils.toClass(targetType);
        return byte[].class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type) || File.class.isAssignableFrom(type);
    }

    public String readAsString(Object source) {
        if (source instanceof byte[]) {
            return this.bytesToString((byte[])source);
        }
        if (source instanceof InputStream) {
            return this.inputStreamToString((InputStream)source);
        }
        if (source instanceof File) {
            return this.fileToString((File)source);
        }
        throw new ForestRuntimeException("[Forest] cannot read as string from instance of class '" + source.getClass().getName() + "'");
    }

    private String bytesToString(byte[] bytes) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            return IOUtils.toString((InputStream)byteArrayInputStream);
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
    }

    private String inputStreamToString(InputStream inputStream) {
        try {
            return IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
    }

    public String fileToString(File file) {
        try {
            return FileUtils.readFileToString((File)file);
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
    }

    @Override
    public ForestDataType getDataType() {
        return ForestDataType.AUTO;
    }
}

