/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.form;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.converter.ForestEncoder;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.http.ForestBody;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.body.SupportFormUrlEncoded;
import com.dtflys.forest.mapping.MappingTemplate;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.ReflectUtils;
import com.dtflys.forest.utils.RequestNameValue;
import com.dtflys.forest.utils.StringUtils;
import com.dtflys.forest.utils.URLEncoder;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefaultFormConvertor
implements ForestConverter<String>,
ForestEncoder {
    private final ForestConfiguration configuration;

    public DefaultFormConvertor(ForestConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public <T> T convertToJavaObject(String source, Type targetType) {
        return null;
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Class<T> targetType, Charset charset) {
        return null;
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Type targetType, Charset charset) {
        return null;
    }

    @Override
    public ForestDataType getDataType() {
        return ForestDataType.FORM;
    }

    @Override
    public String encodeToString(Object obj) {
        ForestJsonConverter jsonConverter = this.configuration.getJsonConverter();
        Map<String, Object> map = jsonConverter.convertObjectToMap(obj);
        List<RequestNameValue> nameValueList = new LinkedList<RequestNameValue>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            RequestNameValue nameValue = new RequestNameValue(entry.getKey(), 2);
            nameValue.setValue(entry.getValue());
            nameValueList.add(nameValue);
        }
        nameValueList = this.processFromNameValueList(nameValueList, this.configuration);
        return this.formUrlEncodedString(nameValueList, StandardCharsets.UTF_8);
    }

    protected void processFormCollectionItem(List<RequestNameValue> newNameValueList, ForestConfiguration configuration, String name, Collection collection, int target) {
        int index = 0;
        for (Object item : collection) {
            String subName = name + "[" + index + "]";
            this.processFormItem(newNameValueList, configuration, subName, item, target);
            ++index;
        }
    }

    protected void processFormArrayItem(List<RequestNameValue> newNameValueList, ForestConfiguration configuration, String name, Object array, int target) {
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object item = Array.get(array, i);
            String subName = name + "[" + i + "]";
            this.processFormItem(newNameValueList, configuration, subName, item, target);
        }
    }

    protected void processFormMapItem(List<RequestNameValue> newNameValueList, ForestConfiguration configuration, String name, Map map, int target) {
        for (Map.Entry entry : map.entrySet()) {
            Object mapKey = entry.getKey();
            Object mapValue = entry.getValue();
            String subName = name + "[" + mapKey + "]";
            this.processFormItem(newNameValueList, configuration, subName, mapValue, target);
        }
    }

    protected void processFormItem(List<RequestNameValue> newNameValueList, ForestConfiguration configuration, String name, Object value, int target) {
        block12: {
            Class<?> itemClass;
            block13: {
                block14: {
                    if (StringUtils.isEmpty(name) && value == null) {
                        return;
                    }
                    if (value == null) break block12;
                    itemClass = value.getClass();
                    boolean needCollapse = false;
                    if (value instanceof Collection) {
                        Collection collection = (Collection)value;
                        if (collection.size() <= 8) {
                            for (Object e : collection) {
                                if (ReflectUtils.isPrimaryType(e.getClass())) continue;
                                needCollapse = true;
                                break;
                            }
                        }
                    } else if (itemClass.isArray() && !ReflectUtils.isPrimaryArrayType(itemClass)) {
                        needCollapse = true;
                    }
                    if (!needCollapse) break block13;
                    if (!(value instanceof Collection)) break block14;
                    this.processFormCollectionItem(newNameValueList, configuration, name, (Collection)value, target);
                    break block12;
                }
                if (!itemClass.isArray()) break block12;
                this.processFormArrayItem(newNameValueList, configuration, name, value, target);
                break block12;
            }
            if (ReflectUtils.isPrimaryType(itemClass) || ReflectUtils.isPrimaryArrayType(itemClass) || value instanceof Collection) {
                newNameValueList.add(new RequestNameValue(name, value, target));
            } else if (value instanceof Map) {
                this.processFormMapItem(newNameValueList, configuration, name, (Map)value, target);
            } else {
                Map itemAttrs = ReflectUtils.convertObjectToMap(value, configuration);
                for (Map.Entry entry : itemAttrs.entrySet()) {
                    String subAttrName = (String)entry.getKey();
                    Object subAttrValue = entry.getValue();
                    String subName = name + "." + subAttrName;
                    this.processFormItem(newNameValueList, configuration, subName, subAttrValue, target);
                }
            }
        }
    }

    protected List<RequestNameValue> processFromNameValueList(List<RequestNameValue> nameValueList, ForestConfiguration configuration) {
        LinkedList<RequestNameValue> newNameValueList = new LinkedList<RequestNameValue>();
        for (RequestNameValue nameValue : nameValueList) {
            String name = nameValue.getName();
            Object value = nameValue.getValue();
            int target = nameValue.getTarget();
            this.processFormItem(newNameValueList, configuration, name, value, target);
        }
        return newNameValueList;
    }

    private String formUrlEncodedString(List<RequestNameValue> nameValueList, Charset charset) {
        ForestJsonConverter jsonConverter = this.configuration.getJsonConverter();
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < nameValueList.size(); ++i) {
            RequestNameValue nameValue = nameValueList.get(i);
            if (!nameValue.isInBody()) continue;
            String name = nameValue.getName();
            Object value = nameValue.getValue();
            strBuilder.append(name);
            if (value != null) {
                value = MappingTemplate.getFormValueString(jsonConverter, value);
                strBuilder.append("=").append(URLEncoder.FORM_VALUE.encode(String.valueOf(value), charset));
            }
            if (i >= nameValueList.size() - 1) continue;
            strBuilder.append("&");
        }
        return strBuilder.toString();
    }

    @Override
    public byte[] encodeRequestBody(ForestBody body, Charset charset) {
        List<RequestNameValue> nameValueList = new LinkedList<RequestNameValue>();
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        for (ForestRequestBody bodyItem : body) {
            if (!(bodyItem instanceof SupportFormUrlEncoded)) continue;
            nameValueList.addAll(((SupportFormUrlEncoded)((Object)bodyItem)).getNameValueList(this.configuration));
        }
        nameValueList = this.processFromNameValueList(nameValueList, this.configuration);
        String strBody = this.formUrlEncodedString(nameValueList, charset);
        byte[] bytes = strBody.getBytes(charset);
        return bytes;
    }
}

