/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.json;

import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestConvertException;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ForestJacksonConverter
implements ForestJsonConverter {
    private String dateFormat;
    protected ObjectMapper mapper = new ObjectMapper();

    public ForestJacksonConverter() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        if (StringUtils.isNotBlank(dateFormat)) {
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            this.getMapper().setDateFormat((DateFormat)format);
        }
    }

    @Override
    public <T> T convertToJavaObject(String source, Type targetType) {
        try {
            return (T)this.getMapper().readValue(source, this.getMapper().getTypeFactory().constructType(targetType));
        }
        catch (IOException e) {
            throw new ForestConvertException(this, (Throwable)e);
        }
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Class<T> targetType, Charset charset) {
        try {
            String str = StringUtils.fromBytes(source, charset);
            return (T)this.getMapper().readValue(str, this.getMapper().getTypeFactory().constructType(targetType));
        }
        catch (IOException e) {
            throw new ForestConvertException(this, (Throwable)e);
        }
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Type targetType, Charset charset) {
        try {
            String str = StringUtils.fromBytes(source, charset);
            return (T)this.getMapper().readValue(str, this.getMapper().getTypeFactory().constructType(targetType));
        }
        catch (IOException e) {
            throw new ForestConvertException(this, (Throwable)e);
        }
    }

    public <T> T convertToJavaObject(String source, Class<?> parametrized, Class<?> ... parameterClasses) {
        try {
            JavaType javaType = this.getMapper().getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
            return (T)this.getMapper().readValue(source, javaType);
        }
        catch (IOException e) {
            throw new ForestConvertException(this, (Throwable)e);
        }
    }

    public <T> T convertToJavaObject(String source, JavaType javaType) {
        if (StringUtils.isBlank(source)) {
            return null;
        }
        try {
            return (T)this.getMapper().readValue(source, javaType);
        }
        catch (IOException e) {
            throw new ForestConvertException(this, (Throwable)e);
        }
    }

    @Override
    public String encodeToString(Object obj) {
        try {
            return this.getMapper().writeValueAsString(obj);
        }
        catch (Throwable e) {
            throw new ForestConvertException(this, e);
        }
    }

    @Override
    public Map<String, Object> convertObjectToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            Map objMap = (Map)obj;
            HashMap<String, Object> newMap = new HashMap<String, Object>(objMap.size());
            for (Object key : objMap.keySet()) {
                Object val = objMap.get(key);
                if (val == null) continue;
                newMap.put(String.valueOf(key), val);
            }
            return newMap;
        }
        if (obj instanceof CharSequence) {
            return this.convertToJavaObject(obj.toString(), LinkedHashMap.class);
        }
        MapType javaType = this.getMapper().getTypeFactory().constructMapType(LinkedHashMap.class, String.class, Object.class);
        return (Map)this.getMapper().convertValue(obj, (JavaType)javaType);
    }

    @Override
    public ForestDataType getDataType() {
        return ForestDataType.JSON;
    }
}

