/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.json;

import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.converter.ForestEncoder;
import com.dtflys.forest.http.ForestBody;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.body.ByteArrayRequestBody;
import com.dtflys.forest.http.body.NameValueRequestBody;
import com.dtflys.forest.http.body.ObjectRequestBody;
import com.dtflys.forest.http.body.StringRequestBody;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public interface ForestJsonConverter
extends ForestConverter<String>,
ForestEncoder {
    public Map<String, Object> convertObjectToMap(Object var1);

    public void setDateFormat(String var1);

    public String getDateFormat();

    @Override
    default public byte[] encodeRequestBody(ForestBody body, Charset charset) {
        LinkedList<ForestRequestBody> bodyList;
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        if (!(bodyList = new LinkedList<ForestRequestBody>(body)).isEmpty()) {
            LinkedList<ForestRequestBody> toJsonObj = bodyList;
            if (bodyList.size() == 1) {
                toJsonObj = bodyList.get(0);
            } else {
                LinkedHashMap<String, Object> jsonMap = null;
                LinkedList<String> jsonArray = null;
                for (ForestRequestBody bodyItem : bodyList) {
                    Object obj;
                    Map<String, Object> subMap;
                    if (bodyItem instanceof NameValueRequestBody) {
                        if (jsonMap == null) {
                            jsonMap = new LinkedHashMap<String, Object>(bodyList.size());
                        }
                        jsonMap.put(((NameValueRequestBody)bodyItem).getName(), ((NameValueRequestBody)bodyItem).getValue());
                        continue;
                    }
                    if (bodyItem instanceof StringRequestBody) {
                        String content = bodyItem.toString();
                        subMap = this.convertObjectToMap(content);
                        if (subMap != null) {
                            if (jsonMap == null) {
                                jsonMap = new LinkedHashMap(bodyList.size());
                            }
                            jsonMap.putAll(subMap);
                            continue;
                        }
                        if (jsonArray == null) {
                            jsonArray = new LinkedList<String>();
                        }
                        jsonArray.add(content);
                        continue;
                    }
                    if (!(bodyItem instanceof ObjectRequestBody) || (obj = ((ObjectRequestBody)bodyItem).getObject()) == null) continue;
                    if (obj instanceof List) {
                        if (jsonArray == null) {
                            jsonArray = new LinkedList();
                        }
                        jsonArray.addAll((List)obj);
                        continue;
                    }
                    subMap = this.convertObjectToMap(obj);
                    if (subMap == null) continue;
                    if (jsonMap == null) {
                        jsonMap = new LinkedHashMap(bodyList.size());
                    }
                    jsonMap.putAll(subMap);
                }
                if (jsonMap != null) {
                    toJsonObj = jsonMap;
                } else if (jsonArray != null) {
                    toJsonObj = jsonArray;
                }
            }
            String text = null;
            if (toJsonObj instanceof CharSequence || toJsonObj instanceof StringRequestBody) {
                text = ((Object)toJsonObj).toString();
                return text.getBytes(charset);
            }
            if (toJsonObj instanceof ObjectRequestBody) {
                text = this.encodeToString(((ObjectRequestBody)((Object)toJsonObj)).getObject());
                return text.getBytes(charset);
            }
            if (toJsonObj instanceof NameValueRequestBody) {
                HashMap<String, Object> subMap = new HashMap<String, Object>(1);
                subMap.put(((NameValueRequestBody)((Object)toJsonObj)).getName(), ((NameValueRequestBody)((Object)toJsonObj)).getValue());
                text = this.encodeToString(subMap);
                return text.getBytes(charset);
            }
            if (toJsonObj instanceof ByteArrayRequestBody) {
                byte[] bytes = ((ByteArrayRequestBody)((Object)toJsonObj)).getByteArray();
                return bytes;
            }
            text = this.encodeToString(toJsonObj);
            return text.getBytes(charset);
        }
        return new byte[0];
    }
}

