/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.extensions;

import com.dtflys.forest.annotation.MethodLifeCycle;
import com.dtflys.forest.annotation.RequestAttributes;
import com.dtflys.forest.handler.AutoOAuth2DefinitionHandler;
import com.dtflys.forest.handler.OAuth2DefinitionHandler;
import com.dtflys.forest.lifecycles.authorization.OAuth2LifeCycle;
import com.dtflys.forest.utils.StringUtils;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.annotation.Nonnull;

@Documented
@MethodLifeCycle(value=OAuth2LifeCycle.class)
@RequestAttributes
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface OAuth2 {
    @Nonnull
    public String tokenUri();

    public String cacheId() default "";

    @Nonnull
    public String clientId();

    @Nonnull
    public String clientSecret();

    @Nonnull
    public GrantType grantType() default GrantType.CLIENT_CREDENTIALS;

    public String grantTypeValue() default "";

    public String scope() default "";

    public int refreshAtExpiresBefore() default 600;

    public String username() default "";

    public String password() default "";

    public String[] query() default {};

    public String[] body() default {};

    @Nonnull
    public TokenAt tokenAt() default TokenAt.HEADER;

    public String tokenVariable() default "";

    public String tokenPrefix() default "";

    public Class<? extends OAuth2DefinitionHandler> OAuth2TokenHandler() default AutoOAuth2DefinitionHandler.class;

    public static enum TokenAt {
        HEADER("Authorization", "Bearer"),
        URL("access_token", "");

        private final String tokenVariable;
        private final String tokenPrefix;

        private TokenAt(String tokenVariable, String tokenPrefix) {
            this.tokenVariable = tokenVariable;
            this.tokenPrefix = tokenPrefix;
        }

        public String getTokenVariable() {
            return this.tokenVariable;
        }

        public String getTokenPrefix() {
            return this.tokenPrefix;
        }

        public String getTokenVariable(String defaultTokenVariable) {
            if (StringUtils.isBlank(defaultTokenVariable)) {
                return this.tokenVariable;
            }
            return defaultTokenVariable;
        }

        public String getTokenValue(String defaultPrefix, String token) {
            String prefix = defaultPrefix;
            if (StringUtils.isBlank(prefix)) {
                prefix = this.tokenPrefix;
            }
            if (StringUtils.isBlank(prefix)) {
                return token;
            }
            return prefix + " " + token;
        }
    }

    public static enum GrantType {
        PASSWORD("password"),
        CLIENT_CREDENTIALS("client_credentials");

        private final String value;

        private GrantType(String value) {
            this.value = value;
        }

        public String getValue(String defaultValue) {
            if (StringUtils.isBlank(defaultValue)) {
                return this.value;
            }
            return defaultValue;
        }
    }
}

