/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.body.ByteArrayRequestBody;
import com.dtflys.forest.http.body.FileRequestBody;
import com.dtflys.forest.http.body.InputStreamRequestBody;
import com.dtflys.forest.http.body.NameValueRequestBody;
import com.dtflys.forest.http.body.ObjectRequestBody;
import com.dtflys.forest.http.body.StringRequestBody;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.Validations;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;

public class ForestBody
implements List<ForestRequestBody> {
    private final ForestConfiguration configuration;
    private ForestDataType defaultBodyType = ForestDataType.BINARY;
    private ForestDataType bodyType;
    private List<ForestRequestBody> bodyItems = new LinkedList<ForestRequestBody>();

    public ForestBody(ForestConfiguration configuration) {
        this.configuration = configuration;
    }

    public NameValueRequestBody getNameValueBody(String name) {
        Validations.assertParamNotEmpty(name, "name");
        for (ForestRequestBody body : this.bodyItems) {
            if (!(body instanceof NameValueRequestBody) || !name.equals(((NameValueRequestBody)body).getName())) continue;
            return (NameValueRequestBody)body;
        }
        return null;
    }

    public List<NameValueRequestBody> getNameValueBodies(String name) {
        LinkedList<NameValueRequestBody> bodies = new LinkedList<NameValueRequestBody>();
        Validations.assertParamNotEmpty(name, "name");
        for (ForestRequestBody body : this.bodyItems) {
            if (!(body instanceof NameValueRequestBody) || !name.equals(((NameValueRequestBody)body).getName())) continue;
            bodies.add((NameValueRequestBody)body);
        }
        return bodies;
    }

    public Map<String, Object> nameValuesMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (ForestRequestBody body : this.bodyItems) {
            NameValueRequestBody nameValueRequestBody;
            String name;
            if (!(body instanceof NameValueRequestBody) || map.containsKey(name = (nameValueRequestBody = (NameValueRequestBody)body).getName())) continue;
            map.put(name, nameValueRequestBody.getValue());
        }
        return map;
    }

    public Map<String, Object> nameValuesMapWithObject() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ForestJsonConverter jsonConverter = this.configuration.getJsonConverter();
        for (ForestRequestBody body : this.bodyItems) {
            if (body instanceof NameValueRequestBody) {
                NameValueRequestBody nameValueRequestBody = (NameValueRequestBody)body;
                String name = nameValueRequestBody.getName();
                if (map.containsKey(name)) continue;
                map.put(name, nameValueRequestBody.getValue());
                continue;
            }
            if (!(body instanceof ObjectRequestBody)) continue;
            ObjectRequestBody objectRequestBody = (ObjectRequestBody)body;
            Map<String, Object> keyValueMap = jsonConverter.convertObjectToMap(objectRequestBody.getObject());
            for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (map.containsKey(name)) continue;
                map.put(name, value);
            }
        }
        return map;
    }

    public <T extends ForestRequestBody> List<T> getItems(Class<T> bodyItemClass) {
        LinkedList<ForestRequestBody> items = new LinkedList<ForestRequestBody>();
        for (ForestRequestBody item : this.bodyItems) {
            Class<?> itemClass = item.getClass();
            if (!bodyItemClass.isAssignableFrom(itemClass)) continue;
            items.add(item);
        }
        return items;
    }

    public List<StringRequestBody> getStringItems() {
        return this.getItems(StringRequestBody.class);
    }

    public List<NameValueRequestBody> getNameValueItems() {
        return this.getItems(NameValueRequestBody.class);
    }

    public List<ObjectRequestBody> getObjectItems() {
        return this.getItems(ObjectRequestBody.class);
    }

    public List<ByteArrayRequestBody> getByteArrayItems() {
        return this.getItems(ByteArrayRequestBody.class);
    }

    public List<InputStreamRequestBody> getInputStreamItems() {
        return this.getItems(InputStreamRequestBody.class);
    }

    public List<FileRequestBody> getFileItems() {
        return this.getItems(FileRequestBody.class);
    }

    public ForestDataType getDefaultBodyType() {
        return this.defaultBodyType;
    }

    public ForestDataType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(ForestDataType bodyType) {
        this.bodyType = bodyType;
    }

    @Override
    public int size() {
        return this.bodyItems.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bodyItems.isEmpty();
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        for (ForestRequestBody body : this.bodyItems) {
            if (!(body instanceof NameValueRequestBody) || !key.equals(((NameValueRequestBody)body).getName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (ForestRequestBody body : this.bodyItems) {
            byte[] bytes;
            if (body instanceof NameValueRequestBody && value.equals(((NameValueRequestBody)body).getValue())) {
                return true;
            }
            if (body instanceof ObjectRequestBody && value.equals(((ObjectRequestBody)body).getObject())) {
                return true;
            }
            if (body instanceof StringRequestBody && value.equals(((StringRequestBody)body).getContent())) {
                return true;
            }
            if (!byte[].class.isAssignableFrom(value.getClass()) || !Objects.equals(bytes = body.getByteArray(), bytes)) continue;
            return true;
        }
        return false;
    }

    public Object setNameValue(String key, Object value) {
        if (key == null) {
            return null;
        }
        NameValueRequestBody body = this.getNameValueBody(key);
        Object oldValue = null;
        if (key != null) {
            oldValue = body.getValue();
            body.setValue(value);
        }
        return oldValue;
    }

    @Override
    public boolean contains(Object o) {
        return this.bodyItems.contains(o);
    }

    @Override
    public Iterator<ForestRequestBody> iterator() {
        return this.bodyItems.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.bodyItems.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.bodyItems.toArray(a);
    }

    @Override
    public boolean add(ForestRequestBody forestRequestBody) {
        if (this.bodyType == null) {
            this.defaultBodyType = forestRequestBody.getDefaultBodyType();
        }
        return this.bodyItems.add(forestRequestBody);
    }

    @Override
    public boolean remove(Object o) {
        return this.bodyItems.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.bodyItems.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends ForestRequestBody> c) {
        return this.bodyItems.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ForestRequestBody> c) {
        return this.bodyItems.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.bodyItems.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.bodyItems.retainAll(c);
    }

    @Override
    public void clear() {
        this.bodyItems.clear();
    }

    @Override
    public ForestRequestBody get(int index) {
        return this.bodyItems.get(index);
    }

    @Override
    public ForestRequestBody set(int index, ForestRequestBody element) {
        return this.bodyItems.set(index, element);
    }

    @Override
    public void add(int index, ForestRequestBody element) {
        this.bodyItems.add(index, element);
    }

    @Override
    public ForestRequestBody remove(int index) {
        return this.bodyItems.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.bodyItems.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.bodyItems.lastIndexOf(o);
    }

    @Override
    public ListIterator<ForestRequestBody> listIterator() {
        return this.bodyItems.listIterator();
    }

    @Override
    public ListIterator<ForestRequestBody> listIterator(int index) {
        return this.bodyItems.listIterator();
    }

    @Override
    public List<ForestRequestBody> subList(int fromIndex, int toIndex) {
        return this.bodyItems.subList(fromIndex, toIndex);
    }
}

