/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.http.ForestCookie;
import com.dtflys.forest.http.ForestHeader;
import com.dtflys.forest.http.ForestURL;
import com.dtflys.forest.http.HasURL;
import com.dtflys.forest.utils.StringUtils;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ForestCookieHeader
extends ForestHeader {
    private final Map<String, Map<String, ForestCookie>> cookies = new LinkedHashMap<String, Map<String, ForestCookie>>();
    private final HasURL hasURL;

    public ForestCookieHeader(HasURL hasURL) {
        super("Cookie", null);
        this.hasURL = hasURL;
    }

    public List<ForestCookie> getCookies(String name) {
        LinkedList<ForestCookie> results = new LinkedList<ForestCookie>();
        for (Map<String, ForestCookie> map : this.cookies.values()) {
            ForestCookie cookie = map.get(name.toLowerCase());
            if (cookie == null) continue;
            results.add(cookie);
        }
        return results;
    }

    public Map<String, ForestCookie> getCookieMap(String path) {
        return this.cookies.get(path);
    }

    public ForestCookie getCookie(String name) {
        for (Map.Entry<String, Map<String, ForestCookie>> entry : this.cookies.entrySet()) {
            Map<String, ForestCookie> map = entry.getValue();
            ForestCookie cookie = map.get(name.toLowerCase());
            if (cookie == null) continue;
            return cookie;
        }
        return null;
    }

    public ForestCookie getCookie(String path, String name) {
        Map<String, ForestCookie> map = this.getCookieMap(path);
        if (map == null) {
            return null;
        }
        ForestCookie cookie = map.get(name.toLowerCase());
        if (cookie != null) {
            return cookie;
        }
        return null;
    }

    public ForestCookie removeCookie(ForestCookie cookie) {
        Map<String, ForestCookie> map = this.getCookieMap(cookie.getPath());
        if (map == null) {
            return null;
        }
        return map.remove(cookie);
    }

    public boolean addCookie(ForestCookie cookie) {
        return this.addCookie(cookie, true);
    }

    public boolean addCookie(ForestCookie cookie, boolean strict) {
        if (cookie == null) {
            return false;
        }
        ForestURL url = this.hasURL.url();
        if (strict && !cookie.matchURL(url)) {
            return false;
        }
        if (strict && cookie.isExpired(new Date())) {
            return false;
        }
        String name = cookie.getName();
        if (StringUtils.isBlank(name)) {
            return false;
        }
        String path = cookie.getPath();
        Map<String, ForestCookie> map = this.getCookieMap(path);
        if (map == null) {
            map = new LinkedHashMap<String, ForestCookie>();
            this.cookies.put(path, map);
        }
        map.put(name.toLowerCase(), cookie);
        return true;
    }

    public void addCookies(List<ForestCookie> cookies) {
        for (ForestCookie cookie : cookies) {
            this.addCookie(cookie);
        }
    }

    public List<ForestCookie> getCookies() {
        LinkedList<ForestCookie> results = new LinkedList<ForestCookie>();
        for (Map<String, ForestCookie> map : this.cookies.values()) {
            for (ForestCookie cookie : map.values()) {
                results.add(cookie);
            }
        }
        return results;
    }

    @Override
    public String getValue() {
        List<ForestCookie> list = this.getCookies();
        int len = list.size();
        if (len == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            ForestCookie cookie = list.get(i);
            builder.append(cookie.getName()).append("=").append(cookie.getValue());
            if (i >= len - 1) continue;
            builder.append("; ");
        }
        return builder.toString();
    }
}

