/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.http.ForestCookie;
import com.dtflys.forest.utils.StringUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ForestCookies
implements Iterable<ForestCookie> {
    private List<ForestCookie> cookies;
    private boolean strict = true;

    public ForestCookies() {
        this.cookies = new LinkedList<ForestCookie>();
    }

    public ForestCookies(List<ForestCookie> cookies) {
        this.cookies = cookies;
    }

    public int size() {
        return this.cookies.size();
    }

    public boolean strict() {
        return this.strict;
    }

    public ForestCookies strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public static ForestCookies parse(String content) {
        String[] pairs;
        ForestCookies cookies = new ForestCookies();
        if (StringUtils.isBlank(content)) {
            return cookies;
        }
        for (String pair : pairs = content.split(";")) {
            String[] nameValue = pair.split("=", 2);
            if (nameValue.length < 2) continue;
            String name = nameValue[0].trim();
            String value = nameValue[1].trim();
            ForestCookie cookie = new ForestCookie(name, value);
            cookies.addCookie(cookie);
        }
        return cookies;
    }

    public List<ForestCookie> getCookies(String domain) {
        LinkedList<ForestCookie> list = new LinkedList<ForestCookie>();
        for (ForestCookie cookie : this.cookies) {
            if (!cookie.matchDomain(domain)) continue;
            list.add(cookie);
        }
        return list;
    }

    public List<ForestCookie> getCookies(String domain, String path) {
        LinkedList<ForestCookie> list = new LinkedList<ForestCookie>();
        for (ForestCookie cookie : this.cookies) {
            if (!cookie.matchDomain(domain) || !cookie.matchPath(path)) continue;
            list.add(cookie);
        }
        return list;
    }

    public List<ForestCookie> getCookies(String domain, String path, String name) {
        LinkedList<ForestCookie> list = new LinkedList<ForestCookie>();
        for (ForestCookie cookie : this.cookies) {
            if (!cookie.matchDomain(domain) || !cookie.matchPath(path) || !cookie.getName().equals(name)) continue;
            list.add(cookie);
        }
        return list;
    }

    public ForestCookies addCookie(ForestCookie cookie) {
        if (cookie != null) {
            this.cookies.add(cookie);
        }
        return this;
    }

    public ForestCookies addAllCookies(List<ForestCookie> cookies) {
        if (cookies == null) {
            return this;
        }
        for (ForestCookie cookie : cookies) {
            this.addCookie(cookie);
        }
        return this;
    }

    public List<String> domains() {
        LinkedList<String> results = new LinkedList<String>();
        for (ForestCookie cookie : this.cookies) {
            results.add(cookie.getDomain());
        }
        return Collections.unmodifiableList(results);
    }

    public List<String> paths(String domain) {
        LinkedList<String> results = new LinkedList<String>();
        for (ForestCookie cookie : this.cookies) {
            if (!cookie.getDomain().equals(domain)) continue;
            results.add(cookie.getPath());
        }
        return Collections.unmodifiableList(results);
    }

    public List<String> names() {
        LinkedList<String> results = new LinkedList<String>();
        for (ForestCookie cookie : this.cookies) {
            results.add(cookie.getName());
        }
        return Collections.unmodifiableList(results);
    }

    public List<ForestCookie> allCookies() {
        return this.cookies;
    }

    @Override
    public Iterator<ForestCookie> iterator() {
        return this.cookies.iterator();
    }
}

