/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.http.ForestHeader;
import com.dtflys.forest.http.ForestHeaderMap;
import com.dtflys.forest.http.ForestURL;
import com.dtflys.forest.http.ForestURLBuilder;
import com.dtflys.forest.http.HasURL;
import com.dtflys.forest.utils.RequestNameValue;
import com.dtflys.forest.utils.StringUtils;
import java.util.List;

public class ForestProxy
implements HasURL {
    private final String host;
    private final int port;
    private String username;
    private String password;
    private ForestHeaderMap headers = new ForestHeaderMap(this);

    public ForestProxy(String ip, int port) {
        this.host = ip;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public ForestProxy setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ForestProxy setPassword(String password) {
        this.password = password;
        return this;
    }

    public ForestHeaderMap getHeaders() {
        return this.headers;
    }

    public ForestHeader getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    public ForestProxy addHeader(String name, Object value) {
        if (StringUtils.isEmpty(name)) {
            return this;
        }
        this.headers.setHeader(name, String.valueOf(value));
        return this;
    }

    public ForestProxy addHeader(RequestNameValue nameValue) {
        this.addHeader(nameValue.getName(), nameValue.getValue());
        return this;
    }

    public ForestProxy addHeaders(List<RequestNameValue> nameValues) {
        for (RequestNameValue nameValue : nameValues) {
            this.addHeader(nameValue.getName(), nameValue.getValue());
        }
        return this;
    }

    @Override
    public ForestURL url() {
        return new ForestURLBuilder().setHost(this.host).setPort(this.port).build();
    }
}

