/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.http.SimpleQueryParameter;
import com.dtflys.forest.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ForestQueryMap
implements Map<String, Object> {
    private final List<SimpleQueryParameter> queries = new LinkedList<SimpleQueryParameter>();

    @Override
    public int size() {
        return this.queries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queries.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        String name = key.toString();
        for (SimpleQueryParameter query : this.queries) {
            if (!query.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (SimpleQueryParameter query : this.queries) {
            Object queryVal = query.getValue();
            if (!(queryVal == null ? value == null : queryVal.equals(value))) continue;
            return true;
        }
        return false;
    }

    public SimpleQueryParameter getQuery(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (SimpleQueryParameter query : this.queries) {
            if (!query.getName().equalsIgnoreCase(name)) continue;
            return query;
        }
        return null;
    }

    public List<SimpleQueryParameter> getQueries(String name) {
        LinkedList<SimpleQueryParameter> list = new LinkedList<SimpleQueryParameter>();
        if (StringUtils.isEmpty(name)) {
            return list;
        }
        for (SimpleQueryParameter query : this.queries) {
            if (!query.getName().equalsIgnoreCase(name)) continue;
            list.add(query);
        }
        return list;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        String name = key.toString();
        SimpleQueryParameter query = this.getQuery(name);
        if (query == null) {
            return null;
        }
        return query.getValue();
    }

    public void addQuery(SimpleQueryParameter query) {
        this.queries.add(query);
    }

    public void addAllQueries(ForestQueryMap queries) {
        if (queries != null) {
            this.queries.addAll(queries.queries);
        }
    }

    public void addQuery(String name, Object value) {
        this.addQuery(name, value, false, null);
    }

    public void addQuery(String name, Object value, boolean isUrlEncode, String charset) {
        if (value instanceof Collection) {
            this.addQuery(name, (Collection)value, isUrlEncode, charset);
        } else {
            this.queries.add(new SimpleQueryParameter(name, value, isUrlEncode, charset));
        }
    }

    public void addQuery(String name, Collection collection) {
        this.addQuery(name, collection, false, null);
    }

    public void addQuery(String name, Collection collection, boolean isUrlEncode, String charset) {
        for (Object item : collection) {
            this.addQuery(name, item, isUrlEncode, charset);
        }
    }

    public void addQuery(String name, Object[] array) {
        this.addQuery(name, array, false, (String)null);
    }

    public void addQuery(String name, Object[] array, boolean isUrlEncode, String charset) {
        for (Object item : array) {
            this.addQuery(name, item, isUrlEncode, charset);
        }
    }

    public void addQuery(Map map) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            this.addQuery(String.valueOf(key), value);
        }
    }

    public void addQuery(Map map, boolean isUrlEncode, String charset) {
        if (map == null) {
            return;
        }
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            this.addQuery(String.valueOf(key), value, isUrlEncode, charset);
        }
    }

    public void addArrayQuery(String name, Collection collection) {
        this.addArrayQuery(name, collection, false, null);
    }

    public void addArrayQuery(String name, Collection collection, boolean isUrlEncode, String charset) {
        for (Object item : collection) {
            this.addQuery(name + "[]", item, isUrlEncode, charset);
        }
    }

    public void addArrayQuery(String name, Object[] array) {
        this.addArrayQuery(name, array, false, null);
    }

    public void addArrayQuery(String name, Object[] array, boolean isUrlEncode, String charset) {
        for (Object item : array) {
            this.addQuery(name + "[]", item, isUrlEncode, charset);
        }
    }

    @Override
    public Object put(String key, Object value) {
        SimpleQueryParameter query = this.getQuery(key);
        if (query != null) {
            query.setValue(value);
        } else {
            SimpleQueryParameter newQuery = new SimpleQueryParameter(key, value);
            this.addQuery(newQuery);
        }
        return value;
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        String name = key.toString();
        for (int i = this.queries.size() - 1; i >= 0; --i) {
            SimpleQueryParameter query = this.queries.get(i);
            if (!query.getName().equalsIgnoreCase(name)) continue;
            SimpleQueryParameter removedQuery = this.queries.remove(i);
            return removedQuery.getValue();
        }
        return null;
    }

    public List<SimpleQueryParameter> removeQueries(String name) {
        LinkedList<SimpleQueryParameter> list = new LinkedList<SimpleQueryParameter>();
        if (name == null) {
            return list;
        }
        for (int i = this.queries.size() - 1; i >= 0; --i) {
            SimpleQueryParameter query = this.queries.get(i);
            if (!query.getName().equalsIgnoreCase(name)) continue;
            SimpleQueryParameter removedQuery = this.queries.remove(i);
            list.add(0, removedQuery);
        }
        return list;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            this.put(name, value);
        }
    }

    @Override
    public void clear() {
        this.queries.clear();
    }

    public void clearQueriesFromUrl() {
        int len = this.queries.size();
        for (int i = len - 1; i >= 0; --i) {
            SimpleQueryParameter query = this.queries.get(i);
            if (!query.isFromUrl()) continue;
            this.queries.remove(i);
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        for (SimpleQueryParameter query : this.queries) {
            set.add(query.getName());
        }
        return set;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (SimpleQueryParameter query : this.queries) {
            Object val = query.getValue();
            if (val == null) continue;
            list.add(val);
        }
        return list;
    }

    public List<SimpleQueryParameter> queryValues() {
        return this.queries;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
        for (final SimpleQueryParameter query : this.queries) {
            Map.Entry<String, Object> entry = new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return query.getName();
                }

                @Override
                public Object getValue() {
                    return query.getValue();
                }

                @Override
                public Object setValue(Object value) {
                    Object oldValue = query.getValue();
                    query.setValue(value);
                    return oldValue;
                }
            };
            set.add(entry);
        }
        return set;
    }

    public ForestQueryMap clone() {
        ForestQueryMap newQueryMap = new ForestQueryMap();
        for (SimpleQueryParameter query : this.queries) {
            newQueryMap.addQuery(query);
        }
        return newQueryMap;
    }
}

