/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.auth.BasicAuth;
import com.dtflys.forest.auth.ForestAuthenticator;
import com.dtflys.forest.backend.HttpBackend;
import com.dtflys.forest.backend.HttpExecutor;
import com.dtflys.forest.callback.OnCanceled;
import com.dtflys.forest.callback.OnError;
import com.dtflys.forest.callback.OnLoadCookie;
import com.dtflys.forest.callback.OnProgress;
import com.dtflys.forest.callback.OnRedirection;
import com.dtflys.forest.callback.OnRetry;
import com.dtflys.forest.callback.OnSaveCookie;
import com.dtflys.forest.callback.OnSuccess;
import com.dtflys.forest.callback.RetryWhen;
import com.dtflys.forest.callback.SuccessWhen;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.converter.ForestEncoder;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestAsyncAbortException;
import com.dtflys.forest.exceptions.ForestRetryException;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.exceptions.ForestVariableUndefinedException;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestAddress;
import com.dtflys.forest.http.ForestAsyncMode;
import com.dtflys.forest.http.ForestBody;
import com.dtflys.forest.http.ForestCookie;
import com.dtflys.forest.http.ForestCookies;
import com.dtflys.forest.http.ForestFuture;
import com.dtflys.forest.http.ForestHeader;
import com.dtflys.forest.http.ForestHeaderMap;
import com.dtflys.forest.http.ForestProtocol;
import com.dtflys.forest.http.ForestProxy;
import com.dtflys.forest.http.ForestQueryMap;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.ForestRequestType;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.http.ForestResponseFactory;
import com.dtflys.forest.http.ForestRoute;
import com.dtflys.forest.http.ForestURL;
import com.dtflys.forest.http.HasURL;
import com.dtflys.forest.http.SimpleQueryParameter;
import com.dtflys.forest.http.body.ByteArrayRequestBody;
import com.dtflys.forest.http.body.FileRequestBody;
import com.dtflys.forest.http.body.InputStreamRequestBody;
import com.dtflys.forest.http.body.NameValueRequestBody;
import com.dtflys.forest.http.body.ObjectRequestBody;
import com.dtflys.forest.http.body.StringRequestBody;
import com.dtflys.forest.interceptor.Interceptor;
import com.dtflys.forest.interceptor.InterceptorAttributes;
import com.dtflys.forest.interceptor.InterceptorChain;
import com.dtflys.forest.lifecycles.file.DownloadLifeCycle;
import com.dtflys.forest.logging.LogConfiguration;
import com.dtflys.forest.logging.RequestLogMessage;
import com.dtflys.forest.mapping.MappingURLTemplate;
import com.dtflys.forest.mapping.MappingVariable;
import com.dtflys.forest.multipart.ByteArrayMultipart;
import com.dtflys.forest.multipart.FileMultipart;
import com.dtflys.forest.multipart.ForestMultipart;
import com.dtflys.forest.multipart.InputStreamMultipart;
import com.dtflys.forest.pool.ForestRequestPool;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.reflection.MethodLifeCycleHandler;
import com.dtflys.forest.retryer.ForestRetryer;
import com.dtflys.forest.ssl.SSLKeyStore;
import com.dtflys.forest.ssl.SSLSocketFactoryBuilder;
import com.dtflys.forest.ssl.SSLUtils;
import com.dtflys.forest.ssl.TrustAllHostnameVerifier;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.RequestNameValue;
import com.dtflys.forest.utils.StringUtils;
import com.dtflys.forest.utils.TimeUtils;
import com.dtflys.forest.utils.TypeReference;
import com.dtflys.forest.utils.URLUtils;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class ForestRequest<T>
implements HasURL {
    private static final Object[] EMPTY_RENDER_ARGS = new Object[0];
    private static final long DEFAULT_PROGRESS_STEP = 10240L;
    private final ForestConfiguration configuration;
    private final ForestMethod method;
    private HttpBackend backend;
    private Object backendClient;
    private boolean cacheBackendClient = true;
    private HttpExecutor executor;
    private volatile LifeCycleHandler lifeCycleHandler;
    private ForestProtocol protocol = ForestProtocol.HTTP_1_1;
    private volatile boolean canceled = false;
    private ForestURL url;
    private ForestQueryMap query = new ForestQueryMap();
    private ForestRequestType type;
    private List<ForestRequestType> typeChangeHistory;
    private RequestLogMessage requestLogMessage;
    private String charset;
    private String responseEncode;
    private boolean async;
    private ForestAsyncMode asyncMode = ForestAsyncMode.PLATFORM;
    private ForestAuthenticator authenticator = new BasicAuth();
    private boolean autoRedirection;
    private ForestDataType dataType;
    private int timeout = 3000;
    private Integer connectTimeout = -1;
    private Integer readTimeout = -1;
    private boolean decompressResponseGzipEnabled = false;
    private String sslProtocol;
    private int maxRetryCount = 0;
    private long maxRetryInterval = 0L;
    private final ForestBody body;
    private ForestHeaderMap headers = new ForestHeaderMap(this);
    private List<ForestMultipart> multiparts = new LinkedList<ForestMultipart>();
    private String filename;
    private final Object[] arguments;
    private OnSuccess onSuccess;
    private OnError onError;
    private OnCanceled onCanceled;
    private SuccessWhen successWhen;
    private OnRetry onRetry;
    private RetryWhen retryWhen;
    private OnRedirection onRedirection;
    ForestRequest<?> prevRequest;
    ForestResponse<?> prevResponse;
    private OnProgress onProgress;
    private OnLoadCookie onLoadCookie;
    private OnSaveCookie onSaveCookie;
    private boolean isDownloadFile = false;
    private long progressStep = 10240L;
    private InterceptorChain interceptorChain = new InterceptorChain();
    private Map<Class, InterceptorAttributes> interceptorAttributes = new ConcurrentHashMap<Class, InterceptorAttributes>();
    private ForestRetryer retryer;
    private boolean retryEnabled = true;
    private Map<String, Object> attachments = new ConcurrentHashMap<String, Object>();
    private ForestEncoder encoder;
    private ForestConverter decoder;
    private LogConfiguration logConfiguration;
    private SSLKeyStore keyStore;
    private HostnameVerifier hostnameVerifier;
    private TrustManager trustManager;
    private SSLSocketFactoryBuilder sslSocketFactoryBuilder;
    private ForestProxy proxy;

    public ForestRequest(ForestConfiguration configuration, ForestMethod method, Object[] arguments) {
        this(configuration, method, arguments, new ForestBody(configuration));
    }

    public ForestRequest(ForestConfiguration configuration, ForestMethod method, Object[] arguments, ForestBody body) {
        this.configuration = configuration;
        this.method = method;
        this.arguments = arguments;
        this.body = body;
    }

    public ForestRequest(ForestConfiguration configuration, ForestMethod method) {
        this(configuration, method, new Object[0]);
    }

    public ForestRequest(ForestConfiguration configuration) {
        this(configuration, null, new Object[0]);
    }

    public ForestRequest(ForestConfiguration configuration, Object[] arguments) {
        this(configuration, null, arguments);
    }

    public ForestConfiguration getConfiguration() {
        return this.configuration;
    }

    public ForestProtocol getProtocol() {
        return this.protocol;
    }

    public ForestRequest<T> setProtocol(ForestProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public ForestURL url() {
        return this.url;
    }

    public ForestRequest<T> url(ForestURL url) {
        this.url = url;
        return this;
    }

    public ForestRequest<T> url(String url) {
        return this.setUrl(url);
    }

    public String getUrl() {
        return this.url.getOriginalUrl();
    }

    public String urlString() {
        return this.url.toString();
    }

    public URI getURI() {
        return this.url.toURI();
    }

    public ForestRoute getRoute() {
        return this.url.getRoute();
    }

    public ForestRoute route() {
        return this.getRoute();
    }

    public ForestRequest<T> setUrl(MappingURLTemplate urlTemplate, Object ... args) {
        if (!this.query.isEmpty()) {
            this.query.clearQueriesFromUrl();
        }
        ForestURL newUrl = urlTemplate.render(args, this.query);
        this.url = this.url == null ? newUrl : newUrl.mergeURLWith(this.url);
        return this;
    }

    public ForestRequest<T> setUrl(String url, Object ... args) {
        if (StringUtils.isBlank(url)) {
            throw new ForestRuntimeException("[Forest] Request url cannot be empty!");
        }
        String srcUrl = StringUtils.trimBegin(url);
        MappingURLTemplate template = this.method.makeURLTemplate(null, null, srcUrl);
        return this.setUrl(template, args);
    }

    public ForestRequest<T> setUrl(String url) {
        return this.setUrl(url, EMPTY_RENDER_ARGS);
    }

    public String getUserInfo() {
        return this.url.getUserInfo();
    }

    public String userInfo() {
        return this.getUserInfo();
    }

    public ForestRequest<T> setUserInfo(String userInfo) {
        this.url.setUserInfo(userInfo);
        return this;
    }

    public ForestRequest<T> userInfo(String userInfo) {
        return this.setUserInfo(userInfo);
    }

    public ForestRequest<T> setScheme(String scheme) {
        this.url.setScheme(scheme);
        return this;
    }

    public ForestRequest<T> scheme(String scheme) {
        return this.setScheme(scheme);
    }

    public String getScheme() {
        return this.url.getScheme();
    }

    public String scheme() {
        return this.getScheme();
    }

    public ForestRequest<T> setHost(String host) {
        this.url.setHost(host);
        return this;
    }

    public ForestRequest<T> host(String host) {
        return this.setHost(host);
    }

    public String getHost() {
        return this.url.getHost();
    }

    public String host() {
        return this.getHost();
    }

    public ForestRequest<T> setPort(int port) {
        this.url.setPort(port);
        return this;
    }

    public ForestRequest<T> port(int port) {
        return this.setPort(port);
    }

    public int getPort() {
        return this.url.getPort();
    }

    public int port() {
        return this.getPort();
    }

    public ForestRequest<T> setAddress(ForestAddress address) {
        this.url.setAddress(address);
        return this;
    }

    public ForestRequest<T> setAddress(ForestAddress address, boolean forced) {
        this.url.setAddress(address, forced);
        return this;
    }

    public ForestRequest<T> setAddress(String host, int port) {
        return this.setAddress(new ForestAddress(host, port));
    }

    public ForestRequest<T> address(ForestAddress address) {
        this.url.setAddress(address);
        return this;
    }

    public ForestRequest<T> address(ForestAddress address, boolean forced) {
        this.url.setAddress(address, forced);
        return this;
    }

    public ForestRequest<T> address(String host, int port) {
        return this.setAddress(host, port);
    }

    public ForestRequest<T> setBasePath(String path) {
        this.url.setBasePath(path);
        return this;
    }

    public ForestRequest<T> basePath(String path) {
        return this.setBasePath(path);
    }

    public String getBasePath() {
        return this.url.normalizeBasePath();
    }

    public String basePath() {
        return this.getBasePath();
    }

    public ForestRequest<T> setPath(String path) {
        this.url.setPath(path);
        return this;
    }

    public ForestRequest<T> path(String path) {
        return this.setPath(path);
    }

    public String getPath() {
        return this.url.getPath();
    }

    public String path() {
        return this.getPath();
    }

    public String getRef() {
        return this.url.getRef();
    }

    public ForestRequest<T> setRef(String ref) {
        this.url.setRef(ref);
        return this;
    }

    public ForestRequest<T> ref(String ref) {
        this.url.setRef(ref);
        return this;
    }

    public String ref() {
        return this.getRef();
    }

    public ForestMethod getMethod() {
        return this.method;
    }

    public HttpBackend getBackend() {
        return this.backend;
    }

    public HttpBackend backend() {
        return this.getBackend();
    }

    public ForestRequest<T> setBackend(HttpBackend backend) {
        this.backend = backend;
        return this;
    }

    public ForestRequest<T> backend(HttpBackend backend) {
        this.backend = backend;
        return this;
    }

    public ForestRequest<T> setBackend(String backendName) {
        HttpBackend backend = this.configuration.getBackendSelector().select(backendName);
        if (backend != null) {
            backend.init(this.configuration);
            this.backend = backend;
        }
        return this;
    }

    public ForestRequest<T> backend(String backendName) {
        return this.setBackend(backendName);
    }

    public Object getBackendClient() {
        return this.backendClient;
    }

    public ForestRequest<T> setBackendClient(Object backendClient) {
        this.backendClient = backendClient;
        return this;
    }

    public Object backendClient() {
        return this.getBackendClient();
    }

    public ForestRequest<T> backendClient(Object backendClient) {
        return this.setBackendClient(backendClient);
    }

    public boolean cacheBackendClient() {
        return this.cacheBackendClient;
    }

    public ForestRequest<T> setCacheBackendClient(boolean cacheBackendClient) {
        this.cacheBackendClient = cacheBackendClient;
        return this;
    }

    public ForestRequest<T> cacheBackendClient(boolean cacheBackendClient) {
        return this.setCacheBackendClient(cacheBackendClient);
    }

    public LifeCycleHandler getLifeCycleHandler() {
        return this.lifeCycleHandler;
    }

    public ForestRequest setLifeCycleHandler(LifeCycleHandler lifeCycleHandler) {
        this.lifeCycleHandler = lifeCycleHandler;
        return this;
    }

    public String getBoundary() {
        String contentType = this.getContentType();
        if (StringUtils.isEmpty(contentType)) {
            return null;
        }
        String[] group = contentType.split(";");
        if (group.length > 1) {
            for (int i = 1; i < group.length; ++i) {
                String subContentType = group[i];
                String[] nvPair = subContentType.split("=");
                if (nvPair.length <= 1) continue;
                String name = nvPair[0].trim();
                String value = nvPair[1].trim();
                if (!"boundary".equalsIgnoreCase(name)) continue;
                if (StringUtils.isBlank(value)) {
                    this.setBoundary(StringUtils.generateBoundary());
                    return this.getBoundary();
                }
                return value;
            }
        }
        return null;
    }

    public ForestRequest<T> setBoundary(String boundary) {
        String contentType = this.getContentType();
        if (StringUtils.isBlank(contentType)) {
            throw new ForestRuntimeException("boundary cannot be add to request, due to the header 'Content-Type' is empty");
        }
        String[] group = contentType.split(";");
        int idx = -1;
        String boundaryName = "boundary";
        if (group.length > 1) {
            for (int i = 1; i < group.length; ++i) {
                String name;
                String subContentType = group[i];
                String[] nvPair = subContentType.split("=");
                if (nvPair.length <= 1 || !"boundary".equalsIgnoreCase(name = nvPair[0].trim())) continue;
                idx = i;
                boundaryName = name;
                break;
            }
            if (idx > 0) {
                StringBuilder builder = new StringBuilder(group[0]);
                for (int i = 1; i < group.length; ++i) {
                    builder.append("; ");
                    if (i == idx) {
                        builder.append(boundaryName).append("=").append(boundary);
                        continue;
                    }
                    builder.append(group[i]);
                }
                this.setContentType(builder.toString());
            }
        } else {
            this.setContentType(contentType + "; boundary=" + boundary);
        }
        return this;
    }

    public ForestQueryMap getQuery() {
        return this.query;
    }

    public Object getQuery(String name) {
        return this.query.get(name);
    }

    public String getQueryString() {
        StringBuilder builder = new StringBuilder();
        Iterator<SimpleQueryParameter> iterator = this.query.queryValues().iterator();
        while (iterator.hasNext()) {
            SimpleQueryParameter query = iterator.next();
            if (query != null) {
                String name = query.getName();
                Object value = query.getValue();
                if (name != null) {
                    builder.append(name);
                    if (value != null) {
                        builder.append("=");
                    }
                }
                if (value != null) {
                    try {
                        String encodedValue = URLUtils.encode(value.toString(), this.getCharset());
                        builder.append(encodedValue);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
            if (!iterator.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    public ForestRequest<T> addQuery(String name, Object value) {
        this.query.addQuery(name, value);
        return this;
    }

    public ForestRequest<T> addQuery(String name, Object value, boolean isUrlEncode, String charset) {
        this.query.addQuery(name, value, isUrlEncode, charset);
        return this;
    }

    public ForestRequest<T> addQuery(String name, Collection collection) {
        this.query.addQuery(name, collection);
        return this;
    }

    public ForestRequest<T> addQuery(String name, Collection collection, boolean isUrlEncode, String charset) {
        this.query.addQuery(name, collection, isUrlEncode, charset);
        return this;
    }

    public ForestRequest<T> addQuery(String name, Object ... array) {
        return this.addQuery(name, array, false, (String)null);
    }

    public ForestRequest<T> addQuery(String name, Object[] array, boolean isUrlEncode, String charset) {
        this.query.addQuery(name, array, isUrlEncode, charset);
        return this;
    }

    public ForestRequest<T> addQuery(Map queryMap) {
        this.query.addQuery(queryMap);
        return this;
    }

    public ForestRequest<T> addQuery(Map queryMap, boolean isUrlEncode, String charset) {
        this.query.addQuery(queryMap, isUrlEncode, charset);
        return this;
    }

    public ForestRequest<T> addArrayQuery(String name, Collection collection) {
        return this.addArrayQuery(name, collection, false, null);
    }

    public ForestRequest<T> addArrayQuery(String name, Collection collection, boolean isUrlEncode, String charset) {
        this.query.addArrayQuery(name, collection, isUrlEncode, charset);
        return this;
    }

    public ForestRequest<T> addArrayQuery(String name, Object ... array) {
        return this.addArrayQuery(name, array, false, null);
    }

    public ForestRequest<T> addArrayQuery(String name, Object[] array, boolean isUrlEncode, String charset) {
        this.query.addArrayQuery(name, array, isUrlEncode, charset);
        return this;
    }

    public ForestRequest<T> addJSONQuery(String name, Object value) {
        ForestJsonConverter jsonConverter = this.configuration.getJsonConverter();
        String json = jsonConverter.encodeToString(value);
        this.query.addQuery(name, json);
        return this;
    }

    public ForestRequest<T> addQuery(SimpleQueryParameter queryParameter) {
        this.query.addQuery(queryParameter);
        return this;
    }

    public ForestRequest<T> addQuery(Collection<SimpleQueryParameter> queryParameters) {
        for (SimpleQueryParameter queryParameter : queryParameters) {
            this.addQuery(queryParameter);
        }
        return this;
    }

    public ForestRequest<T> addAllQuery(ForestQueryMap queries) {
        this.query.addAllQueries(queries);
        return this;
    }

    public ForestRequest<T> addQueryValues(String name, Collection queryValues) {
        for (Object queryValue : queryValues) {
            this.addQuery(name, queryValue);
        }
        return this;
    }

    public ForestRequest<T> addQuery(SimpleQueryParameter[] queryParameters) {
        for (SimpleQueryParameter queryParameter : queryParameters) {
            this.addQuery(queryParameter);
        }
        return this;
    }

    public ForestRequest<T> addQuery(Object queryParameters) {
        ForestJsonConverter jsonConverter = this.getConfiguration().getJsonConverter();
        Map<String, Object> map = jsonConverter.convertObjectToMap(queryParameters);
        if (map != null && map.size() > 0) {
            map.forEach((key, value) -> {
                if (value != null) {
                    this.addQuery(String.valueOf(key), value);
                }
            });
        }
        return this;
    }

    public ForestRequest<T> replaceQuery(SimpleQueryParameter queryParameter) {
        List<SimpleQueryParameter> queryParameters = this.query.getQueries(queryParameter.getName());
        for (SimpleQueryParameter parameter : queryParameters) {
            parameter.setValue(queryParameter.getValue());
        }
        return this;
    }

    public ForestRequest<T> replaceQuery(String name, Object value) {
        List<SimpleQueryParameter> queryParameters = this.query.getQueries(name);
        for (SimpleQueryParameter parameter : queryParameters) {
            parameter.setValue(value);
        }
        return this;
    }

    public ForestRequest<T> replaceOrAddQuery(SimpleQueryParameter queryParameter) {
        List<SimpleQueryParameter> queryParameters = this.query.getQueries(queryParameter.getName());
        if (queryParameters.isEmpty()) {
            this.addQuery(queryParameter);
        } else {
            for (SimpleQueryParameter parameter : queryParameters) {
                parameter.setValue(queryParameter.getValue());
            }
        }
        return this;
    }

    public ForestRequest<T> replaceOrAddQuery(String name, String value) {
        List<SimpleQueryParameter> queryParameters = this.query.getQueries(name);
        if (queryParameters.isEmpty()) {
            this.addQuery(name, (Object)value);
        } else {
            for (SimpleQueryParameter parameter : queryParameters) {
                parameter.setValue(value);
            }
        }
        return this;
    }

    public ForestRequest<T> removeQuery(String name) {
        this.query.removeQueries(name);
        return this;
    }

    public ForestRequest<T> clearQueries() {
        this.query.clear();
        return this;
    }

    public ForestDataType getBodyType() {
        return this.body.getBodyType();
    }

    public ForestRequest<T> setBodyType(ForestDataType bodyType) {
        this.body.setBodyType(bodyType);
        return this;
    }

    public ForestDataType bodyType() {
        return this.getBodyType();
    }

    public ForestRequest<T> bodyType(ForestDataType bodyType) {
        return this.setBodyType(bodyType);
    }

    public ForestRequestType getType() {
        return this.type;
    }

    public ForestRequest<T> setType(ForestRequestType type) {
        if (this.type != null) {
            if (this.typeChangeHistory == null) {
                this.typeChangeHistory = new LinkedList<ForestRequestType>();
            }
            this.typeChangeHistory.add(this.type);
        }
        this.type = type;
        return this;
    }

    public ForestRequest<T> type(ForestRequestType type) {
        return this.setType(null).clearTypeChangeHistory().setType(type);
    }

    public ForestRequestType type() {
        return this.getType();
    }

    public List<ForestRequestType> getTypeChangeHistory() {
        return this.typeChangeHistory;
    }

    public ForestRequest<T> clearTypeChangeHistory() {
        this.typeChangeHistory = null;
        return this;
    }

    public List<String> getTypeChangeHistoryString() {
        if (this.typeChangeHistory == null) {
            return null;
        }
        LinkedList<String> results = new LinkedList<String>();
        for (ForestRequestType type : this.typeChangeHistory) {
            results.add(type.getName());
        }
        return results;
    }

    public RequestLogMessage getRequestLogMessage() {
        return this.requestLogMessage;
    }

    public void setRequestLogMessage(RequestLogMessage requestLogMessage) {
        this.requestLogMessage = requestLogMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilename() {
        if (this.filename == null) {
            ForestRequest forestRequest = this;
            synchronized (forestRequest) {
                if (this.filename == null) {
                    String[] strs = this.getUrl().split("/");
                    this.filename = strs[strs.length - 1];
                }
            }
        }
        return this.filename;
    }

    public String getContentEncoding() {
        return this.headers.getValue("Content-Encoding");
    }

    public ForestRequest<T> setContentEncoding(String contentEncoding) {
        this.addHeader("Content-Encoding", contentEncoding);
        return this;
    }

    public String getUserAgent() {
        return this.headers.getValue("User-Agent");
    }

    public ForestRequest<T> setUserAgent(String userAgent) {
        this.addHeader("User-Agent", userAgent);
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public ForestRequest<T> setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public String charset() {
        return this.getCharset();
    }

    public ForestRequest<T> charset(String charset) {
        return this.setCharset(charset);
    }

    public String getResponseEncode() {
        return this.responseEncode;
    }

    public ForestRequest<T> setResponseEncode(String responseEncode) {
        this.responseEncode = responseEncode;
        return this;
    }

    public boolean isAsync() {
        return this.async;
    }

    public ForestRequest<T> setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public ForestAsyncMode getAsyncMode() {
        return this.asyncMode;
    }

    public ForestRequest<T> setAsyncMode(ForestAsyncMode asyncMode) {
        this.asyncMode = asyncMode;
        return this;
    }

    public ForestAsyncMode asyncMode() {
        return this.getAsyncMode();
    }

    public ForestRequest<T> asyncMode(ForestAsyncMode asyncMode) {
        return this.setAsyncMode(asyncMode);
    }

    public ForestAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public ForestRequest<T> setAuthenticator(ForestAuthenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public ForestAuthenticator authenticator() {
        return this.authenticator;
    }

    public ForestRequest<T> authenticator(ForestAuthenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public boolean isAutoRedirection() {
        return this.autoRedirection;
    }

    public ForestRequest<?> getPrevRequest() {
        return this.prevRequest;
    }

    public ForestResponse<?> getPrevResponse() {
        return this.prevResponse;
    }

    public boolean isRedirection() {
        return this.prevRequest != null && this.prevResponse != null;
    }

    public ForestRequest<T> setAutoRedirection(boolean autoRedirection) {
        this.autoRedirection = autoRedirection;
        return this;
    }

    public ForestRequest<T> autoRedirects(boolean autoRedirects) {
        return this.setAutoRedirection(autoRedirects);
    }

    public ForestRequest<T> sync() {
        return this.setAsync(false);
    }

    public ForestRequest<T> async() {
        return this.setAsync(true);
    }

    public ForestBody getBody() {
        return this.body;
    }

    public ForestBody body() {
        return this.getBody();
    }

    @Deprecated
    public List getBodyList() {
        return this.body;
    }

    @Deprecated
    public void setBodyList(ForestBody body) {
    }

    public ForestDataType getDataType() {
        return this.dataType;
    }

    public ForestRequest<T> setDataType(ForestDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public String getContentType() {
        return this.headers.getValue("Content-Type");
    }

    public ForestRequest<T> setContentType(String contentType) {
        this.addHeader("Content-Type", contentType);
        return this;
    }

    public ForestRequest<T> contentType(String contentType) {
        return this.setContentType(contentType);
    }

    public ForestRequest<T> contentFormUrlEncoded() {
        return this.setContentType("application/x-www-form-urlencoded");
    }

    public ForestRequest<T> contentTypeJson() {
        return this.setContentType("application/json");
    }

    public ForestRequest<T> contentTypeXml() {
        return this.setContentType("application/xml");
    }

    public ForestRequest<T> contentTypeOctetStream() {
        return this.setContentType("application/octet-stream");
    }

    public ForestRequest<T> contentTypeMultipartFormData() {
        return this.setContentType("multipart/form-data");
    }

    @Deprecated
    public int getTimeout() {
        return this.timeout;
    }

    @Deprecated
    public ForestRequest<T> setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public ForestRequest<T> setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Integer connectTimeout() {
        return this.getConnectTimeout();
    }

    public ForestRequest<T> connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public ForestRequest<T> connectTimeout(int connectTimeout, TimeUnit timeUnit) {
        this.connectTimeout = TimeUtils.toMillis("connect timeout", connectTimeout, timeUnit);
        return this;
    }

    public ForestRequest<T> connectTimeout(Duration connectTimeout) {
        this.connectTimeout = TimeUtils.toMillis("connect timeout", connectTimeout);
        return this;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public ForestRequest<T> setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Integer readTimeout() {
        return this.getReadTimeout();
    }

    public ForestRequest<T> readTimeout(int readTimeout) {
        return this.setReadTimeout(readTimeout);
    }

    public ForestRequest<T> readTimeout(int readTimeout, TimeUnit timeUnit) {
        this.readTimeout = TimeUtils.toMillis("read timeout", readTimeout, timeUnit);
        return this;
    }

    public ForestRequest<T> readTimeout(Duration readTimeout) {
        this.readTimeout = TimeUtils.toMillis("read timeout", readTimeout);
        return this;
    }

    public boolean isDecompressResponseGzipEnabled() {
        return this.decompressResponseGzipEnabled;
    }

    public ForestRequest<T> setDecompressResponseGzipEnabled(boolean decompressResponseGzipEnabled) {
        this.decompressResponseGzipEnabled = decompressResponseGzipEnabled;
        return this;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public ForestRequest<T> setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
        return this;
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.hostnameVerifier != null) {
            return this.hostnameVerifier;
        }
        if (this.keyStore == null) {
            return TrustAllHostnameVerifier.DEFAULT;
        }
        HostnameVerifier hostnameVerifier = this.keyStore.getHostnameVerifier();
        if (hostnameVerifier == null) {
            hostnameVerifier = TrustAllHostnameVerifier.DEFAULT;
        }
        return hostnameVerifier;
    }

    public ForestRequest<T> setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public HostnameVerifier hostnameVerifier() {
        return this.getHostnameVerifier();
    }

    public ForestRequest<T> hostnameVerifier(HostnameVerifier hostnameVerifier) {
        return this.setHostnameVerifier(hostnameVerifier);
    }

    public SSLSocketFactoryBuilder getSslSocketFactoryBuilder() {
        return this.sslSocketFactoryBuilder;
    }

    public ForestRequest<T> setSslSocketFactoryBuilder(SSLSocketFactoryBuilder sslSocketFactoryBuilder) {
        this.sslSocketFactoryBuilder = sslSocketFactoryBuilder;
        return this;
    }

    public SSLSocketFactoryBuilder sslSocketFactoryBuilder() {
        return this.getSslSocketFactoryBuilder();
    }

    public ForestRequest<T> sslSocketFactoryBuilder(SSLSocketFactoryBuilder sslSocketFactoryBuilder) {
        return this.setSslSocketFactoryBuilder(sslSocketFactoryBuilder);
    }

    public String clientKey() {
        int timeout = this.getTimeout();
        Integer connectTimeout = this.connectTimeout();
        Integer readTimeout = this.readTimeout();
        if (TimeUtils.isNone(connectTimeout)) {
            connectTimeout = timeout;
        }
        if (TimeUtils.isNone(readTimeout)) {
            readTimeout = timeout;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("-t=").append(connectTimeout).append("-").append(readTimeout);
        if (this.isSSL()) {
            if (this.sslSocketFactoryBuilder != null) {
                builder.append(",-sf=").append(Objects.hash(this.sslSocketFactoryBuilder));
            }
            if (this.keyStore != null) {
                builder.append(",-ks=").append(this.keyStore.getId());
            } else if (this.sslProtocol != null) {
                builder.append(",-sp=").append(this.sslProtocol);
            }
        }
        if (this.proxy != null) {
            builder.append(",-x=").append(this.proxy.getHost()).append(":").append(this.proxy.getPort());
        }
        return builder.toString();
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (this.sslSocketFactoryBuilder != null) {
            try {
                return this.sslSocketFactoryBuilder.getSSLSocketFactory(this, this.getSslProtocol());
            }
            catch (Exception e) {
                throw new ForestRuntimeException(e);
            }
        }
        SSLKeyStore keyStore = this.getKeyStore();
        if (keyStore == null) {
            return SSLUtils.getDefaultSSLSocketFactory(this, this.getSslProtocol());
        }
        SSLSocketFactoryBuilder sslSocketFactoryBuilder = keyStore.getSslSocketFactoryBuilder();
        if (sslSocketFactoryBuilder == null) {
            return SSLUtils.getDefaultSSLSocketFactory(this, this.getSslProtocol());
        }
        try {
            SSLSocketFactory sslSocketFactory = sslSocketFactoryBuilder.getSSLSocketFactory(this, this.getSslProtocol());
            if (sslSocketFactory == null) {
                return SSLUtils.getDefaultSSLSocketFactory(this, this.getSslProtocol());
            }
            return sslSocketFactory;
        }
        catch (Exception e) {
            throw new ForestRuntimeException(e);
        }
    }

    public boolean isSSL() {
        return this.url.isSSL();
    }

    @Deprecated
    public int getRetryCount() {
        return this.maxRetryCount;
    }

    @Deprecated
    public ForestRequest<T> setRetryCount(int retryCount) {
        this.maxRetryCount = retryCount;
        return this;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public ForestRequest<T> setMaxRetryCount(int retryCount) {
        this.maxRetryCount = retryCount;
        return this;
    }

    public int maxRetryCount() {
        return this.getMaxRetryCount();
    }

    public ForestRequest<T> maxRetryCount(int retryCount) {
        return this.setMaxRetryCount(retryCount);
    }

    public int getCurrentRetryCount() {
        return this.retryer.getCurrentRetryCount();
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public ForestRequest<T> setRetryEnabled(boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
        return this;
    }

    public ForestRequest<T> setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
        return this;
    }

    public ForestRequest<T> maxRetryInterval(long maxRetryInterval) {
        return this.setMaxRetryInterval(maxRetryInterval);
    }

    @Deprecated
    public Map<String, Object> getData() {
        return null;
    }

    public ForestRequest<T> addBody(ForestRequestBody body) {
        this.body.add(body);
        return this;
    }

    public ForestRequest<T> addBody(String stringBody) {
        return this.addBody(new StringRequestBody(stringBody));
    }

    public ForestRequest<T> addBody(byte[] byteArrayBody) {
        return this.addBody(new ByteArrayRequestBody(byteArrayBody));
    }

    public ForestRequest<T> addBody(File fileBody) {
        return this.addBody(new FileRequestBody(fileBody));
    }

    public ForestRequest<T> addBody(InputStream inputStreamBody) {
        return this.addBody(new InputStreamRequestBody(inputStreamBody));
    }

    public ForestRequest<T> addBody(Object obj) {
        return this.addBody(new ObjectRequestBody(obj));
    }

    public ForestRequest<T> addBody(String name, Object value) {
        return this.addBody(new NameValueRequestBody(name, value));
    }

    public ForestRequest<T> addBody(Map bodyMap, String contentType) {
        if (bodyMap == null) {
            return this;
        }
        if (bodyMap.isEmpty()) {
            this.addBody(new ObjectRequestBody(bodyMap));
            return this;
        }
        for (Object key : bodyMap.keySet()) {
            Object value = bodyMap.get(key);
            this.addBody(String.valueOf(key), contentType, value);
        }
        return this;
    }

    public ForestRequest<T> addBody(String name, String contentType, Object value) {
        return this.addBody(new NameValueRequestBody(name, contentType, value));
    }

    @Deprecated
    public ForestRequest<T> addBody(RequestNameValue nameValue) {
        return this.addBody(new NameValueRequestBody(nameValue.getName(), nameValue.getValue()));
    }

    @Deprecated
    public ForestRequest<T> addBody(List<RequestNameValue> nameValueList) {
        for (RequestNameValue nameValue : nameValueList) {
            this.addBody(nameValue);
        }
        return this;
    }

    @Deprecated
    public ForestRequest<T> addData(String name, Object value) {
        return this.addBody(name, value);
    }

    @Deprecated
    public ForestRequest<T> addData(RequestNameValue nameValue) {
        return this.addNameValue(nameValue);
    }

    @Deprecated
    public ForestRequest<T> addData(List<RequestNameValue> data) {
        return this.addNameValue(data);
    }

    public ForestRequest<T> addNameValue(RequestNameValue nameValue) {
        if (nameValue.isInHeader()) {
            this.addHeader(nameValue.getName(), nameValue.getValue());
        } else if (nameValue.isInQuery()) {
            this.addQuery(nameValue.getName(), nameValue.getValue());
        } else if (nameValue.isInBody()) {
            this.addBody(nameValue.getName(), nameValue.getPartContentType(), nameValue.getValue());
        }
        return this;
    }

    public ForestRequest<T> addNameValue(List<RequestNameValue> nameValueList) {
        for (RequestNameValue nameValue : nameValueList) {
            this.addNameValue(nameValue);
        }
        return this;
    }

    public ForestRequest<T> replaceBody(ForestRequestBody body) {
        this.body.clear();
        this.addBody(body);
        return this;
    }

    public ForestRequest<T> replaceBody(String stringbody) {
        this.body.clear();
        this.addBody(stringbody);
        return this;
    }

    @Deprecated
    public List<RequestNameValue> getQueryNameValueList() {
        ArrayList<RequestNameValue> nameValueList = new ArrayList<RequestNameValue>();
        for (Map.Entry<String, Object> entry : this.query.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            RequestNameValue nameValue = new RequestNameValue(name, value, 1);
            nameValueList.add(nameValue);
        }
        return nameValueList;
    }

    public List<SimpleQueryParameter> getQueryValues() {
        return this.query.queryValues();
    }

    public List<RequestNameValue> getDataNameValueList() {
        ArrayList<RequestNameValue> nameValueList = new ArrayList<RequestNameValue>();
        for (ForestRequestBody item : this.body) {
            if (!(item instanceof NameValueRequestBody)) continue;
            NameValueRequestBody nameValueRequestBody = (NameValueRequestBody)item;
            String name = nameValueRequestBody.getName();
            Object value = nameValueRequestBody.getValue();
            RequestNameValue nameValue = new RequestNameValue(name, value, 2, nameValueRequestBody.getContentType());
            nameValueList.add(nameValue);
        }
        return nameValueList;
    }

    public List<RequestNameValue> getHeaderNameValueList() {
        ArrayList<RequestNameValue> nameValueList = new ArrayList<RequestNameValue>();
        Iterator<ForestHeader> iterator = this.headers.headerIterator();
        while (iterator.hasNext()) {
            ForestHeader header = iterator.next();
            RequestNameValue nameValue = new RequestNameValue(header.getName(), header.getValue(), 3);
            nameValueList.add(nameValue);
        }
        return nameValueList;
    }

    public Object getArgument(int index) {
        return this.arguments[index];
    }

    public Object argument(int index) {
        return this.arguments[index];
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Object[] arguments() {
        return this.getArguments();
    }

    public ForestHeaderMap getHeaders() {
        return this.headers;
    }

    public ForestHeaderMap headers() {
        return this.getHeaders();
    }

    public ForestHeader getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public ForestHeader header(String name) {
        return this.getHeader(name);
    }

    public String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    public String headerValue(String name) {
        return this.getHeaderValue(name);
    }

    public ForestRequest<T> addHeader(Map headerMap) {
        this.headers.setHeader(headerMap);
        return this;
    }

    public ForestRequest<T> addHeader(String name, Object value) {
        if (StringUtils.isEmpty(name)) {
            return this;
        }
        this.headers.setHeader(name, String.valueOf(value));
        return this;
    }

    public ForestRequest<T> addHeader(RequestNameValue nameValue) {
        this.addHeader(nameValue.getName(), nameValue.getValue());
        return this;
    }

    public ForestRequest<T> addHeaders(List<RequestNameValue> nameValues) {
        for (RequestNameValue nameValue : nameValues) {
            this.addHeader(nameValue.getName(), nameValue.getValue());
        }
        return this;
    }

    public ForestRequest<T> addCookie(ForestCookie cookie) {
        this.headers.addCookie(cookie);
        return this;
    }

    public ForestRequest<T> addCookie(ForestCookie cookie, boolean strict) {
        this.headers.addCookie(cookie, strict);
        return this;
    }

    public ForestRequest<T> addCookies(List<ForestCookie> cookies) {
        this.headers.addCookies(cookies);
        return this;
    }

    public ForestRequest<T> addCookies(List<ForestCookie> cookies, boolean strict) {
        this.headers.addCookies(cookies, strict);
        return this;
    }

    public ForestRequest<T> addCookies(ForestCookies cookies) {
        this.headers.addCookies(cookies);
        return this;
    }

    public List<ForestMultipart> getMultiparts() {
        return this.multiparts;
    }

    public ForestRequest<T> setMultiparts(List<ForestMultipart> multiparts) {
        this.multiparts = multiparts;
        return this;
    }

    public ForestRequest<T> addMultipart(ForestMultipart multipart) {
        if (this.multiparts == null) {
            this.multiparts = new LinkedList<ForestMultipart>();
        }
        this.multiparts.add(multipart);
        return this;
    }

    public ForestRequest<T> addFile(ForestMultipart multipart) {
        return this.addMultipart(multipart);
    }

    public ForestRequest<T> addFile(String name, File file, String filename, String contentType) {
        return this.addMultipart((ForestMultipart)((FileMultipart)((FileMultipart)new FileMultipart().setName(name)).setContentType(contentType)).setData(file).setFileName(file.getName()));
    }

    public ForestRequest<T> addFile(String name, File file, String filename) {
        return this.addFile(name, file, filename, null);
    }

    public ForestRequest<T> addFile(String name, File file) {
        return this.addFile(name, file, file.getName(), null);
    }

    public ForestRequest<T> addFile(String name, InputStream inputStream, String filename, String contentType) {
        return this.addMultipart((ForestMultipart)((InputStreamMultipart)((InputStreamMultipart)new InputStreamMultipart().setName(name)).setData(inputStream).setFileName(filename)).setContentType(contentType));
    }

    public ForestRequest<T> addFile(String name, InputStream inputStream, String filename) {
        return this.addFile(name, inputStream, filename, null);
    }

    public ForestRequest<T> addFile(String name, byte[] bytes, String filename, String contentType) {
        return this.addFile((ForestMultipart)((ByteArrayMultipart)((ByteArrayMultipart)new ByteArrayMultipart().setName(name)).setData(bytes).setFileName(filename)).setContentType(contentType));
    }

    public ForestRequest<T> addFile(String name, byte[] bytes, String filename) {
        return this.addFile(name, bytes, filename, null);
    }

    public OnSuccess getOnSuccess() {
        return this.onSuccess;
    }

    public ForestRequest<T> setOnSuccess(OnSuccess onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    public ForestRequest<T> onSuccess(OnSuccess onSuccess) {
        return this.setOnSuccess(onSuccess);
    }

    public OnError getOnError() {
        return this.onError;
    }

    public ForestRequest<T> setOnError(OnError onError) {
        this.onError = onError;
        return this;
    }

    public ForestRequest<T> onError(OnError onError) {
        return this.setOnError(onError);
    }

    public OnCanceled getOnCanceled() {
        return this.onCanceled;
    }

    public ForestRequest<T> setOnCanceled(OnCanceled onCanceled) {
        this.onCanceled = onCanceled;
        return this;
    }

    public ForestRequest<T> onCanceled(OnCanceled onCanceled) {
        return this.setOnCanceled(onCanceled);
    }

    public SuccessWhen getSuccessWhen() {
        return this.successWhen;
    }

    public ForestRequest<T> setSuccessWhen(SuccessWhen successWhen) {
        this.successWhen = successWhen;
        return this;
    }

    public ForestRequest<T> setSuccessWhen(Class<? extends SuccessWhen> conditionClass) {
        if (conditionClass != null && !conditionClass.isInterface()) {
            SuccessWhen condition = this.configuration.getForestObject(conditionClass);
            this.setSuccessWhen(condition);
        }
        return this;
    }

    public ForestRequest<T> successWhen(SuccessWhen successWhen) {
        return this.setSuccessWhen(successWhen);
    }

    public ForestRequest<T> successWhen(Class<? extends SuccessWhen> conditionClass) {
        return this.setSuccessWhen(conditionClass);
    }

    public OnRetry getOnRetry() {
        return this.onRetry;
    }

    public ForestRequest<T> setOnRetry(OnRetry onRetry) {
        this.onRetry = onRetry;
        return this;
    }

    public ForestRequest<T> onRetry(OnRetry onRetry) {
        return this.setOnRetry(onRetry);
    }

    public RetryWhen getRetryWhen() {
        return this.retryWhen;
    }

    public ForestRequest<T> setRetryWhen(RetryWhen retryWhen) {
        this.retryWhen = retryWhen;
        return this;
    }

    public ForestRequest<T> retryWhen(RetryWhen retryWhen) {
        return this.setRetryWhen(retryWhen);
    }

    public ForestRequest<T> setRetryWhen(Class<? extends RetryWhen> conditionClass) {
        if (conditionClass != null && !conditionClass.isInterface()) {
            RetryWhen condition = this.configuration.getForestObject(conditionClass);
            this.setRetryWhen(condition);
        }
        return this;
    }

    public ForestRequest<T> retryWhen(Class<? extends RetryWhen> conditionClass) {
        return this.setRetryWhen(conditionClass);
    }

    public boolean isDownloadFile() {
        return this.isDownloadFile;
    }

    public ForestRequest<T> setDownloadFile(boolean downloadFile) {
        this.isDownloadFile = downloadFile;
        return this;
    }

    public ForestRequest<T> setDownloadFile(String dir, String filename) {
        if (StringUtils.isNotBlank(dir)) {
            this.addInterceptor(DownloadLifeCycle.class);
            HashMap<String, Object> downloadFileMap = new HashMap<String, Object>(4);
            downloadFileMap.put("dir", dir);
            downloadFileMap.put("filename", filename != null ? filename : "");
            InterceptorAttributes attributes = new InterceptorAttributes(DownloadLifeCycle.class, downloadFileMap);
            attributes.render(new Object[0]);
            this.addInterceptorAttributes(DownloadLifeCycle.class, attributes);
        }
        return this;
    }

    public long getProgressStep() {
        return this.progressStep;
    }

    public ForestRequest<T> setProgressStep(long progressStep) {
        this.progressStep = progressStep;
        return this;
    }

    public OnRedirection getOnRedirection() {
        return this.onRedirection;
    }

    public ForestRequest<T> setOnRedirection(OnRedirection onRedirection) {
        this.onRedirection = onRedirection;
        return this;
    }

    public ForestRequest<T> onRedirection(OnRedirection onRedirection) {
        this.onRedirection = onRedirection;
        return this;
    }

    public OnProgress getOnProgress() {
        return this.onProgress;
    }

    public ForestRequest<T> setOnProgress(OnProgress onProgress) {
        this.onProgress = onProgress;
        return this;
    }

    public ForestRequest<T> onProgress(OnProgress onProgress) {
        return this.setOnProgress(onProgress);
    }

    public OnLoadCookie getOnLoadCookie() {
        return this.onLoadCookie;
    }

    public ForestRequest<T> setOnLoadCookie(OnLoadCookie onLoadCookie) {
        this.onLoadCookie = onLoadCookie;
        return this;
    }

    public ForestRequest<T> onLoadCookie(OnLoadCookie onLoadCookie) {
        return this.setOnLoadCookie(onLoadCookie);
    }

    public OnSaveCookie getOnSaveCookie() {
        return this.onSaveCookie;
    }

    public ForestRequest<T> setOnSaveCookie(OnSaveCookie onSaveCookie) {
        this.onSaveCookie = onSaveCookie;
        return this;
    }

    public ForestRequest<T> onSaveCookie(OnSaveCookie onSaveCookie) {
        return this.setOnSaveCookie(onSaveCookie);
    }

    public Object getVariableValue(String name) {
        MappingVariable variable = this.method.getVariable(name);
        if (variable != null) {
            return this.getArgument(variable.getIndex());
        }
        if (!this.method.isVariableDefined(name)) {
            throw new ForestVariableUndefinedException(name);
        }
        return this.method.getVariableValue(name, this.method);
    }

    public Object variableValue(String name) {
        return this.getVariableValue(name);
    }

    public ForestRequest<T> addInterceptor(Class<? extends Interceptor> interceptorClass) {
        if (!Interceptor.class.isAssignableFrom(interceptorClass) || interceptorClass.isInterface()) {
            throw new ForestRuntimeException("Class [" + interceptorClass.getName() + "] is not a implement of [" + Interceptor.class.getName() + "] interface.");
        }
        Interceptor interceptor = this.configuration.getInterceptorFactory().getInterceptor(interceptorClass);
        this.interceptorChain.addInterceptor(interceptor);
        return this;
    }

    public ForestRequest<T> addInterceptor(Interceptor interceptor) {
        this.interceptorChain.addInterceptor(interceptor);
        return this;
    }

    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    public ForestRequest<T> addInterceptorAttributes(Class interceptorClass, InterceptorAttributes attributes) {
        InterceptorAttributes oldAttributes = this.interceptorAttributes.get(interceptorClass);
        if (oldAttributes != null) {
            for (Map.Entry<String, Object> entry : attributes.getAttributeTemplates().entrySet()) {
                oldAttributes.addAttribute(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : attributes.getAttributes().entrySet()) {
                oldAttributes.addAttribute(entry.getKey(), entry.getValue());
            }
        } else {
            this.interceptorAttributes.put(interceptorClass, attributes);
        }
        return this;
    }

    public ForestRequest<T> addInterceptorAttribute(Class interceptorClass, String attributeName, Object attributeValue) {
        InterceptorAttributes attributes = this.getInterceptorAttributes(interceptorClass);
        if (attributes == null) {
            attributes = new InterceptorAttributes(interceptorClass, new ConcurrentHashMap<String, Object>());
            this.addInterceptorAttributes(interceptorClass, attributes);
        }
        attributes.addAttribute(attributeName, attributeValue);
        return this;
    }

    public Map<Class, InterceptorAttributes> getInterceptorAttributes() {
        return this.interceptorAttributes;
    }

    public InterceptorAttributes getInterceptorAttributes(Class interceptorClass) {
        return this.interceptorAttributes.get(interceptorClass);
    }

    public Object getInterceptorAttribute(Class interceptorClass, String attributeName) {
        InterceptorAttributes attributes = this.interceptorAttributes.get(interceptorClass);
        if (attributes == null) {
            return null;
        }
        return attributes.getAttribute(attributeName);
    }

    public ForestRetryer getRetryer() {
        return this.retryer;
    }

    public ForestRequest<T> setRetryer(ForestRetryer retryer) {
        this.retryer = retryer;
        return this;
    }

    public ForestRequest<T> retryer(ForestRetryer retryer) {
        return this.setRetryer(retryer);
    }

    public ForestRequest<T> setRetryer(Class<? extends ForestRetryer> retryerClass) {
        try {
            Constructor<? extends ForestRetryer> constructor = retryerClass.getConstructor(ForestRequest.class);
            ForestRetryer retryer = constructor.newInstance(this);
            this.setRetryer(retryer);
        }
        catch (NoSuchMethodException e) {
            throw new ForestRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new ForestRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new ForestRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ForestRuntimeException(e);
        }
        return this;
    }

    public ForestRequest<T> retryer(Class<? extends ForestRetryer> retryerClass) {
        return this.setRetryer(retryerClass);
    }

    public ForestRequest<T> addAttachment(String name, Object value) {
        this.attachments.put(name, value);
        return this;
    }

    public Object getAttachment(String name) {
        return this.attachments.get(name);
    }

    public ForestEncoder getEncoder() {
        return this.encoder;
    }

    public ForestRequest<T> setEncoder(ForestEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public ForestConverter getDecoder() {
        return this.decoder;
    }

    public ForestRequest<T> setDecoder(ForestConverter decoder) {
        this.decoder = decoder;
        return this;
    }

    public ForestRequest<T> decoder(ForestConverter decoder) {
        return this.setDecoder(decoder);
    }

    @Deprecated
    public boolean isLogEnable() {
        if (this.logConfiguration == null) {
            return true;
        }
        return this.logConfiguration.isLogEnabled();
    }

    public LogConfiguration getLogConfiguration() {
        return this.logConfiguration;
    }

    public ForestRequest<T> setLogConfiguration(LogConfiguration logConfiguration) {
        this.logConfiguration = logConfiguration;
        return this;
    }

    public SSLKeyStore getKeyStore() {
        return this.keyStore;
    }

    public ForestRequest<T> setKeyStore(SSLKeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public ForestRequest<T> keyStore(SSLKeyStore keyStore) {
        return this.setKeyStore(keyStore);
    }

    public ForestProxy getProxy() {
        return this.proxy;
    }

    public ForestRequest<T> setProxy(ForestProxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public ForestRequest<T> proxy(ForestProxy proxy) {
        return this.setProxy(proxy);
    }

    public ForestRequest<T> methodReturn(T result) {
        if (this.lifeCycleHandler != null) {
            this.lifeCycleHandler.handleResult(result);
        }
        return this;
    }

    public Object getMethodReturnValue() {
        if (this.lifeCycleHandler != null && this.lifeCycleHandler instanceof MethodLifeCycleHandler) {
            Object resultData = ((MethodLifeCycleHandler)this.lifeCycleHandler).getResultData();
            return resultData;
        }
        return null;
    }

    private ForestResponse<T> getResponse() {
        if (this.lifeCycleHandler != null && this.lifeCycleHandler instanceof MethodLifeCycleHandler) {
            return ((MethodLifeCycleHandler)this.lifeCycleHandler).getResponse();
        }
        return null;
    }

    private boolean doRetryWhen(ForestResponse<?> response) {
        if (this.retryWhen != null) {
            return this.retryWhen.retryWhen(this, response);
        }
        RetryWhen globalRetryWhen = this.configuration.getRetryWhen();
        if (globalRetryWhen != null) {
            return globalRetryWhen.retryWhen(this, response);
        }
        return response.isError();
    }

    public ForestRetryException canRetry(ForestResponse<?> response) {
        try {
            return this.canRetry(response, null);
        }
        catch (ForestRetryException rex) {
            return rex;
        }
        catch (Throwable ex) {
            if (ex instanceof ForestRuntimeException) {
                throw (ForestRuntimeException)ex;
            }
            throw new ForestRuntimeException(ex);
        }
    }

    public final ForestRetryException canRetry(ForestResponse<?> response, ForestRetryException ex) throws Throwable {
        if (ex == null) {
            ex = new ForestRetryException(this, this.maxRetryCount, this.getCurrentRetryCount());
        }
        if (response == null || !this.retryEnabled) {
            throw ex.getCause();
        }
        HttpExecutor retryExecutor = this.backend.createExecutor(this, this.lifeCycleHandler);
        if (retryExecutor != null) {
            if (!this.doRetryWhen(response)) {
                throw ex.getCause();
            }
            this.retryer.canRetry(ex);
            this.interceptorChain.onRetry(this, response);
            if (this.onRetry != null) {
                this.onRetry.onRetry(this, response);
            }
            return ex;
        }
        return null;
    }

    public ForestRequestPool pool() {
        return this.configuration.getPool();
    }

    public ForestRequest<T> clone() {
        ForestBody newBody = new ForestBody(this.configuration);
        newBody.setBodyType(this.body.getBodyType());
        for (ForestRequestBody body : this.body) {
            newBody.add(body);
        }
        ForestRequest<T> newRequest = new ForestRequest<T>(this.configuration, this.method, this.arguments, this.body);
        newRequest.backend = this.backend;
        newRequest.lifeCycleHandler = this.lifeCycleHandler;
        newRequest.protocol = this.protocol;
        newRequest.sslProtocol = this.sslProtocol;
        newRequest.url = this.url;
        newRequest.query = this.query.clone();
        newRequest.headers = this.headers.clone();
        ArrayList<ForestMultipart> newMultiparts = new ArrayList<ForestMultipart>(this.multiparts.size());
        for (ForestMultipart part : this.multiparts) {
            newMultiparts.add(part);
        }
        newRequest.multiparts = newMultiparts;
        newRequest.timeout = this.timeout;
        newRequest.filename = this.filename;
        newRequest.charset = this.charset;
        newRequest.decoder = this.decoder;
        newRequest.decompressResponseGzipEnabled = this.decompressResponseGzipEnabled;
        newRequest.responseEncode = this.responseEncode;
        newRequest.isDownloadFile = this.isDownloadFile;
        newRequest.proxy = this.proxy;
        newRequest.keyStore = this.keyStore;
        newRequest.async = this.async;
        newRequest.retryer = this.retryer;
        newRequest.maxRetryCount = this.maxRetryCount;
        newRequest.maxRetryInterval = this.maxRetryInterval;
        newRequest.onSuccess = this.onSuccess;
        newRequest.successWhen = this.successWhen;
        newRequest.onError = this.onError;
        newRequest.onRedirection = this.onRedirection;
        newRequest.onLoadCookie = this.onLoadCookie;
        newRequest.onSaveCookie = this.onSaveCookie;
        newRequest.onProgress = this.onProgress;
        newRequest.progressStep = this.progressStep;
        newRequest.onRetry = this.onRetry;
        newRequest.retryWhen = this.retryWhen;
        newRequest.retryEnabled = this.retryEnabled;
        newRequest.type = this.type;
        newRequest.dataType = this.dataType;
        newRequest.interceptorChain = this.interceptorChain;
        newRequest.interceptorAttributes = this.interceptorAttributes;
        newRequest.attachments = this.attachments;
        newRequest.logConfiguration = this.logConfiguration;
        newRequest.requestLogMessage = this.requestLogMessage;
        return newRequest;
    }

    public Object execute(HttpBackend backend, LifeCycleHandler lifeCycleHandler) {
        this.setLifeCycleHandler(lifeCycleHandler);
        this.processRedirectionRequest();
        if (this.interceptorChain.beforeExecute(this)) {
            if (this.authenticator != null) {
                this.authenticator.enhanceAuthorization(this);
            }
            this.url.mergeAddress().checkAndComplete();
            ForestCookies cookies = new ForestCookies();
            lifeCycleHandler.handleLoadCookie(this, cookies);
            this.addCookies(cookies);
            this.executor = backend.createExecutor(this, lifeCycleHandler);
            if (this.executor != null) {
                try {
                    this.executor.execute(lifeCycleHandler);
                }
                catch (ForestRuntimeException e) {
                    if (e instanceof ForestAsyncAbortException) {
                        ((ForestAsyncAbortException)e).setRequest(this);
                        ForestResponseFactory forestResponseFactory = this.executor.getResponseFactory();
                        ForestResponse<?> response = forestResponseFactory.createResponse(this, null, lifeCycleHandler, e, new Date());
                        this.executor.getResponseHandler().handleError(response, e);
                    }
                    throw e;
                }
            }
        }
        return this.getMethodReturnValue();
    }

    public void cancel() {
        if (this.executor != null) {
            this.executor.close();
            this.canceled = true;
        }
    }

    private void processRedirectionRequest() {
        if (this.isRedirection()) {
            if (this.onRedirection != null) {
                this.onRedirection.onRedirection(this, this.prevRequest, this.prevResponse);
            }
            this.interceptorChain.onRedirection(this, (ForestRequest)this.prevRequest, (ForestResponse)this.prevResponse);
        }
    }

    public Object execute() {
        return this.execute(this.getBackend(), this.getLifeCycleHandler());
    }

    public <R> R execute(Class<R> clazz) {
        LifeCycleHandler lifeCycleHandler = this.getLifeCycleHandler();
        MethodLifeCycleHandler methodLifeCycleHandler = new MethodLifeCycleHandler(clazz, lifeCycleHandler.getOnSuccessClassGenericType());
        Object ret = this.execute(this.getBackend(), methodLifeCycleHandler);
        return (R)ret;
    }

    public byte[] executeAsByteArray() {
        return this.execute(byte[].class);
    }

    public Boolean executeAsBoolean() {
        return this.execute(Boolean.class);
    }

    public Integer executeAsInteger() {
        return this.execute(Integer.class);
    }

    public Long executeAsLong() {
        return this.execute(Long.class);
    }

    public String executeAsString() {
        return this.execute(String.class);
    }

    public <KEY, VALUE> Map<KEY, VALUE> executeAsMap() {
        return (Map)this.execute(new TypeReference<Map<KEY, VALUE>>(){});
    }

    public <E> List<E> executeAsList() {
        return (List)this.execute(new TypeReference<List<E>>(){});
    }

    public ForestFuture<T> executeAsFuture() {
        return (ForestFuture)this.execute(new TypeReference<ForestFuture<T>>(){});
    }

    public ForestResponse executeAsResponse() {
        return this.execute(ForestResponse.class);
    }

    public <R> R execute(Type type) {
        LifeCycleHandler lifeCycleHandler = this.getLifeCycleHandler();
        MethodLifeCycleHandler methodLifeCycleHandler = new MethodLifeCycleHandler(type, lifeCycleHandler.getOnSuccessClassGenericType());
        Object ret = this.execute(this.getBackend(), methodLifeCycleHandler);
        return (R)ret;
    }

    public <R> R execute(TypeReference<R> typeReference) {
        return this.execute(typeReference.getType());
    }
}

