/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.utils.StringUtils;

public enum ForestRequestType {
    GET("GET", 1),
    POST("POST", 2),
    PUT("PUT", 2),
    PATCH("PATCH", 2),
    HEAD("HEAD", 1),
    OPTIONS("OPTIONS", 1),
    DELETE("DELETE", 1),
    TRACE("TRACE", 1);

    private final String name;
    private final int defaultParamTarget;

    private ForestRequestType(String name, int defaultParamTarget) {
        this.name = name;
        this.defaultParamTarget = defaultParamTarget;
    }

    public String getName() {
        return this.name;
    }

    public int getDefaultParamTarget() {
        return this.defaultParamTarget;
    }

    public boolean match(String name) {
        if (StringUtils.isEmpty(name)) {
            return false;
        }
        return this.name.equals(name.toUpperCase());
    }

    public boolean isNeedBody() {
        return !this.equals((Object)GET) && !this.equals((Object)HEAD) && !this.equals((Object)OPTIONS);
    }

    public static ForestRequestType findType(String name) {
        for (ForestRequestType type : ForestRequestType.values()) {
            if (!type.match(name)) continue;
            return type;
        }
        return null;
    }
}

