/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.backend.ContentType;
import com.dtflys.forest.callback.SuccessWhen;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestCookie;
import com.dtflys.forest.http.ForestHeader;
import com.dtflys.forest.http.ForestHeaderMap;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestURL;
import com.dtflys.forest.http.HasURL;
import com.dtflys.forest.http.ResultGetter;
import com.dtflys.forest.utils.ByteEncodeUtils;
import com.dtflys.forest.utils.GzipUtils;
import com.dtflys.forest.utils.ReflectUtils;
import com.dtflys.forest.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;

public abstract class ForestResponse<T>
extends ResultGetter
implements HasURL {
    protected static final int MAX_BYTES_CAPACITY = 0x200000;
    protected ForestRequest request;
    protected Date requestTime;
    protected Date responseTime;
    protected volatile boolean closed = false;
    protected boolean isGzip = false;
    protected volatile boolean logged = false;
    private volatile Boolean success = null;
    protected volatile Integer statusCode;
    protected volatile String reasonPhrase;
    protected volatile String content;
    protected volatile ContentType contentType;
    protected volatile String contentEncoding;
    protected volatile String charset;
    protected volatile long contentLength;
    protected volatile ForestHeaderMap headers = new ForestHeaderMap(this);
    protected volatile Throwable exception;
    protected volatile T result;

    public ForestResponse(ForestRequest request, Date requestTime, Date responseTime) {
        super(request);
        this.request = request;
        this.requestTime = requestTime;
        this.responseTime = responseTime;
    }

    @Override
    protected ForestResponse getResponse() {
        return this;
    }

    @Override
    public ForestURL url() {
        if (this.request == null) {
            return null;
        }
        return this.request.url();
    }

    public ForestRequest getRequest() {
        return this.request;
    }

    public Date getRequestTime() {
        return this.requestTime;
    }

    public Date getResponseTime() {
        return this.responseTime;
    }

    public long getTimeAsMillisecond() {
        return this.responseTime.getTime() - this.requestTime.getTime();
    }

    public boolean isCanceled() {
        return this.request.isCanceled();
    }

    public boolean isLogged() {
        return this.logged;
    }

    public void setLogged(boolean logged) {
        this.logged = logged;
    }

    public boolean isRedirection() {
        return this.getStatusCode() > 300 && this.getStatusCode() <= 307;
    }

    public String getRedirectionLocation() {
        return this.getHeaderValue("Location");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForestRequest<T> redirectionRequest() {
        if (this.isRedirection() && this.request != null) {
            try {
                String location = this.getRedirectionLocation();
                if (StringUtils.isBlank(location)) {
                    ForestRequest<T> forestRequest = null;
                    return forestRequest;
                }
                Object redirectRequest = this.request.clone();
                ((ForestRequest)redirectRequest).clearQueries();
                ((ForestRequest)redirectRequest).setUrl(location);
                ((ForestRequest)redirectRequest).prevRequest = this.request;
                ((ForestRequest)redirectRequest).prevResponse = this;
                Object object = redirectRequest;
                return object;
            }
            finally {
                this.close();
            }
        }
        return null;
    }

    public String getFilename() {
        String dispositionValue;
        ForestHeader header = this.getHeader("Content-Disposition");
        if (header != null && StringUtils.isNotEmpty(dispositionValue = header.getValue())) {
            String[] disGroup = dispositionValue.split(";");
            for (int i = disGroup.length - 1; i >= 0; --i) {
                String disStr = StringUtils.trimBegin(disGroup[i]);
                if (!disStr.startsWith("filename=")) continue;
                String filename = disStr.substring("filename=".length());
                if (filename.length() > 1 && filename.startsWith("\"") && filename.endsWith("\"")) {
                    filename = filename.substring(1, filename.length() - 1);
                }
                return filename;
            }
        }
        return this.request.getFilename();
    }

    public String getContent() {
        if (this.content != null) {
            return this.content;
        }
        this.content = this.readAsString();
        return this.content;
    }

    public String readAsString() {
        try {
            byte[] bytes = this.getByteArray();
            if (bytes == null) {
                return "";
            }
            return this.byteToString(bytes);
        }
        catch (Exception e) {
            throw new ForestRuntimeException(e);
        }
    }

    public synchronized void setContent(String content) {
        this.content = content;
    }

    public T getResult() {
        if (this.result == null && this.isReceivedResponseData()) {
            Type type = this.request.getLifeCycleHandler().getResultType();
            if (type == null) {
                type = this.request.getMethod().getReturnType();
            }
            if (type == null) {
                try {
                    this.result = this.get(String.class);
                }
                catch (Throwable throwable) {}
            } else {
                Class<?> clazz = ReflectUtils.toClass(type);
                if (ForestResponse.class.isAssignableFrom(clazz)) {
                    Object argType = ReflectUtils.getGenericArgument(clazz);
                    if (argType == null) {
                        argType = String.class;
                    }
                    this.result = this.get((Type)argType);
                } else {
                    this.result = this.get(type);
                }
            }
        }
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean noException() {
        return this.exception == null;
    }

    public boolean isTimeout() {
        if (this.noException()) {
            return false;
        }
        return this.exception instanceof SocketTimeoutException;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public int getStatusCode() {
        if (this.statusCode == null) {
            return -1;
        }
        return this.statusCode;
    }

    public int statusCode() {
        if (this.statusCode == null) {
            return -1;
        }
        return this.getStatusCode();
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public boolean isSuccess() {
        if (this.success == null) {
            if (this.request != null) {
                if (this.request.getSuccessWhen() != null) {
                    this.success = this.request.getSuccessWhen().successWhen(this.request, this);
                } else {
                    SuccessWhen globalSuccessWhen = this.request.getConfiguration().getSuccessWhen();
                    if (globalSuccessWhen != null) {
                        this.success = globalSuccessWhen.successWhen(this.request, this);
                    }
                }
            }
            if (this.success == null) {
                this.success = this.noException() && this.statusOk();
            }
        }
        return this.success;
    }

    public boolean status_1xx() {
        return this.getStatusCode() >= 100 && this.getStatusCode() < 200;
    }

    public boolean status_2xx() {
        return this.getStatusCode() >= 200 && this.getStatusCode() < 300;
    }

    public boolean status_3xx() {
        return this.getStatusCode() >= 300 && this.getStatusCode() < 400;
    }

    public boolean status_4xx() {
        return this.getStatusCode() >= 400 && this.getStatusCode() < 500;
    }

    public boolean status_5xx() {
        return this.getStatusCode() >= 500 && this.getStatusCode() < 600;
    }

    public boolean statusOk() {
        return this.status_1xx() || this.status_2xx() || this.status_3xx();
    }

    public boolean statusIs(int statusCode) {
        return this.getStatusCode() == statusCode;
    }

    public boolean statusIsNot(int statusCode) {
        return this.getStatusCode() != statusCode;
    }

    public boolean isError() {
        return !this.isSuccess();
    }

    public abstract boolean isReceivedResponseData();

    public abstract byte[] getByteArray() throws Exception;

    public abstract InputStream getInputStream() throws Exception;

    public ForestHeader getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public List<ForestHeader> getHeaders(String name) {
        return this.headers.getHeaders(name);
    }

    public List<ForestCookie> getCookies() {
        return this.headers.getSetCookies();
    }

    public ForestCookie getCookie(String name) {
        return this.headers.getSetCookie(name);
    }

    public String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    public List<String> getHeaderValues(String name) {
        return this.headers.getValues(name);
    }

    public ForestHeaderMap getHeaders() {
        return this.headers;
    }

    public String getCharset() {
        return this.charset;
    }

    protected String byteToString(byte[] bytes) throws IOException {
        char[] chs;
        if (StringUtils.isEmpty(this.charset)) {
            this.charset = ByteEncodeUtils.getCharsetName(bytes);
        }
        if (this.isGzip) {
            try {
                return GzipUtils.decompressGzipToString(bytes, this.charset);
            }
            catch (Throwable th) {
                this.isGzip = false;
            }
        }
        if (!((chs = this.charset.toCharArray()).length <= 2 || chs[0] != 'g' && chs[0] != 'G' || chs[1] != 'b' && chs[1] != 'B')) {
            this.charset = "GBK";
        }
        return IOUtils.toString((byte[])bytes, (String)this.charset);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public abstract void close();
}

