/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ForestRoute {
    private final String host;
    private final int port;
    private final Map<String, Object> backendClientCache = new ConcurrentHashMap<String, Object>();
    private final AtomicInteger requestCount = new AtomicInteger(0);

    public ForestRoute(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public AtomicInteger getRequestCount() {
        return this.requestCount;
    }

    public static String domain(String host, int port) {
        StringBuilder builder = new StringBuilder(host);
        if (port != 80 && port != -1) {
            builder.append(":").append(port);
        }
        return builder.toString();
    }

    public String getDomain() {
        return ForestRoute.domain(this.host, this.port);
    }

    public <T> T getBackendClient(String key) {
        Object client = this.backendClientCache.get(key);
        if (client != null) {
            return (T)client;
        }
        return null;
    }

    public void cacheBackendClient(String key, Object client) {
        this.backendClientCache.put(key, client);
    }
}

