/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.http.ForestCookie;
import com.dtflys.forest.http.ForestHeader;
import com.dtflys.forest.http.HasURL;

public class ForestSetCookieHeader
extends ForestHeader {
    private ForestCookie cookie;
    private HasURL hasURL;

    public static ForestSetCookieHeader fromCookie(HasURL hasURL, ForestCookie cookie) {
        return new ForestSetCookieHeader("Cookie", hasURL, cookie);
    }

    public static ForestSetCookieHeader fromSetCookie(HasURL hasURL, ForestCookie cookie) {
        return new ForestSetCookieHeader("Set-Cookie", hasURL, cookie);
    }

    public ForestSetCookieHeader(String headerName, HasURL hasURL, ForestCookie cookie) {
        super(headerName, null);
        this.cookie = cookie;
        this.hasURL = hasURL;
    }

    @Override
    public String getValue() {
        return this.cookie.toString();
    }

    @Override
    public void setValue(String value) {
        ForestCookie newCookie = ForestCookie.parse(this.hasURL.url().toURLString(), value);
        if (newCookie != null) {
            super.setValue(newCookie.toString());
            this.cookie = newCookie;
        }
    }

    public ForestCookie getCookie() {
        return this.cookie;
    }

    public void setCookie(ForestCookie cookie) {
        this.cookie = cookie;
    }
}

