/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http.body;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.body.SupportFormUrlEncoded;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.RequestNameValue;
import java.util.ArrayList;
import java.util.List;

public class NameValueRequestBody
extends ForestRequestBody
implements SupportFormUrlEncoded {
    private String name;
    private Object value;
    private String contentType;

    public NameValueRequestBody(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public NameValueRequestBody(String name, String contentType, Object value) {
        this.name = name;
        this.contentType = contentType;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String toFormString() {
        if (this.name == null && this.value == null) {
            return "";
        }
        if (this.value == null) {
            return this.name;
        }
        if (this.name == null) {
            return String.valueOf(this.value);
        }
        return this.name + "=" + this.value;
    }

    public String toString() {
        return this.toFormString();
    }

    @Override
    public byte[] getByteArray() {
        return new byte[0];
    }

    @Override
    public ForestDataType getDefaultBodyType() {
        return ForestDataType.FORM;
    }

    @Override
    public List<RequestNameValue> getNameValueList(ForestConfiguration configuration) {
        ArrayList<RequestNameValue> nameValueList = new ArrayList<RequestNameValue>(1);
        nameValueList.add(new RequestNameValue(this.name, this.value, 2));
        return nameValueList;
    }
}

