/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http.body;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.body.SupportFormUrlEncoded;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.RequestNameValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ObjectRequestBody
extends ForestRequestBody
implements SupportFormUrlEncoded {
    private Object object;

    public ObjectRequestBody(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String toString() {
        return String.valueOf(this.object);
    }

    @Override
    public byte[] getByteArray() {
        if (this.object instanceof byte[]) {
            return (byte[])this.object;
        }
        try {
            if (this.object instanceof InputStream) {
                return IOUtils.toByteArray((InputStream)((InputStream)this.object));
            }
            if (this.object instanceof File) {
                return FileUtils.readFileToByteArray((File)((File)this.object));
            }
            if (this.object instanceof Reader) {
                return IOUtils.toByteArray((Reader)((Reader)this.object));
            }
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
        return this.toString().getBytes();
    }

    @Override
    public ForestDataType getDefaultBodyType() {
        return ForestDataType.FORM;
    }

    @Override
    public List<RequestNameValue> getNameValueList(ForestConfiguration configuration) {
        LinkedList<RequestNameValue> nameValueList = new LinkedList<RequestNameValue>();
        ForestJsonConverter jsonConverter = configuration.getJsonConverter();
        Map<String, Object> map = jsonConverter.convertObjectToMap(this.object);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            nameValueList.add(new RequestNameValue(entry.getKey(), entry.getValue(), 2));
        }
        return nameValueList;
    }
}

