/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http.body;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.body.SupportFormUrlEncoded;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.RequestNameValue;
import com.dtflys.forest.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;

public class StringRequestBody
extends ForestRequestBody
implements SupportFormUrlEncoded {
    private String content;

    public StringRequestBody(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        return this.content;
    }

    @Override
    public byte[] getByteArray() {
        return this.content.getBytes();
    }

    @Override
    public ForestDataType getDefaultBodyType() {
        return ForestDataType.TEXT;
    }

    @Override
    public List<RequestNameValue> getNameValueList(ForestConfiguration configuration) {
        LinkedList<RequestNameValue> nameValueList = new LinkedList<RequestNameValue>();
        if (StringUtils.isNotBlank(this.content)) {
            String[] items;
            for (String item : items = this.content.split("&")) {
                String[] pair = item.split("=", 2);
                if (pair.length == 1) {
                    nameValueList.add(new RequestNameValue(pair[0], 2));
                    continue;
                }
                if (pair.length != 2) continue;
                nameValueList.add(new RequestNameValue(pair[0], pair[1], 2));
            }
        }
        return nameValueList;
    }
}

