/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http.model;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ForestModelProperty {
    private final Object instance;
    private final String name;
    private final Field field;
    private final Method getter;
    private final Method setter;

    public ForestModelProperty(Object instance, String name, Field field, Method getter, Method setter) {
        this.instance = instance;
        this.name = name;
        this.field = field;
        this.getter = getter;
        this.setter = setter;
    }

    public Object getInstance() {
        return this.instance;
    }

    public String getName() {
        return this.name;
    }

    public Field getField() {
        return this.field;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public Object getValue() {
        if (this.getter != null) {
            try {
                return this.getter.invoke(this.instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ForestRuntimeException(e);
            }
        }
        if (this.field != null) {
            try {
                return this.field.get(this.instance);
            }
            catch (IllegalAccessException e) {
                throw new ForestRuntimeException(e);
            }
        }
        throw new ForestRuntimeException("[Forest] can not get value of field '" + this.name + "'");
    }

    public void setValue(Object value) {
        if (this.setter != null) {
            try {
                this.setter.invoke(this.instance, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ForestRuntimeException(e);
            }
        }
        if (this.field != null) {
            try {
                this.field.set(this.instance, value);
            }
            catch (IllegalAccessException e) {
                throw new ForestRuntimeException(e);
            }
        }
        throw new ForestRuntimeException("[Forest] can not set value of field '" + this.name + "'");
    }
}

