/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.interceptor;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.interceptor.Interceptor;
import com.dtflys.forest.interceptor.InterceptorChain;
import com.dtflys.forest.interceptor.InterceptorFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultInterceptorFactory
implements InterceptorFactory {
    protected final Map<Class, Interceptor> interceptorMap = new ConcurrentHashMap<Class, Interceptor>();
    protected InterceptorChain interceptorChain = new InterceptorChain();

    @Override
    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T extends Interceptor> T getInterceptor(Class<T> clazz) {
        Interceptor interceptor = this.interceptorMap.get(clazz);
        if (interceptor != null) return (T)interceptor;
        Class<DefaultInterceptorFactory> clazz2 = DefaultInterceptorFactory.class;
        synchronized (DefaultInterceptorFactory.class) {
            interceptor = this.interceptorMap.get(clazz);
            if (interceptor != null) return (T)interceptor;
            interceptor = this.createInterceptor(clazz);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (T)interceptor;
        }
    }

    protected <T extends Interceptor> Interceptor createInterceptor(Class<T> clazz) {
        Interceptor interceptor;
        try {
            interceptor = (Interceptor)clazz.newInstance();
            this.interceptorMap.put(clazz, interceptor);
        }
        catch (InstantiationException e) {
            throw new ForestRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new ForestRuntimeException(e);
        }
        return interceptor;
    }
}

