/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.interceptor;

import com.dtflys.forest.callback.OnCanceled;
import com.dtflys.forest.callback.OnError;
import com.dtflys.forest.callback.OnLoadCookie;
import com.dtflys.forest.callback.OnProgress;
import com.dtflys.forest.callback.OnRedirection;
import com.dtflys.forest.callback.OnRetry;
import com.dtflys.forest.callback.OnSaveCookie;
import com.dtflys.forest.callback.OnSuccess;
import com.dtflys.forest.converter.ForestEncoder;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestCookies;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.interceptor.InterceptorAttributes;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.utils.ForestProgress;

public interface Interceptor<T>
extends OnSuccess<T>,
OnError,
OnCanceled,
OnProgress,
OnLoadCookie,
OnSaveCookie,
OnRetry,
OnRedirection {
    default public void onInvokeMethod(ForestRequest request, ForestMethod method, Object[] args) {
    }

    default public boolean beforeExecute(ForestRequest request) {
        return true;
    }

    default public void afterExecute(ForestRequest request, ForestResponse response) {
    }

    default public byte[] onBodyEncode(ForestRequest request, ForestEncoder encoder, byte[] encodedData) {
        return encodedData;
    }

    @Override
    default public void onSuccess(T data, ForestRequest request, ForestResponse response) {
    }

    @Override
    default public void onError(ForestRuntimeException ex, ForestRequest request, ForestResponse response) {
    }

    @Override
    default public void onCanceled(ForestRequest req, ForestResponse res) {
    }

    @Override
    default public void onRetry(ForestRequest request, ForestResponse response) {
    }

    @Override
    default public void onProgress(ForestProgress progress) {
    }

    @Override
    default public void onRedirection(ForestRequest<?> redirectReq, ForestRequest<?> prevReq, ForestResponse<?> prevRes) {
    }

    @Override
    default public void onLoadCookie(ForestRequest request, ForestCookies cookies) {
    }

    @Override
    default public void onSaveCookie(ForestRequest request, ForestCookies cookies) {
    }

    default public InterceptorAttributes getAttributes(ForestRequest request) {
        return request.getInterceptorAttributes(this.getClass());
    }

    default public void addAttribute(ForestRequest request, String name, Object value) {
        request.addInterceptorAttribute(this.getClass(), name, value);
    }

    default public Object getAttribute(ForestRequest request, String name) {
        return request.getInterceptorAttribute(this.getClass(), name);
    }

    default public <T> T getAttribute(ForestRequest request, String name, Class<T> clazz) {
        Object obj = request.getInterceptorAttribute(this.getClass(), name);
        if (obj == null) {
            return null;
        }
        return (T)obj;
    }

    default public String getAttributeAsString(ForestRequest request, String name) {
        Object attr = this.getAttribute(request, name);
        if (attr == null) {
            return null;
        }
        return String.valueOf(attr);
    }

    default public Integer getAttributeAsInteger(ForestRequest request, String name) {
        Object attr = this.getAttribute(request, name);
        if (attr == null) {
            return null;
        }
        return (Integer)attr;
    }

    default public Float getAttributeAsFloat(ForestRequest request, String name) {
        Object attr = this.getAttribute(request, name);
        if (attr == null) {
            return null;
        }
        return (Float)attr;
    }

    default public Double getAttributeAsDouble(ForestRequest request, String name) {
        Object attr = this.getAttribute(request, name);
        if (attr == null) {
            return null;
        }
        return (Double)attr;
    }
}

