/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.interceptor;

import com.dtflys.forest.mapping.MappingTemplate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InterceptorAttributes {
    private final Class interceptorClass;
    private final Map<String, Object> attributeTemplates;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public InterceptorAttributes(Class interceptorClass, Map<String, Object> attributeTemplates) {
        this.interceptorClass = interceptorClass;
        this.attributeTemplates = attributeTemplates;
    }

    public Map<String, Object> render(Object[] args) {
        for (Map.Entry<String, Object> entry : this.attributeTemplates.entrySet()) {
            String name = entry.getKey();
            String[] value = entry.getValue();
            if (value instanceof MappingTemplate) {
                value = ((MappingTemplate)value).render(args);
            } else if (value instanceof MappingTemplate[]) {
                MappingTemplate[] templates = (MappingTemplate[])value;
                int len = templates.length;
                String[] strArray = new String[len];
                for (int i = 0; i < len; ++i) {
                    strArray[i] = templates[i].render(args);
                }
                value = strArray;
            }
            this.attributes.put(name, value);
        }
        return this.attributes;
    }

    public Map<String, Object> getAttributeTemplates() {
        return this.attributeTemplates;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public void addAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public Class getInterceptorClass() {
        return this.interceptorClass;
    }

    public InterceptorAttributes clone() {
        InterceptorAttributes newAttrs = new InterceptorAttributes(this.interceptorClass, this.attributeTemplates);
        newAttrs.attributes = new ConcurrentHashMap<String, Object>();
        return newAttrs;
    }
}

