/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.interceptor;

import com.dtflys.forest.converter.ForestEncoder;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestCookies;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.interceptor.Interceptor;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.utils.ForestProgress;
import java.util.LinkedList;

public class InterceptorChain
implements Interceptor {
    private LinkedList<Interceptor> interceptors = new LinkedList();

    public synchronized InterceptorChain addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    public int getInterceptorSize() {
        return this.interceptors.size();
    }

    @Override
    public void onInvokeMethod(ForestRequest request, ForestMethod method, Object[] args) {
        for (Interceptor item : this.interceptors) {
            item.onInvokeMethod(request, method, args);
        }
    }

    @Override
    public boolean beforeExecute(ForestRequest request) {
        for (Interceptor item : this.interceptors) {
            boolean result = item.beforeExecute(request);
            if (result) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] onBodyEncode(ForestRequest request, ForestEncoder encoder, byte[] encodedData) {
        byte[] ret = encodedData;
        for (Interceptor item : this.interceptors) {
            ret = item.onBodyEncode(request, encoder, ret);
        }
        return ret;
    }

    @Override
    public void onSuccess(Object data, ForestRequest request, ForestResponse response) {
        for (Interceptor item : this.interceptors) {
            if (response != null) {
                data = response.getResult();
            }
            item.onSuccess(data, request, response);
        }
    }

    @Override
    public void onRetry(ForestRequest request, ForestResponse response) {
        for (Interceptor item : this.interceptors) {
            item.onRetry(request, response);
        }
    }

    @Override
    public void onError(ForestRuntimeException ex, ForestRequest request, ForestResponse response) {
        for (Interceptor item : this.interceptors) {
            item.onError(ex, request, response);
        }
    }

    @Override
    public void onCanceled(ForestRequest request, ForestResponse response) {
        for (Interceptor item : this.interceptors) {
            item.onCanceled(request, response);
        }
    }

    public void onRedirection(ForestRequest redirectReq, ForestRequest prevReq, ForestResponse prevRes) {
        for (Interceptor item : this.interceptors) {
            item.onRedirection(redirectReq, prevReq, prevRes);
        }
    }

    @Override
    public void onProgress(ForestProgress progress) {
        for (Interceptor item : this.interceptors) {
            item.onProgress(progress);
        }
    }

    @Override
    public void onLoadCookie(ForestRequest request, ForestCookies cookies) {
        for (Interceptor item : this.interceptors) {
            item.onLoadCookie(request, cookies);
        }
    }

    @Override
    public void onSaveCookie(ForestRequest request, ForestCookies cookies) {
        for (Interceptor item : this.interceptors) {
            item.onSaveCookie(request, cookies);
        }
    }

    @Override
    public void afterExecute(ForestRequest request, ForestResponse response) {
        for (Interceptor item : this.interceptors) {
            item.afterExecute(request, response);
        }
    }
}

