/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.lifecycles.authorization;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.extensions.OAuth2;
import com.dtflys.forest.handler.OAuth2DefinitionHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.lifecycles.MethodAnnotationLifeCycle;
import com.dtflys.forest.lifecycles.authorization.OAuth2Client;
import com.dtflys.forest.lifecycles.authorization.OAuth2Token;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class OAuth2LifeCycle
implements MethodAnnotationLifeCycle<OAuth2, Object> {
    private final byte[] lock = new byte[0];
    private final Map<String, TokenCache> cache = new LinkedHashMap<String, TokenCache>();
    private OAuth2Client oAuth2Client;

    @Override
    public void onMethodInitialized(ForestMethod method, OAuth2 annotation) {
        this.oAuth2Client = method.getConfiguration().createInstance(OAuth2Client.class);
    }

    @Override
    public boolean beforeExecute(ForestRequest request) {
        TokenCache tokenCache = this.getTokenCache(request);
        OAuth2.TokenAt tokenAt = (OAuth2.TokenAt)((Object)this.getAttribute(request, "tokenAt"));
        String defaultTokenVariable = this.getAttributeAsString(request, "tokenVariable");
        String tokenVariable = tokenAt.getTokenVariable(defaultTokenVariable);
        String defaultPrefix = this.getAttributeAsString(request, "tokenPrefix");
        String tokenValue = tokenAt.getTokenValue(defaultPrefix, tokenCache.getAccessToken());
        if (tokenAt == OAuth2.TokenAt.HEADER) {
            request.addHeader(tokenVariable, tokenValue);
        } else {
            request.addQuery(tokenVariable, (Object)tokenValue);
        }
        return true;
    }

    private String getCacheId(ForestRequest request) {
        String cacheId = this.getAttributeAsString(request, "cacheId");
        if (StringUtils.isNotBlank(cacheId)) {
            return cacheId;
        }
        String tokenUri = this.getAttributeAsString(request, "tokenUri");
        String clientId = this.getAttributeAsString(request, "clientId");
        Object grantType = this.getAttribute(request, "grantType");
        String scope = this.getAttributeAsString(request, "scope");
        String username = this.getAttributeAsString(request, "username");
        return tokenUri + ":" + clientId + ":" + grantType + ":" + scope + ":" + username;
    }

    private TokenCache getTokenCache(ForestRequest request) {
        String cacheId = this.getCacheId(request);
        TokenCache tokenCache = this.cache.get(cacheId);
        if (tokenCache == null) {
            return this.obtainTokenCache(request, cacheId, null);
        }
        tokenCache = this.obtainTokenCache(request, cacheId, tokenCache);
        tokenCache = this.obtainRefreshTokenCache(request, cacheId, tokenCache);
        return tokenCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private TokenCache obtainTokenCache(ForestRequest request, String cacheId, TokenCache tokenCache) {
        if (tokenCache != null && tokenCache.getExpiresIn() > 0L) {
            return tokenCache;
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            tokenCache = this.cache.get(cacheId);
            if (tokenCache != null && tokenCache.getExpiresIn() > 0L) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return tokenCache;
            }
            tokenCache = this.requestToken(request);
            this.cache.put(cacheId, tokenCache);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return tokenCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private TokenCache obtainRefreshTokenCache(ForestRequest request, String cacheId, @Nonnull TokenCache tokenCache) {
        int refreshAtExpiresBefore = this.getAttributeAsInteger(request, "refreshAtExpiresBefore");
        if (tokenCache.getExpiresIn() > (long)refreshAtExpiresBefore) {
            return tokenCache;
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            tokenCache = this.cache.get(cacheId);
            if (tokenCache.getExpiresIn() > (long)refreshAtExpiresBefore) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return tokenCache;
            }
            tokenCache = StringUtils.isBlank(tokenCache.getRefreshToken()) ? this.requestToken(request) : this.requestRefreshToken(request, tokenCache);
            this.cache.put(cacheId, tokenCache);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return tokenCache;
        }
    }

    @Nonnull
    private TokenCache requestToken(ForestRequest request) {
        String clientId = this.getAttributeAsString(request, "clientId");
        Map<String, Object> body = this.createRequestBody(clientId, request, true);
        return this.executeRequestToken(request, clientId, body);
    }

    private TokenCache requestRefreshToken(ForestRequest request, TokenCache tokenCache) {
        String clientId = this.getAttributeAsString(request, "clientId");
        Map<String, Object> body = this.createRequestBody(clientId, request, false);
        body.put("grant_type", "refresh_token");
        body.put("refresh_token", tokenCache.getRefreshToken());
        return this.executeRequestToken(request, clientId, body);
    }

    private TokenCache executeRequestToken(ForestRequest request, String clientId, Map<String, Object> body) {
        OAuth2Token token;
        String[] bodyItems = (String[])this.getAttribute(request, "body");
        body.putAll(this.kv2map(bodyItems));
        Map<String, Object> queryItems = this.kv2map((String[])this.getAttribute(request, "query"));
        Class handlerClass = this.getAttribute(request, "OAuth2TokenHandler", Class.class);
        ForestResponse<String> response = this.oAuth2Client.token(this.getAttributeAsString(request, "tokenUri"), queryItems, body);
        try {
            OAuth2DefinitionHandler handler = (OAuth2DefinitionHandler)handlerClass.newInstance();
            ForestConfiguration configuration = request.getConfiguration();
            Map map = configuration.getConverter(ForestDataType.AUTO).convertToJavaObject(response.getContent(), Map.class);
            token = handler.getOAuth2Token(response, map);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ForestRuntimeException("OAuth2 request OAuth2DefinitionHandler error" + e.getMessage());
        }
        if (token == null) {
            throw new ForestRuntimeException("OAuth2 request OAuth2Token is empty");
        }
        return new TokenCache(clientId, token);
    }

    private Map<String, Object> kv2map(String[] values) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String value : values) {
            int indexOf = value.indexOf(":");
            map.put(value.substring(0, indexOf), StringUtils.trimBegin(value.substring(indexOf + 1)));
        }
        return map;
    }

    private Map<String, Object> createRequestBody(String clientId, ForestRequest request, boolean fillAccount) {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("client_id", clientId);
        body.put("client_secret", this.getAttributeAsString(request, "clientSecret"));
        body.put("scope", this.getAttributeAsString(request, "scope"));
        OAuth2.GrantType grantType = (OAuth2.GrantType)((Object)this.getAttribute(request, "grantType"));
        String grantTypeValue = grantType.getValue(this.getAttributeAsString(request, "grantTypeValue"));
        body.put("grant_type", grantTypeValue);
        if (fillAccount && grantType == OAuth2.GrantType.PASSWORD) {
            body.put("username", this.getAttributeAsString(request, "username"));
            body.put("password", this.getAttributeAsString(request, "password"));
        }
        return body;
    }

    public static class TokenCache {
        private final String clientId;
        private final String accessToken;
        private final String refreshToken;
        @Deprecated
        private final String tokenType;
        private final LocalDateTime expiresAt;

        public TokenCache(String clientId, OAuth2Token token) {
            if (token.hasError()) {
                throw new ForestRuntimeException("OAuth2 request Token failure, response: " + token.getErrorMessage());
            }
            this.clientId = clientId;
            this.accessToken = token.getAccess_token();
            this.refreshToken = token.getRefresh_token();
            this.tokenType = token.getToken_type();
            Long expires = token.getExpires_in();
            if (expires == null) {
                expires = 0L;
            }
            this.expiresAt = LocalDateTime.now().plusSeconds(expires);
        }

        public boolean isNoExpires() {
            return LocalDateTime.now().isBefore(this.expiresAt);
        }

        public long getExpiresIn() {
            Duration between = Duration.between(LocalDateTime.now(), this.expiresAt);
            return between.getSeconds();
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public LocalDateTime getExpiresAt() {
            return this.expiresAt;
        }
    }
}

