/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.lifecycles.file;

import com.dtflys.forest.ForestGenericClient;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.extensions.DownloadFile;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.lifecycles.MethodAnnotationLifeCycle;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.logging.LogConfiguration;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.ReflectUtils;
import com.dtflys.forest.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.io.FileUtils;

public class DownloadLifeCycle
implements MethodAnnotationLifeCycle<DownloadFile, Object> {
    public static final String ATTACHMENT_NAME_FILE = "__file";

    @Override
    public void onMethodInitialized(ForestMethod method, DownloadFile annotation) {
    }

    @Override
    public void onInvokeMethod(ForestRequest request, ForestMethod method, Object[] args) {
        Type resultType = method.getResultType();
        this.addAttribute(request, "__resultType", resultType);
        request.setDownloadFile(true);
    }

    @Override
    public boolean beforeExecute(ForestRequest request) {
        if (request.getMethod().getMethod().getDeclaringClass() == ForestGenericClient.class) {
            Type resultType = this.getResultType(request.getLifeCycleHandler().getResultType());
            this.addAttribute(request, "__resultType", resultType);
            request.setDownloadFile(true);
        }
        return true;
    }

    private Type getResultType(Type type) {
        Type[] types;
        if (type == null) {
            return Void.class;
        }
        Class<?> clazz = ReflectUtils.toClass(type);
        if (ForestResponse.class.isAssignableFrom(clazz) && type instanceof ParameterizedType && (types = ((ParameterizedType)type).getActualTypeArguments()).length > 0) {
            return types[0];
        }
        return type;
    }

    @Override
    public void onSuccess(Object data, ForestRequest request, ForestResponse response) {
        String dirPath = this.getAttributeAsString(request, "dir");
        String filename = this.getAttributeAsString(request, "filename");
        Type resultType = this.getAttribute(request, "__resultType", Type.class);
        if (StringUtils.isBlank(filename)) {
            filename = response.getFilename();
        }
        LogConfiguration logConfiguration = request.getLogConfiguration();
        ForestLogHandler logHandler = logConfiguration.getLogHandler();
        File dir = new File(dirPath);
        if (!dir.exists()) {
            try {
                dir.mkdirs();
                if (logConfiguration.isLogEnabled()) {
                    logHandler.logContent("Created directory '" + dirPath + "' successful.");
                }
            }
            catch (Throwable th) {
                throw new ForestRuntimeException(th);
            }
        }
        InputStream in = null;
        if (data != null && data instanceof byte[]) {
            in = new ByteArrayInputStream((byte[])data);
        } else {
            try {
                in = response.getInputStream();
            }
            catch (Exception e) {
                throw new ForestRuntimeException(e);
            }
        }
        String path = dir.getAbsolutePath() + File.separator + filename;
        File file = new File(path);
        try {
            FileUtils.copyInputStreamToFile((InputStream)in, (File)file);
            FileUtils.waitFor((File)file, (int)10);
            if (logConfiguration.isLogEnabled() || !file.exists()) {
                logHandler.logContent("Saved file '" + path + "' successful.");
            }
            request.addAttachment(ATTACHMENT_NAME_FILE, file);
            if (resultType != null) {
                ForestConverter converter = request.getConfiguration().getConverterMap().get(ForestDataType.AUTO);
                data = converter.convertToJavaObject(file, resultType);
                response.setResult(data);
            }
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new ForestRuntimeException(e);
            }
        }
    }
}

