/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.lifecycles.method;

import com.dtflys.forest.annotation.BackendClient;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.lifecycles.MethodAnnotationLifeCycle;
import com.dtflys.forest.reflection.ForestMethod;

public class BackendClientLifeCycle
implements MethodAnnotationLifeCycle<BackendClient, Object> {
    private static final String PARAM_KEY_BACKEND_CLIENT_CACHE = "__backend_client_cache";

    @Override
    public void onMethodInitialized(ForestMethod method, BackendClient annotation) {
        Boolean cache = annotation.cache();
        method.setExtensionParameterValue(PARAM_KEY_BACKEND_CLIENT_CACHE, cache);
    }

    @Override
    public void onInvokeMethod(ForestRequest request, ForestMethod method, Object[] args) {
        Object cache = request.getMethod().getExtensionParameterValue(PARAM_KEY_BACKEND_CLIENT_CACHE);
        if (cache != null && cache instanceof Boolean) {
            request.cacheBackendClient((Boolean)cache);
        }
    }
}

