/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.lifecycles.method;

import com.dtflys.forest.annotation.Backend;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.lifecycles.MethodAnnotationLifeCycle;
import com.dtflys.forest.mapping.MappingTemplate;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.utils.StringUtils;

public class BackendLifeCycle
implements MethodAnnotationLifeCycle<Backend, Object> {
    private static final String PARAM_KEY_BACKEND_NAME = "__backend_name";

    @Override
    public void onMethodInitialized(ForestMethod method, Backend annotation) {
        String backendName = annotation.value();
        if (StringUtils.isNotBlank(backendName)) {
            MappingTemplate template = method.makeTemplate(Backend.class, "value", backendName);
            method.setExtensionParameterValue(PARAM_KEY_BACKEND_NAME, template);
        }
    }

    @Override
    public void onInvokeMethod(ForestRequest request, ForestMethod method, Object[] args) {
        Object backendName = request.getMethod().getExtensionParameterValue(PARAM_KEY_BACKEND_NAME);
        if (backendName != null && backendName instanceof MappingTemplate) {
            request.setBackend(((MappingTemplate)backendName).render(args));
        }
    }
}

