/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.lifecycles.method;

import com.dtflys.forest.annotation.SSLHostnameVerifier;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.lifecycles.MethodAnnotationLifeCycle;
import com.dtflys.forest.reflection.ForestMethod;
import javax.net.ssl.HostnameVerifier;

public class SSLHostnameVerifierLifeCycle
implements MethodAnnotationLifeCycle<SSLHostnameVerifier, Object> {
    private static final String PARAM_KEY_HOSTNAME_VERIFIER = "__hostname_verifier";

    @Override
    public void onMethodInitialized(ForestMethod method, SSLHostnameVerifier annotation) {
        Class<? extends HostnameVerifier> clazz = annotation.value();
        HostnameVerifier hostnameVerifier = method.getConfiguration().getForestObjectFactory().getObject(clazz);
        if (hostnameVerifier != null) {
            method.setExtensionParameterValue(PARAM_KEY_HOSTNAME_VERIFIER, hostnameVerifier);
        }
    }

    @Override
    public void onInvokeMethod(ForestRequest request, ForestMethod method, Object[] args) {
        Object hostnameVerifier = request.getMethod().getExtensionParameterValue(PARAM_KEY_HOSTNAME_VERIFIER);
        if (hostnameVerifier != null && hostnameVerifier instanceof HostnameVerifier) {
            request.hostnameVerifier((HostnameVerifier)hostnameVerifier);
        }
    }
}

