/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.lifecycles.parameter;

import com.dtflys.forest.annotation.Return;
import com.dtflys.forest.exceptions.ForestReturnException;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.lifecycles.ParameterAnnotationLifeCycle;
import com.dtflys.forest.mapping.MappingParameter;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.reflection.MethodLifeCycleHandler;
import com.dtflys.forest.utils.TypeReference;
import java.lang.reflect.Type;

public class ReturnLifeCycle
implements ParameterAnnotationLifeCycle<Return, Object> {
    private static final String PARAM_KEY_RETURN_TYPE_NAME = "__return_type";

    @Override
    public void onParameterInitialized(ForestMethod method, MappingParameter parameter, Return annotation) {
        Class<?> paramType = parameter.getType();
        if (!(Class.class.isAssignableFrom(paramType) || Type.class.isAssignableFrom(paramType) || TypeReference.class.isAssignableFrom(paramType))) {
            throw new ForestReturnException(paramType);
        }
        method.setExtensionParameterValue(PARAM_KEY_RETURN_TYPE_NAME, parameter.getIndex());
    }

    @Override
    public void onInvokeMethod(ForestRequest request, ForestMethod method, Object[] args) {
        Object ext = method.getExtensionParameterValue(PARAM_KEY_RETURN_TYPE_NAME);
        if (ext != null) {
            Integer index = (Integer)ext;
            Object arg = args[index];
            if (arg == null) {
                return;
            }
            if (!(arg instanceof Type)) {
                return;
            }
            Type type = (Type)arg;
            LifeCycleHandler lifeCycleHandler = request.getLifeCycleHandler();
            if (lifeCycleHandler != null && lifeCycleHandler instanceof MethodLifeCycleHandler) {
                MethodLifeCycleHandler methodLifeCycleHandler = (MethodLifeCycleHandler)lifeCycleHandler;
                methodLifeCycleHandler.setResultType(type);
            }
        }
    }

    @Override
    public boolean beforeExecute(ForestRequest request) {
        return true;
    }
}

