/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.lifecycles.parameter;

import com.dtflys.forest.annotation.DataFile;
import com.dtflys.forest.annotation.XMLBody;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.filter.Filter;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.lifecycles.parameter.AbstractBodyLifeCycle;
import com.dtflys.forest.mapping.MappingParameter;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.reflection.MetaRequest;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import java.lang.reflect.Parameter;

public class XMLBodyLifeCycle
extends AbstractBodyLifeCycle<XMLBody> {
    @Override
    public void onParameterInitialized(ForestMethod method, MappingParameter parameter, XMLBody annotation) {
        super.onParameterInitialized(method, parameter, annotation);
        MetaRequest metaRequest = method.getMetaRequest();
        String methodName = XMLBodyLifeCycle.methodName(method);
        if (metaRequest == null) {
            throw new ForestRuntimeException("[Forest] method '" + methodName + "' has not bind a Forest request annotation. Hence the annotation @XMLBody cannot be bind on a parameter in this method.");
        }
        String contentType = metaRequest.getContentType();
        if (StringUtils.isNotEmpty(contentType) && !"application/xml".equals(contentType) && contentType.indexOf("$") < 0) {
            throw new ForestRuntimeException("[Forest] the Content-Type of request binding on method '" + methodName + "' has already been set value '" + contentType + "', not 'application/xml'. Hence the annotation @XMLBody cannot be bind on a parameter in this method.");
        }
        boolean hasDataFileAnn = false;
        for (Parameter param : method.getMethod().getParameters()) {
            DataFile dataFileAnn = param.getAnnotation(DataFile.class);
            if (dataFileAnn == null) continue;
            hasDataFileAnn = true;
            break;
        }
        Filter filter = method.getConfiguration().newFilterInstance("xml");
        parameter.addFilter(filter);
        if (StringUtils.isBlank(contentType) && !hasDataFileAnn) {
            metaRequest.setContentType("application/xml");
        }
        if (metaRequest.getBodyType() == null) {
            metaRequest.setBodyType(ForestDataType.XML);
        }
    }

    private static String methodName(ForestMethod method) {
        return method.getMethod().toGenericString();
    }

    @Override
    public boolean beforeExecute(ForestRequest request) {
        String contentType = request.getContentType();
        if (StringUtils.isBlank(contentType)) {
            request.setContentType("application/xml");
        }
        if (contentType.indexOf("application/xml") < 0) {
            String methodName = XMLBodyLifeCycle.methodName(request.getMethod());
            throw new ForestRuntimeException("[Forest] the Content-Type of request binding on method '" + methodName + "' has already been set value '" + contentType + "', not 'application/xml'. Hence the annotation @XMLBody cannot be bind on a parameter in this method.");
        }
        return true;
    }
}

