/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.logging;

import com.dtflys.forest.backend.HttpBackend;
import com.dtflys.forest.http.ForestAsyncMode;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.logging.ForestLogger;
import com.dtflys.forest.logging.LogBodyMessage;
import com.dtflys.forest.logging.LogHeaderMessage;
import com.dtflys.forest.logging.RequestLogMessage;
import com.dtflys.forest.logging.RequestProxyLogMessage;
import com.dtflys.forest.logging.ResponseLogMessage;
import com.dtflys.forest.utils.StringUtils;
import java.util.List;

public class DefaultLogHandler
implements ForestLogHandler {
    private ForestLogger logger = new ForestLogger();

    protected String requestLoggingHeaders(RequestLogMessage requestLogMessage) {
        StringBuilder builder = new StringBuilder();
        List<LogHeaderMessage> headers = requestLogMessage.getHeaders();
        if (headers == null) {
            return "";
        }
        for (int i = 0; i < headers.size(); ++i) {
            LogHeaderMessage headerMessage = headers.get(i);
            String name = headerMessage.getName();
            String value = headerMessage.getValue();
            builder.append("\t\t" + name + ": " + value);
            if (i >= headers.size() - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    protected String requestLoggingBody(RequestLogMessage requestLogMessage) {
        LogBodyMessage logBodyMessage = requestLogMessage.getBody();
        if (logBodyMessage == null) {
            return "";
        }
        return logBodyMessage.getBodyString();
    }

    protected String requestTypeChangeHistory(RequestLogMessage requestLogMessage) {
        List<String> typeChangeHistory = requestLogMessage.getTypeChangeHistory();
        if (typeChangeHistory == null || typeChangeHistory.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[Type Change]: ");
        for (String type : typeChangeHistory) {
            builder.append(type).append(" -> ");
        }
        builder.append(requestLogMessage.getType()).append("\n\t");
        return builder.toString();
    }

    protected String asyncModeContent(RequestLogMessage requestLogMessage) {
        ForestRequest request = requestLogMessage.getRequest();
        if (!request.isAsync()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("[async");
        if (ForestAsyncMode.KOTLIN_COROUTINE == request.getAsyncMode()) {
            builder.append(": kotlin");
        }
        builder.append("] ");
        return builder.toString();
    }

    protected String backendContent(RequestLogMessage requestLogMessage) {
        HttpBackend backend = requestLogMessage.getRequest().getBackend();
        if (backend == null) {
            return "";
        }
        return "(" + backend.getName() + ")";
    }

    protected String retryContent(RequestLogMessage requestLogMessage) {
        int retryCount = requestLogMessage.getRetryCount();
        if (retryCount > 0) {
            return "[Retry]: " + retryCount + "\n\t";
        }
        return "";
    }

    protected String redirection(RequestLogMessage requestLogMessage) {
        ForestRequest request = requestLogMessage.getRequest();
        if (request.isRedirection()) {
            ForestRequest<?> prevRequest = request.getPrevRequest();
            ForestResponse<?> prevResponse = request.getPrevResponse();
            return "[Redirect]: From " + prevRequest.getType().getName() + " " + prevRequest.getUrl() + " -> " + prevResponse.getStatusCode() + "\n\t";
        }
        return "";
    }

    protected String proxyContent(RequestLogMessage requestLogMessage) {
        RequestProxyLogMessage proxyLogMessage = requestLogMessage.getProxy();
        if (proxyLogMessage != null) {
            return "[Proxy]: host: " + proxyLogMessage.getHost() + ", port: " + proxyLogMessage.getPort() + "\n\t";
        }
        return "";
    }

    protected String requestLoggingContent(RequestLogMessage requestLogMessage) {
        String body;
        StringBuilder builder = new StringBuilder();
        builder.append("Request ");
        builder.append(this.asyncModeContent(requestLogMessage));
        builder.append(this.backendContent(requestLogMessage));
        builder.append(": \n\t");
        builder.append(this.retryContent(requestLogMessage));
        builder.append(this.redirection(requestLogMessage));
        builder.append(this.proxyContent(requestLogMessage));
        builder.append(this.requestTypeChangeHistory(requestLogMessage));
        builder.append(requestLogMessage.getRequestLine());
        String headers = this.requestLoggingHeaders(requestLogMessage);
        if (StringUtils.isNotEmpty(headers)) {
            builder.append("\n\tHeaders: \n");
            builder.append(headers);
        }
        if (StringUtils.isNotEmpty(body = this.requestLoggingBody(requestLogMessage))) {
            builder.append("\n\tBody: ");
            builder.append(body);
        }
        return builder.toString();
    }

    protected String responseLoggingContent(ResponseLogMessage responseLogMessage) {
        ForestResponse response = responseLogMessage.getResponse();
        if (response != null && response.getException() != null) {
            return "Response: [Network Error]: " + response.getException().getMessage();
        }
        int status = responseLogMessage.getStatus();
        if (status >= 0) {
            return "Response: Status = " + responseLogMessage.getStatus() + ", Time = " + responseLogMessage.getTime() + "ms";
        }
        return "Response: [Network Error]: Unknown Network Error!";
    }

    @Override
    public void logContent(String content) {
        this.getLogger().info("[Forest] " + content, new Object[0]);
    }

    @Override
    public ForestLogger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(ForestLogger logger) {
        this.logger = logger;
    }

    @Override
    public void logRequest(RequestLogMessage requestLogMessage) {
        String content = this.requestLoggingContent(requestLogMessage);
        this.logContent(content);
    }

    @Override
    public void logResponseStatus(ResponseLogMessage responseLogMessage) {
        String content = this.responseLoggingContent(responseLogMessage);
        this.logContent(content);
    }

    @Override
    public void logResponseContent(ResponseLogMessage responseLogMessage) {
        String content;
        if (responseLogMessage.getResponse() != null && StringUtils.isNotEmpty(content = responseLogMessage.getResponse().getContent())) {
            this.logContent("Response Content:\n\t" + content);
        }
    }
}

