/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.mapping;

import com.dtflys.forest.config.VariableScope;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.mapping.MappingExpr;
import com.dtflys.forest.mapping.MappingIdentity;
import com.dtflys.forest.mapping.Token;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.utils.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class MappingDot
extends MappingExpr {
    protected final MappingExpr left;
    protected final MappingIdentity right;

    public MappingDot(ForestMethod forestMethod, VariableScope variableScope, MappingExpr left, MappingIdentity right) {
        this(forestMethod, Token.DOT, variableScope, left, right);
    }

    protected MappingDot(ForestMethod forestMethod, Token token, VariableScope variableScope, MappingExpr left, MappingIdentity right) {
        super(forestMethod, token);
        this.variableScope = variableScope;
        this.left = left;
        this.right = right;
    }

    public Method getPropMethodFromClass(Class clazz, MappingIdentity right) {
        Method method = null;
        String getterName = StringUtils.toGetterName(right.getName());
        NoSuchMethodException th = null;
        try {
            method = clazz.getDeclaredMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                method = clazz.getDeclaredMethod(right.getName(), new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                th = e1;
            }
        }
        if (method == null) {
            if (!Object.class.equals((Object)clazz)) {
                return this.getPropMethodFromClass(clazz.getSuperclass(), right);
            }
            if (th != null) {
                throw new ForestRuntimeException(th);
            }
        }
        return method;
    }

    @Override
    public void setVariableScope(VariableScope variableScope) {
        super.setVariableScope(variableScope);
        if (this.left != null) {
            this.left.setVariableScope(variableScope);
        }
        if (this.right != null) {
            this.right.setVariableScope(variableScope);
        }
    }

    @Override
    public boolean isIterateVariable() {
        boolean ret = false;
        if (this.left != null) {
            ret = this.left.isIterateVariable();
        }
        if (this.right != null) {
            ret = ret || this.right.isIterateVariable();
        }
        return ret;
    }

    @Override
    public Object render(Object[] args) {
        Object obj = this.left.render(args);
        if (obj == null) {
            throw new ForestRuntimeException(new NullPointerException());
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(this.right.getName());
        }
        String getterName = StringUtils.toGetterName(this.right.getName());
        Method method = this.getPropMethodFromClass(obj.getClass(), this.right);
        if (method == null) {
            throw new ForestRuntimeException(new NoSuchMethodException(getterName));
        }
        try {
            Object result = method.invoke(obj, new Object[0]);
            return result;
        }
        catch (InvocationTargetException e) {
            throw new ForestRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new ForestRuntimeException(e);
        }
    }

    public String toString() {
        return "[Dot: " + this.left.toString() + "." + this.right + "]";
    }
}

