/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.mapping;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.mapping.MappingExpr;
import com.dtflys.forest.mapping.Token;

public class MappingIndex
extends MappingExpr {
    private final Integer index;

    public MappingIndex(Integer index) {
        super(null, Token.INDEX);
        this.index = index;
    }

    @Override
    public Object render(Object[] args) {
        if (this.index < 0) {
            int argIndex = args.length + this.index;
            if (argIndex < 0) {
                throw new ForestRuntimeException(new IndexOutOfBoundsException(this.index + " is a invalid index"));
            }
            return args[argIndex];
        }
        return args[this.index];
    }

    @Override
    public boolean isIterateVariable() {
        return false;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String toString() {
        return "[Index: " + this.index + "]";
    }
}

