/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.mapping;

import com.dtflys.forest.config.VariableScope;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.mapping.MappingDot;
import com.dtflys.forest.mapping.MappingExpr;
import com.dtflys.forest.mapping.MappingIdentity;
import com.dtflys.forest.mapping.Token;
import com.dtflys.forest.reflection.ForestMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class MappingInvoke
extends MappingDot {
    private List<MappingExpr> argList;

    public MappingInvoke(ForestMethod<?> forestMethod, VariableScope variableScope, MappingExpr left, MappingIdentity name, List<MappingExpr> argList) {
        this(forestMethod, Token.INVOKE, variableScope, left, name, argList);
    }

    protected MappingInvoke(ForestMethod<?> forestMethod, Token token, VariableScope variableScope, MappingExpr left, MappingIdentity name, List<MappingExpr> argList) {
        super(forestMethod, token, variableScope, left, name);
        this.argList = argList;
    }

    public List<MappingExpr> getArgList() {
        return this.argList;
    }

    @Override
    public void setVariableScope(VariableScope variableScope) {
        super.setVariableScope(variableScope);
        if (this.argList != null) {
            for (MappingExpr arg : this.argList) {
                arg.setVariableScope(variableScope);
            }
        }
    }

    @Override
    public Object render(Object[] args) {
        Object obj = this.left.render(args);
        String methodName = this.right.getName();
        try {
            Method method = obj.getClass().getDeclaredMethod(methodName, new Class[0]);
            Object result = null;
            if (this.argList == null || this.argList.isEmpty()) {
                result = method.invoke(obj, new Object[0]);
            } else {
                Object[] renderArgs = new Object[this.argList.size()];
                int len = this.argList.size();
                for (int i = 0; i < len; ++i) {
                    MappingExpr expr = this.argList.get(i);
                    renderArgs[i] = expr.render(args);
                }
                result = method.invoke(obj, renderArgs);
            }
            return result;
        }
        catch (NoSuchMethodException e) {
            throw new ForestRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ForestRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new ForestRuntimeException(e);
        }
    }

    @Override
    public boolean isIterateVariable() {
        boolean ret = super.isIterateVariable();
        if (ret) {
            return true;
        }
        for (MappingExpr argExpr : this.argList) {
            if (!argExpr.isIterateVariable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "[Invoke: " + this.left.toString() + "." + this.right + " ()]";
    }
}

