/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.mapping;

import com.dtflys.forest.config.ForestProperties;
import com.dtflys.forest.config.VariableScope;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestTemplateSyntaxError;
import com.dtflys.forest.exceptions.ForestVariableUndefinedException;
import com.dtflys.forest.mapping.MappingBoolean;
import com.dtflys.forest.mapping.MappingDot;
import com.dtflys.forest.mapping.MappingDouble;
import com.dtflys.forest.mapping.MappingExpr;
import com.dtflys.forest.mapping.MappingFilterInvoke;
import com.dtflys.forest.mapping.MappingFloat;
import com.dtflys.forest.mapping.MappingIdentity;
import com.dtflys.forest.mapping.MappingIndex;
import com.dtflys.forest.mapping.MappingInteger;
import com.dtflys.forest.mapping.MappingInvoke;
import com.dtflys.forest.mapping.MappingLong;
import com.dtflys.forest.mapping.MappingParameter;
import com.dtflys.forest.mapping.MappingProperty;
import com.dtflys.forest.mapping.MappingReference;
import com.dtflys.forest.mapping.MappingString;
import com.dtflys.forest.mapping.MappingUrlEncodedExpr;
import com.dtflys.forest.mapping.Token;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.utils.StringUtils;
import com.dtflys.forest.utils.URLUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MappingTemplate {
    protected final Class<? extends Annotation> annotationType;
    protected final String attributeName;
    protected final ForestMethod<?> forestMethod;
    protected final MappingParameter[] parameters;
    protected final ForestProperties properties;
    protected String template;
    protected List<MappingExpr> exprList;
    protected VariableScope variableScope;
    int readIndex = -1;

    private boolean isEnd(int index) {
        return index >= this.template.length() - 1;
    }

    private boolean isEnd() {
        return this.readIndex >= this.template.length() - 1;
    }

    private char nextChar() {
        ++this.readIndex;
        return this.template.charAt(this.readIndex);
    }

    private void skipSpaces() {
        if (this.isEnd()) {
            return;
        }
        char ch = this.watch(1);
        while (!(ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r' || this.isEnd())) {
            this.nextChar();
            ch = this.watch(1);
        }
    }

    public VariableScope getVariableScope() {
        return this.variableScope;
    }

    public void setVariableScope(VariableScope variableScope) {
        this.variableScope = variableScope;
        int len = this.exprList.size();
        for (int i = 0; i < len; ++i) {
            MappingExpr expr = this.exprList.get(i);
            expr.setVariableScope(variableScope);
        }
    }

    public ForestProperties getProperties() {
        return this.properties;
    }

    private void match(char except) {
        if (this.isEnd()) {
            throw new ForestTemplateSyntaxError("Template Expression Parse Error:\n Not found '" + except + "', column " + this.readIndex + " at \"" + this.template + "\"");
        }
        char real = this.nextChar();
        if (except != real) {
            throw new ForestTemplateSyntaxError("Template Expression Parse Error:\n It except '" + except + "', But found '" + real + "', column " + this.readIndex + " at \"" + this.template + "\"");
        }
    }

    private void matchToken(MappingExpr expr, Token token) {
        if (expr.token != token) {
            throw new ForestTemplateSyntaxError("Template Expression Parse Error:\n It except " + token.getName() + ", But found " + expr.token.getName() + ", column " + this.readIndex + " at \"" + this.template + "\"");
        }
    }

    private char watch(int i) {
        if (this.template.length() <= this.readIndex + i) {
            this.syntaxErrorWatchN(this.template.charAt(this.template.length() - 1), i);
        }
        return this.template.charAt(this.readIndex + i);
    }

    public MappingTemplate(Class<? extends Annotation> annotationType, String attributeName, ForestMethod<?> forestMethod, String template, VariableScope variableScope, ForestProperties properties, MappingParameter[] parameters) {
        this.annotationType = annotationType;
        this.attributeName = attributeName;
        this.forestMethod = forestMethod;
        this.template = template;
        this.variableScope = variableScope;
        this.properties = properties;
        this.parameters = parameters;
        if (this.template == null) {
            this.template = "";
        }
        this.compile();
    }

    public void compile() {
        this.readIndex = -1;
        this.exprList = new ArrayList<MappingExpr>();
        StringBuffer buffer = new StringBuffer();
        while (!this.isEnd()) {
            MappingExpr expr;
            MappingString str;
            char ch1;
            char ch = this.nextChar();
            if (ch == '$') {
                ch1 = this.watch(1);
                if (ch1 == '{') {
                    this.nextChar();
                    if (buffer.length() > 0) {
                        str = new MappingString(buffer.toString());
                        this.exprList.add(str);
                    }
                    buffer = new StringBuffer();
                    expr = this.parseExpression();
                    this.match('}');
                    if (expr == null) continue;
                    this.exprList.add(expr);
                    continue;
                }
            } else if (ch == '{') {
                if (buffer.length() > 0) {
                    MappingString str2 = new MappingString(buffer.toString());
                    this.exprList.add(str2);
                }
                int oldIndex = this.readIndex;
                buffer = new StringBuffer();
                expr = null;
                try {
                    expr = this.parseExpression();
                }
                catch (ForestTemplateSyntaxError th) {
                    this.exprList.add(new MappingString("{"));
                    this.readIndex = oldIndex;
                    continue;
                }
                this.match('}');
                if (expr == null) continue;
                expr = new MappingUrlEncodedExpr(this.forestMethod, expr);
                this.exprList.add(expr);
                continue;
            }
            if (ch == '#') {
                ch1 = this.watch(1);
                if (ch1 == '{') {
                    this.nextChar();
                    if (buffer.length() > 0) {
                        str = new MappingString(buffer.toString());
                        this.exprList.add(str);
                    }
                    buffer = new StringBuffer();
                    expr = this.parseProperty();
                    this.match('}');
                    if (expr == null) continue;
                    this.exprList.add(expr);
                    continue;
                }
            } else if (ch == '\\') {
                char nc = this.watch(1);
                if (nc == '$' || nc == '{') {
                    ch = this.nextChar();
                    buffer.append(ch);
                } else {
                    buffer.append(ch);
                }
            }
            buffer.append(ch);
        }
        if (buffer.length() > 0) {
            MappingString str = new MappingString(buffer.toString());
            this.exprList.add(str);
        }
    }

    public boolean hasIterateVariable() {
        for (MappingExpr expr : this.exprList) {
            if (!expr.isIterateVariable()) continue;
            return true;
        }
        return false;
    }

    private void syntaxErrorWatch1(char ch) {
        throw new ForestTemplateSyntaxError("Template Expression Parse Error:\n Character '" + ch + "', column " + (this.readIndex + 2) + " at \"" + this.template + "\"");
    }

    private void syntaxErrorWatchN(char ch, int n) {
        throw new ForestTemplateSyntaxError("Template Expression Parse Error:\n Character '" + ch + "', column " + (this.readIndex + n + 1) + " at \"" + this.template + "\"");
    }

    public MappingProperty parseProperty() {
        MappingProperty prop = null;
        char ch = this.watch(1);
        if (Character.isAlphabetic(ch) || ch == '_' || ch == '-') {
            prop = this.parsePropertyName();
        } else {
            this.syntaxErrorWatch1(ch);
        }
        return prop;
    }

    public MappingExpr parseExpression() {
        MappingExpr expr = null;
        block9: while (!this.isEnd()) {
            char ch = this.watch(1);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.skipSpaces();
                    continue block9;
                }
                case ')': 
                case '}': {
                    if (expr == null) {
                        this.syntaxErrorWatch1(ch);
                    }
                    if (expr instanceof MappingInteger) {
                        return new MappingIndex(((MappingInteger)expr).getNumber());
                    }
                    if (expr instanceof MappingIdentity) {
                        return new MappingReference(this.forestMethod, this.variableScope, ((MappingIdentity)expr).getName());
                    }
                    return expr;
                }
                case '\'': {
                    this.nextChar();
                    expr = this.parseString(ch);
                    this.match('\'');
                    continue block9;
                }
                case '\"': {
                    this.nextChar();
                    expr = this.parseString(ch);
                    this.match('\"');
                    continue block9;
                }
                case '$': {
                    this.nextChar();
                    expr = this.parseIndex();
                    continue block9;
                }
                case '.': {
                    this.nextChar();
                    if (expr instanceof MappingIdentity) {
                        expr = new MappingReference(this.forestMethod, this.variableScope, ((MappingIdentity)expr).getName());
                    }
                    MappingIdentity id = this.parseIdentity();
                    expr = new MappingDot(this.forestMethod, this.variableScope, expr, id);
                    continue block9;
                }
                case '(': {
                    this.nextChar();
                    MappingIdentity methodName = null;
                    if (expr == null) {
                        this.syntaxErrorWatch1(ch);
                    }
                    if (expr.token == Token.DOT && ((MappingDot)expr).right != null) {
                        methodName = ((MappingDot)expr).right;
                        expr = ((MappingDot)expr).left;
                    } else if (expr.token == Token.ID) {
                        methodName = (MappingIdentity)expr;
                        expr = null;
                    }
                    if (methodName == null || StringUtils.isEmpty(methodName.getName())) {
                        this.syntaxErrorWatch1(ch);
                    }
                    expr = this.parseInvokeParams(this.variableScope, expr, methodName);
                    this.match(')');
                    continue block9;
                }
            }
            expr = this.parseLiteral();
        }
        return expr;
    }

    public MappingIdentity parseIdentity() {
        MappingExpr expr = this.parseTextToken();
        this.matchToken(expr, Token.ID);
        return (MappingIdentity)expr;
    }

    public MappingProperty parsePropertyName() {
        char ch = this.watch(1);
        StringBuilder builder = new StringBuilder();
        if (Character.isAlphabetic(ch) || ch == '_' || ch == '-') {
            do {
                builder.append(ch);
                this.nextChar();
            } while (Character.isAlphabetic(ch = this.watch(1)) || Character.isDigit(ch) || ch == '_' || ch == '-' || ch == '[' || ch == ']' || ch == '.');
        }
        String text = builder.toString();
        return new MappingProperty(this.forestMethod, text);
    }

    public MappingExpr parseTextToken() {
        String text;
        char ch = this.watch(1);
        StringBuilder builder = new StringBuilder();
        if (Character.isAlphabetic(ch) || ch == '_') {
            do {
                builder.append(ch);
                this.nextChar();
            } while (Character.isAlphabetic(ch = this.watch(1)) || Character.isDigit(ch) || ch == '_');
        }
        if ("true".equals(text = builder.toString())) {
            return new MappingBoolean(true);
        }
        if ("false".equals(text)) {
            return new MappingBoolean(false);
        }
        return new MappingIdentity(text);
    }

    public MappingIndex parseIndex() {
        char ch = this.watch(1);
        int index = 0;
        int n = 0;
        while (Character.isDigit(ch)) {
            int x = ch - 48;
            index = 10 * n + x;
            ++n;
            this.nextChar();
            ch = this.watch(1);
        }
        return new MappingIndex(index);
    }

    public MappingString parseString(char quoteChar) {
        StringBuilder builder = new StringBuilder();
        char ch = this.watch(1);
        while (ch != quoteChar && !this.isEnd()) {
            builder.append(ch);
            this.nextChar();
            ch = this.watch(1);
        }
        return new MappingString(builder.toString());
    }

    public MappingInvoke parseInvokeParams(VariableScope variableScope, MappingExpr left, MappingIdentity name) {
        return this.parseMethodParams_inner(variableScope, left, name, new ArrayList<MappingExpr>());
    }

    public MappingInvoke parseMethodParams_inner(VariableScope variableScope, MappingExpr left, MappingIdentity name, List<MappingExpr> argExprList) {
        this.skipSpaces();
        char ch = this.watch(1);
        switch (ch) {
            case ')': {
                if (left == null) {
                    return new MappingFilterInvoke(this.forestMethod, variableScope, name, argExprList);
                }
                return new MappingInvoke(this.forestMethod, variableScope, left, name, argExprList);
            }
            case ',': {
                this.nextChar();
                MappingExpr expr = this.parseExpression();
                argExprList.add(expr);
                return this.parseMethodParams_inner(variableScope, left, name, argExprList);
            }
        }
        MappingExpr expr2 = this.parseExpression();
        argExprList.add(expr2);
        return this.parseMethodParams_inner(variableScope, left, name, argExprList);
    }

    /*
     * Enabled aggressive block sorting
     */
    public MappingExpr parseLiteral() {
        char ch;
        block10: {
            ch = this.watch(1);
            if (Character.isDigit(ch)) {
                StringBuilder builder = new StringBuilder();
                do {
                    builder.append(ch);
                    this.nextChar();
                } while (Character.isDigit(ch = this.watch(1)));
                if (ch == '.') {
                    char ch2 = this.watch(2);
                    if (Character.isDigit(ch2)) {
                        builder.append('.');
                        this.nextChar();
                        do {
                            builder.append(ch);
                            this.nextChar();
                        } while (Character.isDigit(ch = this.watch(1)));
                        if (ch == 'f' || ch == 'F') {
                            this.nextChar();
                            return new MappingFloat(Float.parseFloat(builder.toString()));
                        }
                        if (ch != 'd' && ch != 'D') {
                            return new MappingFloat(Float.parseFloat(builder.toString()));
                        }
                        this.nextChar();
                        return new MappingDouble(Double.parseDouble(builder.toString()));
                    }
                    break block10;
                } else {
                    if (ch != 'l' && ch != 'L') {
                        return new MappingInteger(Integer.parseInt(builder.toString()));
                    }
                    return new MappingLong(Long.parseLong(builder.toString()));
                }
            }
            if (Character.isAlphabetic(ch) || ch == '_') {
                return this.parseTextToken();
            }
        }
        this.syntaxErrorWatch1(ch);
        return null;
    }

    protected String renderExpression(ForestJsonConverter jsonConverter, MappingExpr expr, Object[] args) {
        Object val = null;
        MappingParameter param = null;
        if (expr instanceof MappingString) {
            return ((MappingString)expr).getText();
        }
        if (expr instanceof MappingIndex) {
            try {
                Integer index = ((MappingIndex)expr).getIndex();
                param = this.parameters[index];
                val = args[index];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (val != null) {
                val = MappingTemplate.getParameterValue(jsonConverter, val);
                if (param != null && param.isUrlEncode()) {
                    val = URLUtils.queryValueEncode(String.valueOf(val), param.getCharset());
                }
                return String.valueOf(val);
            }
        } else {
            val = expr.render(args);
            if (val != null) {
                val = MappingTemplate.getParameterValue(jsonConverter, val);
                if (param != null && param.isUrlEncode()) {
                    val = URLUtils.pathEncode(String.valueOf(val), param.getCharset());
                }
            }
            return String.valueOf(val);
        }
        return null;
    }

    public String render(Object[] args) {
        try {
            ForestJsonConverter jsonConverter = this.variableScope.getConfiguration().getJsonConverter();
            int len = this.exprList.size();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                MappingExpr expr = this.exprList.get(i);
                String val = this.renderExpression(jsonConverter, expr, args);
                if (val == null) continue;
                builder.append(val);
            }
            return builder.toString();
        }
        catch (ForestVariableUndefinedException ex) {
            throw new ForestVariableUndefinedException(this.annotationType, this.attributeName, this.forestMethod, ex.getVariableName(), this.template);
        }
    }

    public static String getParameterValue(ForestJsonConverter jsonConverter, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map || obj instanceof Collection) {
            return jsonConverter.encodeToString(obj);
        }
        if (obj instanceof Date) {
            return String.valueOf(((Date)obj).getTime());
        }
        return obj.toString();
    }

    private static String getFormCollectionValueString(Collection collection) {
        if (collection.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            builder.append(item);
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private static String getFormArrayValueString(Object array) {
        StringBuilder builder = new StringBuilder();
        int len = Array.getLength(array);
        if (len == 0) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            Object item = Array.get(array, i);
            builder.append(item);
            if (i >= len - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static String getFormValueString(ForestJsonConverter jsonConverter, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            return MappingTemplate.getFormCollectionValueString(collection);
        }
        if (obj.getClass().isArray()) {
            return MappingTemplate.getFormArrayValueString(obj);
        }
        if (obj instanceof Map) {
            return jsonConverter.encodeToString(obj);
        }
        if (obj instanceof Date) {
            return String.valueOf(((Date)obj).getTime());
        }
        return obj.toString();
    }

    public MappingTemplate clone() {
        MappingTemplate template = new MappingTemplate(this.annotationType, this.attributeName, this.forestMethod, this.template, this.variableScope, this.properties, this.parameters);
        template.exprList = this.exprList;
        return template;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (MappingExpr expr : this.exprList) {
            buff.append(expr.toString());
        }
        return buff.toString();
    }

    public MappingTemplate valueOf(String value) {
        return new MappingTemplate(this.annotationType, this.attributeName, this.forestMethod, value, this.forestMethod, this.properties, this.forestMethod.getParameters());
    }
}

