/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.mapping;

import com.dtflys.forest.config.ForestProperties;
import com.dtflys.forest.config.VariableScope;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.exceptions.ForestVariableUndefinedException;
import com.dtflys.forest.http.ForestQueryMap;
import com.dtflys.forest.http.ForestURL;
import com.dtflys.forest.http.ForestURLBuilder;
import com.dtflys.forest.http.SimpleQueryParameter;
import com.dtflys.forest.mapping.MappingExpr;
import com.dtflys.forest.mapping.MappingParameter;
import com.dtflys.forest.mapping.MappingTemplate;
import com.dtflys.forest.mapping.MappingUrlEncodedExpr;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.utils.StringUtils;
import java.lang.annotation.Annotation;

public class MappingURLTemplate
extends MappingTemplate {
    public MappingURLTemplate(Class<? extends Annotation> annotationType, String attributeName, ForestMethod<?> forestMethod, String template, VariableScope variableScope, ForestProperties properties, MappingParameter[] parameters) {
        super(annotationType, attributeName, forestMethod, template, variableScope, properties, parameters);
    }

    @Override
    public String render(Object[] args) {
        return super.render(args);
    }

    public ForestURL render(Object[] args, ForestQueryMap queries) {
        String scheme = null;
        StringBuilder userInfo = null;
        String host = null;
        Integer port = null;
        StringBuilder path = null;
        String ref = null;
        StringBuilder urlBuilder = new StringBuilder();
        boolean renderedQuery = false;
        boolean nextIsPort = false;
        boolean renderedPath = false;
        try {
            String[] group;
            ForestJsonConverter jsonConverter = this.variableScope.getConfiguration().getJsonConverter();
            int len = this.exprList.size();
            StringBuilder builder = new StringBuilder();
            SimpleQueryParameter lastQuery = null;
            for (int i = 0; i < len; ++i) {
                String queryStr;
                String[] queryItems;
                MappingExpr expr = (MappingExpr)this.exprList.get(i);
                String exprVal = String.valueOf(this.renderExpression(jsonConverter, expr, args));
                builder.append(exprVal);
                if (renderedQuery) {
                    String queryVal;
                    if (lastQuery != null && expr instanceof MappingUrlEncodedExpr) {
                        Object lastQueryValue = lastQuery.getValue();
                        String queryVal2 = lastQueryValue == null ? exprVal : lastQueryValue + exprVal;
                        lastQuery.setValue(queryVal2);
                        continue;
                    }
                    String[] subQueries = exprVal.split("&");
                    int subQueryLen = subQueries.length;
                    int k = 1;
                    if (exprVal.charAt(0) != '&') {
                        String lastQueryPartVal = subQueries[0];
                        if (lastQuery != null) {
                            Object lastQueryValue = lastQuery.getValue();
                            queryVal = lastQueryValue == null ? lastQueryPartVal : lastQueryValue + lastQueryPartVal;
                            lastQuery.setValue(queryVal);
                        } else {
                            String[] keyValue = lastQueryPartVal.split("=", 2);
                            lastQuery = keyValue.length == 1 ? new SimpleQueryParameter(lastQueryPartVal) : new SimpleQueryParameter(keyValue[0], keyValue[1]);
                            queries.addQuery(lastQuery);
                        }
                    }
                    while (k < subQueryLen) {
                        String queryItem = subQueries[k];
                        String[] keyValue = queryItem.split("=", 2);
                        if (keyValue.length == 1) {
                            lastQuery = new SimpleQueryParameter(queryItem);
                        } else {
                            lastQuery = new SimpleQueryParameter(keyValue[0]);
                            queryVal = keyValue[1];
                            if (StringUtils.isNotBlank(queryVal)) {
                                lastQuery.setValue(queryVal);
                            }
                        }
                        queries.addQuery(lastQuery);
                        ++k;
                    }
                    continue;
                }
                int refIndex = exprVal.indexOf(35);
                int queryIndex = exprVal.indexOf(63);
                renderedQuery = ref == null && queryIndex >= 0 && (queryIndex < refIndex || refIndex < 0);
                String baseUrl = exprVal;
                if (renderedQuery) {
                    baseUrl = exprVal.substring(0, queryIndex);
                } else if (host != null && !nextIsPort && port == null && path == null) {
                    baseUrl = host + baseUrl;
                    host = null;
                    urlBuilder = new StringBuilder(scheme).append("//");
                }
                urlBuilder.append(baseUrl);
                char[] baseUrlChars = baseUrl.toCharArray();
                int baseLen = baseUrlChars.length;
                StringBuilder subBuilder = new StringBuilder();
                for (int pathCharIndex = 0; pathCharIndex < baseLen; ++pathCharIndex) {
                    char ch = baseUrlChars[pathCharIndex];
                    if (!renderedPath && ch == ':') {
                        if (scheme == null && pathCharIndex + 1 < baseLen && baseUrlChars[pathCharIndex + 1] == '/') {
                            scheme = subBuilder.toString();
                            subBuilder = new StringBuilder();
                            if ((ch = baseUrlChars[++pathCharIndex]) != '/') {
                                throw new ForestRuntimeException("URI '" + super.render(args) + "' is invalid.");
                            }
                            if (++pathCharIndex + 1 >= baseLen || baseUrlChars[pathCharIndex + 1] != '/') continue;
                            while (++pathCharIndex + 1 < baseLen && baseUrlChars[pathCharIndex + 1] == '/') {
                            }
                            continue;
                        }
                        if (scheme != null && host == null) {
                            boolean hasNext;
                            boolean bl = hasNext = pathCharIndex + 1 < baseLen;
                            if (!hasNext || hasNext && Character.isDigit(baseUrlChars[pathCharIndex + 1])) {
                                host = subBuilder.toString();
                                subBuilder = new StringBuilder();
                                nextIsPort = true;
                                continue;
                            }
                            if (!hasNext || Character.isDigit(baseUrlChars[pathCharIndex + 1])) continue;
                            if (userInfo == null) {
                                userInfo = new StringBuilder(subBuilder.toString() + ':');
                            } else {
                                userInfo.append((CharSequence)subBuilder).append(':');
                            }
                            subBuilder = new StringBuilder();
                            continue;
                        }
                        if (host != null && port == null) {
                            nextIsPort = true;
                            continue;
                        }
                        subBuilder.append(ch);
                        continue;
                    }
                    if (!renderedPath && ch == '@') {
                        if (userInfo == null) {
                            if (host != null) {
                                userInfo = new StringBuilder(host);
                                host = null;
                            } else {
                                userInfo = new StringBuilder();
                            }
                        }
                        if (nextIsPort) {
                            userInfo.append(':');
                        }
                        userInfo.append(subBuilder.toString());
                        subBuilder = new StringBuilder();
                        continue;
                    }
                    if (ch == '/' || pathCharIndex + 1 == baseLen) {
                        if (ch != '/') {
                            subBuilder.append(ch);
                        }
                        if (!renderedPath && nextIsPort && port == null) {
                            port = Integer.parseInt(subBuilder.toString());
                            subBuilder = new StringBuilder();
                            nextIsPort = false;
                            if (ch != '/') continue;
                            --pathCharIndex;
                            renderedPath = true;
                            continue;
                        }
                        if (scheme != null && host == null) {
                            host = subBuilder.toString();
                            subBuilder = new StringBuilder();
                            if (ch != '/') continue;
                            --pathCharIndex;
                            renderedPath = true;
                            continue;
                        }
                        if (ch == '/') {
                            subBuilder.append(ch);
                            renderedPath = true;
                        }
                        if (!renderedPath) continue;
                        if (path == null) {
                            path = new StringBuilder(subBuilder.toString());
                        } else {
                            path.append(subBuilder.toString());
                        }
                        subBuilder = new StringBuilder();
                        continue;
                    }
                    subBuilder.append(ch);
                }
                if (refIndex > queryIndex) {
                    String[] group2 = exprVal.split("#", 2);
                    exprVal = group2[0];
                    ref = group2[1];
                }
                if (!renderedQuery || queryIndex + 1 >= exprVal.length() || (queryItems = (queryStr = exprVal.substring(queryIndex + 1)).split("&")).length <= 0) continue;
                for (String queryItem : queryItems) {
                    String[] keyValue = queryItem.split("=", 2);
                    lastQuery = new SimpleQueryParameter(keyValue[0]);
                    queries.addQuery(lastQuery);
                    if (keyValue.length <= 1 || !StringUtils.isNotBlank(keyValue[1])) continue;
                    lastQuery.setValue(keyValue[1]);
                }
            }
            if (host == null && StringUtils.isEmpty(path) && StringUtils.isNotEmpty(urlBuilder)) {
                if (path == null) {
                    path = new StringBuilder();
                }
                path.append((CharSequence)builder);
            }
            if (StringUtils.isNotEmpty(path) && (group = path.toString().split("#", 2)).length > 1) {
                path = new StringBuilder();
                path.append(group[0]);
                ref = group[1];
            }
            return new ForestURLBuilder().setScheme(scheme).setUserInfo(userInfo != null ? userInfo.toString() : null).setHost(host).setPort(port != null ? port : (host != null ? Integer.valueOf(-1) : null)).setPath(path != null ? path.toString() : null).setRef(ref).build();
        }
        catch (ForestVariableUndefinedException ex) {
            throw new ForestVariableUndefinedException(this.annotationType, this.attributeName, this.forestMethod, ex.getVariableName(), this.template);
        }
    }

    public ForestURL getURL() {
        return null;
    }
}

