/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.multipart;

import com.dtflys.forest.exceptions.ForestFileNotFoundException;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.multipart.ForestMultipart;
import com.dtflys.forest.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FilePathMultipart
extends ForestMultipart<String, FilePathMultipart> {
    private String filePath;
    private Path path;
    private File file;

    @Override
    public String getOriginalFileName() {
        if (StringUtils.isNotBlank(this.fileName)) {
            return this.fileName;
        }
        String[] strs = this.filePath.split("(/|\\\\)");
        return strs[strs.length - 1];
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public FilePathMultipart setData(String data) {
        this.filePath = data;
        this.path = Paths.get(data, new String[0]).normalize();
        return this;
    }

    @Override
    public long getSize() {
        try {
            return Files.size(this.path);
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
    }

    @Override
    public InputStream getInputStream() {
        File file = this.getFile();
        if (!file.exists()) {
            throw new ForestFileNotFoundException(this.filePath);
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ForestRuntimeException(e);
        }
    }

    @Override
    public boolean isFile() {
        return true;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public File getFile() {
        if (this.file != null) {
            return this.file;
        }
        this.file = this.path.toFile();
        return this.file;
    }
}

