/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.pool;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.exceptions.ForestAbortException;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestRoute;
import com.dtflys.forest.pool.ForestRequestPool;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class FixedRequestPool
implements ForestRequestPool {
    private volatile Integer maxPoolSize;
    private volatile Integer maxPoolSizePerRoute;
    private volatile Integer maxQueueSize;
    private AtomicInteger runningPoolSize = new AtomicInteger(0);
    private Queue<ForestRequest> queue;

    public FixedRequestPool(ForestConfiguration configuration) {
        this.maxPoolSize = configuration.getMaxConnections();
        if (this.maxPoolSize == null) {
            this.maxPoolSize = 128;
        }
        this.maxPoolSizePerRoute = configuration.getMaxRouteConnections();
        if (this.maxPoolSizePerRoute == null) {
            this.maxPoolSizePerRoute = 128;
        }
        this.maxQueueSize = configuration.getMaxRequestQueueSize();
        if (this.maxQueueSize == null) {
            this.maxQueueSize = 32;
        }
        this.queue = this.maxQueueSize == 0 ? new SynchronousQueue<ForestRequest>() : new LinkedBlockingDeque<ForestRequest>(this.maxQueueSize);
    }

    @Override
    public synchronized void awaitRequest(ForestRequest request) {
        ForestRoute route = request.route();
        if (this.runningPoolSize.get() < this.maxPoolSize && route.getRequestCount().get() < this.maxPoolSizePerRoute) {
            this.runningPoolSize.incrementAndGet();
            route.getRequestCount().incrementAndGet();
            return;
        }
        boolean queued = false;
        try {
            this.queue.add(request);
            queued = true;
        }
        catch (Throwable th) {
            throw new ForestAbortException(request, this);
        }
        finally {
            if (!queued) {
                this.notifyAll();
            }
        }
        while (this.runningPoolSize.get() >= this.maxPoolSize || route.getRequestCount().get() >= this.maxPoolSizePerRoute) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                throw new ForestRuntimeException(e);
            }
        }
        this.queue.remove(request);
        this.runningPoolSize.incrementAndGet();
        route.getRequestCount().incrementAndGet();
    }

    @Override
    public synchronized void finish(ForestRequest request) {
        this.runningPoolSize.decrementAndGet();
        request.route().getRequestCount().decrementAndGet();
        this.notifyAll();
    }

    @Override
    public Integer getRunningPoolSize() {
        return this.runningPoolSize.get();
    }

    @Override
    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public Integer getMaxPoolSizePerRoute() {
        return this.maxPoolSizePerRoute;
    }

    @Override
    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    @Override
    public Integer getQueueSize() {
        return this.queue.size();
    }
}

