/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.reflection;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.reflection.ForestObjectFactory;
import com.dtflys.forest.reflection.ObjectConstructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultObjectFactory
implements ForestObjectFactory {
    private final Map<Class<?>, Object> forestObjectCache = new ConcurrentHashMap();
    private Map<Class<?>, ObjectConstructor> constructorMap = new ConcurrentHashMap();

    protected <T> T getObjectFromCache(Class<T> clazz) {
        return (T)this.forestObjectCache.get(clazz);
    }

    @Override
    public <T> T getObject(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        T obj = this.getObjectFromCache(clazz);
        if (obj != null) {
            return obj;
        }
        ObjectConstructor constructor = this.constructorMap.get(clazz);
        if (constructor != null && (obj = constructor.construct()) != null) {
            this.forestObjectCache.put(clazz, obj);
            return obj;
        }
        try {
            if (!clazz.isInterface()) {
                obj = clazz.newInstance();
                this.forestObjectCache.put(clazz, obj);
                return obj;
            }
        }
        catch (InstantiationException e) {
            throw new ForestRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new ForestRuntimeException(e);
        }
        return null;
    }

    @Override
    public void registerConstructor(Class<?> cls, ObjectConstructor constructor) {
        this.constructorMap.put(cls, constructor);
    }

    @Override
    public void registerObject(Class<?> cls, Object o) {
        this.forestObjectCache.put(cls, o);
    }
}

