/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.reflection;

import com.dtflys.forest.annotation.BaseLifeCycle;
import com.dtflys.forest.annotation.BaseRequest;
import com.dtflys.forest.annotation.MethodLifeCycle;
import com.dtflys.forest.annotation.ParamLifeCycle;
import com.dtflys.forest.annotation.RequestAttributes;
import com.dtflys.forest.callback.AddressSource;
import com.dtflys.forest.callback.OnError;
import com.dtflys.forest.callback.OnLoadCookie;
import com.dtflys.forest.callback.OnProgress;
import com.dtflys.forest.callback.OnRedirection;
import com.dtflys.forest.callback.OnSaveCookie;
import com.dtflys.forest.callback.OnSuccess;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.config.VariableScope;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.converter.ForestEncoder;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestInterceptorDefineException;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.filter.Filter;
import com.dtflys.forest.http.ForestAddress;
import com.dtflys.forest.http.ForestQueryMap;
import com.dtflys.forest.http.ForestQueryParameter;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.ForestRequestType;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.http.ForestURL;
import com.dtflys.forest.http.SimpleQueryParameter;
import com.dtflys.forest.http.body.RequestBodyBuilder;
import com.dtflys.forest.http.body.StringRequestBody;
import com.dtflys.forest.interceptor.Interceptor;
import com.dtflys.forest.interceptor.InterceptorAttributes;
import com.dtflys.forest.interceptor.InterceptorFactory;
import com.dtflys.forest.lifecycles.BaseAnnotationLifeCycle;
import com.dtflys.forest.lifecycles.MethodAnnotationLifeCycle;
import com.dtflys.forest.lifecycles.ParameterAnnotationLifeCycle;
import com.dtflys.forest.lifecycles.method.RequestLifeCycle;
import com.dtflys.forest.logging.DefaultLogHandler;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.logging.LogConfiguration;
import com.dtflys.forest.mapping.MappingParameter;
import com.dtflys.forest.mapping.MappingTemplate;
import com.dtflys.forest.mapping.MappingURLTemplate;
import com.dtflys.forest.mapping.MappingVariable;
import com.dtflys.forest.mapping.SubVariableScope;
import com.dtflys.forest.multipart.ForestMultipart;
import com.dtflys.forest.multipart.ForestMultipartFactory;
import com.dtflys.forest.proxy.InterfaceProxyHandler;
import com.dtflys.forest.reflection.MetaRequest;
import com.dtflys.forest.reflection.MethodLifeCycleHandler;
import com.dtflys.forest.retryer.ForestRetryer;
import com.dtflys.forest.ssl.SSLKeyStore;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.NameUtils;
import com.dtflys.forest.utils.ReflectUtils;
import com.dtflys.forest.utils.RequestNameValue;
import com.dtflys.forest.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ForestMethod<T>
implements VariableScope {
    private static final ForestAddress DEFAULT_ADDRESS = new ForestAddress("http", "localhost", -1);
    private final InterfaceProxyHandler interfaceProxyHandler;
    private final ForestConfiguration configuration;
    private InterceptorFactory interceptorFactory;
    private final Method method;
    private String[] methodNameItems;
    private Class returnClass;
    private Type returnType;
    private MappingParameter returnTypeParameter;
    private MetaRequest metaRequest;
    private MappingURLTemplate baseUrlTemplate;
    private MappingURLTemplate urlTemplate;
    private MappingTemplate typeTemplate;
    private MappingTemplate dataTypeTemplate;
    private MappingTemplate bodyTypeTemplate;
    private Integer baseTimeout = null;
    private Integer baseConnectTimeout = null;
    private Integer baseReadTimeout = null;
    private Integer timeout = null;
    private Integer connectTimeout = null;
    private Integer readTimeout = null;
    private MappingTemplate sslProtocolTemplate;
    private Class baseRetryerClass = null;
    private Integer baseRetryCount = null;
    private Long baseMaxRetryInterval;
    private Integer retryCount = null;
    private long maxRetryInterval;
    private MappingTemplate baseEncodeTemplate = null;
    private MappingTemplate encodeTemplate = null;
    private MappingTemplate charsetTemplate = null;
    private MappingTemplate responseEncodingTemplate = null;
    private MappingTemplate baseContentTypeTemplate;
    private MappingTemplate baseUserAgentTemplate;
    private MappingTemplate baseCharsetTemplate;
    private MappingTemplate baseSslProtocolTemplate;
    private MappingTemplate contentTypeTemplate;
    private MappingTemplate userAgentTemplate;
    private long progressStep = -1L;
    private ForestEncoder encoder = null;
    private ForestConverter decoder = null;
    private MappingTemplate sslKeyStoreId;
    private MappingTemplate[] dataTemplateArray;
    private MappingTemplate[] headerTemplateArray;
    private MappingParameter[] parameterTemplateArray;
    private MappingParameter[] forestParameters;
    private List<MappingParameter> namedParameters = new ArrayList<MappingParameter>();
    private List<ForestMultipartFactory> multipartFactories = new ArrayList<ForestMultipartFactory>();
    private Map<String, MappingVariable> variables = new ConcurrentHashMap<String, MappingVariable>();
    private Map<String, MappingTemplate> templateCache = new ConcurrentHashMap<String, MappingTemplate>();
    private MappingParameter onSuccessParameter = null;
    private MappingParameter onErrorParameter = null;
    private MappingParameter onRedirectionParameter = null;
    private MappingParameter onProgressParameter = null;
    private MappingParameter onLoadCookieParameter = null;
    private MappingParameter onSaveCookieParameter = null;
    private List<Interceptor> globalInterceptorList;
    private List<Interceptor> baseInterceptorList;
    private List<Interceptor> interceptorList;
    private List<InterceptorAttributes> interceptorAttributesList;
    private Type onSuccessClassGenericType = null;
    private Class retryerClass = null;
    private boolean async = false;
    private LogConfiguration baseLogConfiguration = null;
    private boolean logEnabled = true;
    private boolean logRequest = true;
    private boolean logResponseStatus = true;
    private boolean logResponseContent = false;
    private ForestLogHandler logHandler = null;
    private LogConfiguration logConfiguration = null;
    private Map<String, Object> extensionParameters = new ConcurrentHashMap<String, Object>();

    public ForestMethod(InterfaceProxyHandler interfaceProxyHandler, ForestConfiguration configuration, Method method) {
        this.interfaceProxyHandler = interfaceProxyHandler;
        this.configuration = configuration;
        this.method = method;
        this.interceptorFactory = configuration.getInterceptorFactory();
        this.methodNameItems = NameUtils.splitCamelName(method.getName());
        this.forestParameters = new MappingParameter[method.getParameterCount()];
        this.processBaseProperties();
        this.processMethodAnnotations();
    }

    @Override
    public ForestConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isVariableDefined(String name) {
        return this.configuration.isVariableDefined(name);
    }

    @Override
    public Object getVariableValue(String name) {
        return this.getVariableValue(name, this);
    }

    @Override
    public Object getVariableValue(String name, ForestMethod method) {
        return this.configuration.getVariableValue(name, method);
    }

    public MappingTemplate makeTemplate(MappingParameter parameter) {
        return this.getOrCreateTemplate(null, null, parameter.getName());
    }

    public MappingTemplate makeTemplate(Class<? extends Annotation> annotationType, String attributeName, String text) {
        return this.getOrCreateTemplate(annotationType, attributeName, text);
    }

    public MappingURLTemplate makeURLTemplate(Class<? extends Annotation> annotationType, String attributeName, String text) {
        return new MappingURLTemplate(annotationType, attributeName, this, text, this, this.configuration.getProperties(), this.forestParameters);
    }

    private MappingTemplate getOrCreateTemplate(Class<? extends Annotation> annotationType, String attributeName, String text) {
        String key = (annotationType != null ? annotationType.getName() : "") + "@" + (attributeName != null ? attributeName : "") + "@" + text;
        MappingTemplate template = this.templateCache.get(key);
        if (template == null) {
            template = new MappingTemplate(annotationType, attributeName, this, text, this, this.configuration.getProperties(), this.forestParameters);
            if (this.templateCache.size() < 128) {
                this.templateCache.put(key, template);
            }
        }
        return template;
    }

    public Class getReturnClass() {
        return this.returnClass;
    }

    @Override
    public MappingVariable getVariable(String name) {
        return this.variables.get(name);
    }

    public MappingParameter[] getParameters() {
        return this.forestParameters;
    }

    private void processBaseProperties() {
        Class<?>[] baseInterceptorClasses;
        String baseSslProtocol;
        String baseCharset;
        String baseUserAgent;
        String baseContentType;
        String baseContentEncoding;
        MetaRequest baseMetaRequest = this.interfaceProxyHandler.getBaseMetaRequest();
        String baseUrl = baseMetaRequest.getUrl();
        if (StringUtils.isNotBlank(baseUrl)) {
            this.baseUrlTemplate = this.makeURLTemplate(BaseRequest.class, "baseUrl", baseUrl);
        }
        if (StringUtils.isNotBlank(baseContentEncoding = baseMetaRequest.getContentEncoding())) {
            this.baseEncodeTemplate = this.makeTemplate(BaseRequest.class, "contentEncoding", baseContentEncoding);
        }
        if (StringUtils.isNotBlank(baseContentType = baseMetaRequest.getContentType())) {
            this.baseContentTypeTemplate = this.makeTemplate(BaseRequest.class, "contentType", baseContentType);
        }
        if (StringUtils.isNotBlank(baseUserAgent = baseMetaRequest.getUserAgent())) {
            this.baseUserAgentTemplate = this.makeTemplate(BaseRequest.class, "userAgent", baseUserAgent);
        }
        if (StringUtils.isNotBlank(baseCharset = baseMetaRequest.getCharset())) {
            this.baseCharsetTemplate = this.makeTemplate(BaseRequest.class, "charset", baseCharset);
        }
        if (StringUtils.isNotBlank(baseSslProtocol = baseMetaRequest.getSslProtocol())) {
            this.baseSslProtocolTemplate = this.makeTemplate(BaseRequest.class, "sslProtocol", baseSslProtocol);
        }
        this.baseLogConfiguration = this.interfaceProxyHandler.getBaseLogConfiguration();
        this.baseTimeout = baseMetaRequest.getTimeout();
        this.baseConnectTimeout = baseMetaRequest.getConnectTimeout();
        this.baseReadTimeout = baseMetaRequest.getReadTimeout();
        this.baseRetryerClass = baseMetaRequest.getRetryer();
        this.baseRetryCount = baseMetaRequest.getRetryCount();
        this.baseMaxRetryInterval = baseMetaRequest.getMaxRetryInterval();
        List<Class<? extends Interceptor>> globalInterceptorClasses = this.configuration.getInterceptors();
        if (globalInterceptorClasses != null && globalInterceptorClasses.size() > 0) {
            this.globalInterceptorList = new LinkedList<Interceptor>();
            for (Class<? extends Interceptor> clazz : globalInterceptorClasses) {
                if (!Interceptor.class.isAssignableFrom(clazz) || clazz.isInterface()) {
                    throw new ForestRuntimeException("Class [" + clazz.getName() + "] is not a implement of [" + Interceptor.class.getName() + "] interface.");
                }
                Interceptor interceptor = this.interceptorFactory.getInterceptor(clazz);
                this.globalInterceptorList.add(interceptor);
            }
        }
        if ((baseInterceptorClasses = baseMetaRequest.getInterceptor()) != null && baseInterceptorClasses.length > 0) {
            this.baseInterceptorList = new LinkedList<Interceptor>();
            for (Class<?> clazz : baseInterceptorClasses) {
                if (!Interceptor.class.isAssignableFrom(clazz) || clazz.isInterface()) {
                    throw new ForestRuntimeException("Class [" + clazz.getName() + "] is not a implement of [" + Interceptor.class.getName() + "] interface.");
                }
                Object interceptor = this.interceptorFactory.getInterceptor(clazz);
                this.baseInterceptorList.add((Interceptor)interceptor);
            }
        }
    }

    private <T extends Interceptor> T addInterceptor(Class<T> interceptorClass) {
        if (this.interceptorList == null) {
            this.interceptorList = new LinkedList<Interceptor>();
        }
        if (!Interceptor.class.isAssignableFrom(interceptorClass) || interceptorClass.isInterface()) {
            throw new ForestRuntimeException("Class [" + interceptorClass.getName() + "] is not a implement of [" + Interceptor.class.getName() + "] interface.");
        }
        T interceptor = this.interceptorFactory.getInterceptor(interceptorClass);
        this.interceptorList.add((Interceptor)interceptor);
        return interceptor;
    }

    private Map<Annotation, Class<? extends Interceptor>> getAnnotationLifeCycleClassMap(Annotation annotation) {
        Annotation[] annArray;
        Class<? extends Annotation> annType = annotation.annotationType();
        String annName = annType.getPackage().getName();
        if (annName.startsWith("java.") || annName.startsWith("javax.") || annName.startsWith("kotlin")) {
            return null;
        }
        LinkedHashMap<Annotation, Class<? extends Interceptor>> resultMap = new LinkedHashMap<Annotation, Class<? extends Interceptor>>();
        for (Annotation ann : annArray = annType.getAnnotations()) {
            Map<Annotation, Class<Interceptor>> parentMap = this.getAnnotationLifeCycleClassMap(ann);
            if (parentMap == null || parentMap.isEmpty()) continue;
            resultMap.putAll(parentMap);
        }
        Class<Interceptor> lifeCycleClass = this.getAnnotationLifeCycleClass(annotation);
        if (lifeCycleClass != null) {
            resultMap.put(annotation, lifeCycleClass);
        }
        return resultMap;
    }

    private Class<? extends Interceptor> getAnnotationLifeCycleClass(Annotation annotation) {
        Class<? extends BaseAnnotationLifeCycle> baseAnnLifeCycleClass;
        BaseLifeCycle baseLifeCycle;
        Class<? extends Annotation> annType = annotation.annotationType();
        Class interceptorClass = null;
        MethodLifeCycle methodLifeCycleAnn = annType.getAnnotation(MethodLifeCycle.class);
        if (methodLifeCycleAnn == null && (baseLifeCycle = annType.getAnnotation(BaseLifeCycle.class)) != null && (baseAnnLifeCycleClass = baseLifeCycle.value()) != null) {
            if (MethodAnnotationLifeCycle.class.isAssignableFrom(baseAnnLifeCycleClass)) {
                interceptorClass = baseAnnLifeCycleClass;
            } else {
                return baseAnnLifeCycleClass;
            }
        }
        if (!(methodLifeCycleAnn == null && interceptorClass == null || interceptorClass != null || Interceptor.class.isAssignableFrom(interceptorClass = methodLifeCycleAnn.value()))) {
            throw new ForestInterceptorDefineException(interceptorClass);
        }
        return interceptorClass;
    }

    public void setExtensionParameterValue(String name, Object value) {
        this.extensionParameters.put(name, value);
    }

    public Object getExtensionParameterValue(String name) {
        return this.extensionParameters.get(name);
    }

    private void addMetaRequestAnnotations(List<ForestAnnotation> anns) {
        for (ForestAnnotation ann : anns) {
            this.addMetaRequestAnnotation(ann.getAnnotation(), ann.getInterceptor());
        }
    }

    private void addMetaRequestAnnotation(Annotation annotation, Class interceptorClass) {
        T interceptor;
        Class<? extends Annotation> annType = annotation.annotationType();
        RequestAttributes requestAttributesAnn = annType.getAnnotation(RequestAttributes.class);
        if (requestAttributesAnn != null) {
            Map<String, Object> attrTemplates = ReflectUtils.getAttributesFromAnnotation(annotation);
            for (String key : attrTemplates.keySet()) {
                Object value = attrTemplates.get(key);
                if (value instanceof CharSequence) {
                    MappingTemplate template = this.makeTemplate(annType, key, value.toString());
                    attrTemplates.put(key, template);
                    continue;
                }
                if (!String[].class.isAssignableFrom(value.getClass())) continue;
                String[] stringArray = (String[])value;
                int len = stringArray.length;
                MappingTemplate[] templates = new MappingTemplate[stringArray.length];
                for (int i = 0; i < len; ++i) {
                    MappingTemplate template;
                    String item = stringArray[i];
                    templates[i] = template = this.makeTemplate(annType, key, item);
                }
                attrTemplates.put(key, templates);
            }
            InterceptorAttributes attributes = new InterceptorAttributes(interceptorClass, attrTemplates);
            if (this.interceptorAttributesList == null) {
                this.interceptorAttributesList = new LinkedList<InterceptorAttributes>();
            }
            this.interceptorAttributesList.add(attributes);
        }
        if ((interceptor = this.addInterceptor(interceptorClass)) instanceof MethodAnnotationLifeCycle) {
            MethodAnnotationLifeCycle lifeCycle = (MethodAnnotationLifeCycle)interceptor;
            lifeCycle.onMethodInitialized(this, annotation);
        }
    }

    public void setMetaRequest(MetaRequest metaRequest) {
        if (metaRequest != null && this.metaRequest != null) {
            throw new ForestRuntimeException("[Forest] annotation \"" + metaRequest.getRequestAnnotation().annotationType().getName() + "\" can not be added on method \"" + this.method.getName() + "\", because a similar annotation \"" + metaRequest.getRequestAnnotation().annotationType().getName() + "\" has already been attached to this method.");
        }
        this.metaRequest = metaRequest;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public MetaRequest getMetaRequest() {
        return this.metaRequest;
    }

    private void fetchAnnotationsFromClasses(List<Annotation> annotationList, Class[] classes) {
        for (Class clazz : classes) {
            if (clazz == null || clazz == Object.class) continue;
            this.fetchAnnotationsFromClasses(annotationList, clazz.getInterfaces());
            for (Annotation ann : clazz.getAnnotations()) {
                annotationList.add(ann);
            }
        }
    }

    private void processMethodAnnotations() {
        LinkedList<Annotation> annotationList = new LinkedList<Annotation>();
        this.fetchAnnotationsFromClasses(annotationList, new Class[]{this.interfaceProxyHandler.getInterfaceClass()});
        for (Annotation ann : this.method.getAnnotations()) {
            annotationList.add(ann);
        }
        LinkedList<ForestAnnotation> requestAnns = new LinkedList<ForestAnnotation>();
        LinkedList<ForestAnnotation> methodAnns = new LinkedList<ForestAnnotation>();
        for (Annotation ann : annotationList) {
            Map<Annotation, Class<Interceptor>> lifeCycleClassMap;
            if (ann instanceof BaseRequest || (lifeCycleClassMap = this.getAnnotationLifeCycleClassMap(ann)) == null || lifeCycleClassMap.isEmpty()) continue;
            for (Map.Entry<Annotation, Class<Interceptor>> entry : lifeCycleClassMap.entrySet()) {
                Annotation subAnn = entry.getKey();
                Class<Interceptor> lifeCycleClass = entry.getValue();
                if (RequestLifeCycle.class.isAssignableFrom(lifeCycleClass)) {
                    requestAnns.add(new ForestAnnotation(subAnn, lifeCycleClass));
                    continue;
                }
                methodAnns.add(new ForestAnnotation(subAnn, lifeCycleClass));
            }
        }
        this.addMetaRequestAnnotations(requestAnns);
        this.addMetaRequestAnnotations(methodAnns);
        if (this.metaRequest != null) {
            this.processMetaRequest(this.metaRequest);
        }
        this.returnClass = this.method.getReturnType();
    }

    private void processMetaRequest(MetaRequest metaRequest) {
        int j;
        Integer rtnum;
        Integer rtout;
        Integer ctout;
        Class<?>[] paramTypes = this.method.getParameterTypes();
        Type[] genericParamTypes = this.method.getGenericParameterTypes();
        Annotation[][] paramAnns = this.method.getParameterAnnotations();
        Parameter[] parameters = this.method.getParameters();
        Class<? extends Annotation> reqAnnType = metaRequest.getRequestAnnotation().annotationType();
        this.parameterTemplateArray = new MappingParameter[paramTypes.length];
        this.processParameters(parameters, genericParamTypes, paramAnns);
        this.bodyTypeTemplate = this.makeTemplate(reqAnnType, "type", metaRequest.getBodyType());
        this.urlTemplate = this.makeURLTemplate(reqAnnType, "url", metaRequest.getUrl());
        this.typeTemplate = this.makeTemplate(reqAnnType, "type", metaRequest.getType());
        this.dataTypeTemplate = this.makeTemplate(reqAnnType, "dataType", metaRequest.getDataType());
        if (StringUtils.isNotEmpty(metaRequest.getContentType())) {
            this.contentTypeTemplate = this.makeTemplate(reqAnnType, "contentType", metaRequest.getContentType());
        }
        if (StringUtils.isNotEmpty(metaRequest.getUserAgent())) {
            this.userAgentTemplate = this.makeTemplate(reqAnnType, "userAgent", metaRequest.getUserAgent());
        }
        this.sslKeyStoreId = this.makeTemplate(reqAnnType, "keyStore", metaRequest.getKeyStore());
        if (StringUtils.isNotEmpty(metaRequest.getContentEncoding())) {
            this.encodeTemplate = this.makeTemplate(reqAnnType, "contentEncoding", metaRequest.getContentEncoding());
        }
        this.charsetTemplate = this.makeTemplate(reqAnnType, "charset", metaRequest.getCharset());
        if (metaRequest.getResponseEncoding() != null) {
            this.responseEncodingTemplate = this.makeTemplate(reqAnnType, "responseEncoding", metaRequest.getResponseEncoding());
        }
        this.sslProtocolTemplate = this.makeTemplate(reqAnnType, "sslProtocol", metaRequest.getSslProtocol());
        this.progressStep = metaRequest.getProgressStep();
        this.async = metaRequest.isAsync();
        this.retryerClass = metaRequest.getRetryer();
        Class<? extends ForestEncoder> encoderClass = metaRequest.getEncoder();
        Class<? extends ForestConverter> decoderClass = metaRequest.getDecoder();
        String[] dataArray = metaRequest.getData();
        String[] headerArray = metaRequest.getHeaders();
        Integer tout = metaRequest.getTimeout();
        if (tout != null && tout >= 0) {
            this.timeout = tout;
        }
        if ((ctout = metaRequest.getConnectTimeout()) != null && ctout >= 0) {
            this.connectTimeout = ctout;
        }
        if ((rtout = metaRequest.getReadTimeout()) != null && rtout >= 0) {
            this.readTimeout = rtout;
        }
        if ((rtnum = metaRequest.getRetryCount()) != null && rtnum >= 0) {
            this.retryCount = rtnum;
        }
        this.maxRetryInterval = metaRequest.getMaxRetryInterval();
        this.logEnabled = this.configuration.isLogEnabled();
        if (!this.logEnabled) {
            this.logEnabled = metaRequest.isLogEnabled();
        }
        this.logRequest = this.configuration.isLogRequest();
        this.logResponseStatus = this.configuration.isLogResponseStatus();
        this.logResponseContent = this.configuration.isLogResponseContent();
        LogConfiguration metaLogConfiguration = metaRequest.getLogConfiguration();
        if (metaLogConfiguration == null && this.baseLogConfiguration != null) {
            metaLogConfiguration = this.baseLogConfiguration;
        }
        if (metaLogConfiguration != null) {
            this.logEnabled = metaLogConfiguration.isLogEnabled();
            this.logRequest = metaLogConfiguration.isLogRequest();
            this.logResponseStatus = metaLogConfiguration.isLogResponseStatus();
            this.logResponseContent = metaLogConfiguration.isLogResponseContent();
            this.logHandler = metaLogConfiguration.getLogHandler();
            if (this.logHandler == null && this.baseLogConfiguration != null) {
                this.logHandler = this.baseLogConfiguration.getLogHandler();
            }
        }
        if (this.logHandler == null && this.configuration.getLogHandler() != null) {
            this.logHandler = this.configuration.getLogHandler();
        }
        if (this.logHandler == null) {
            this.logHandler = new DefaultLogHandler();
        }
        this.logConfiguration = new LogConfiguration();
        this.logConfiguration.setLogEnabled(this.logEnabled);
        this.logConfiguration.setLogRequest(this.logRequest);
        this.logConfiguration.setLogResponseStatus(this.logResponseStatus);
        this.logConfiguration.setLogResponseContent(this.logResponseContent);
        this.logConfiguration.setLogHandler(this.logHandler);
        this.dataTemplateArray = new MappingTemplate[dataArray.length];
        for (j = 0; j < dataArray.length; ++j) {
            MappingTemplate dataTemplate;
            String data = dataArray[j];
            this.dataTemplateArray[j] = dataTemplate = this.makeTemplate(reqAnnType, "data", data);
        }
        this.headerTemplateArray = new MappingTemplate[headerArray.length];
        for (j = 0; j < headerArray.length; ++j) {
            MappingTemplate headerTemplate;
            String header = headerArray[j];
            this.headerTemplateArray[j] = headerTemplate = this.makeTemplate(reqAnnType, "header", header);
        }
        Class<?>[] interceptorClasses = metaRequest.getInterceptor();
        if (interceptorClasses != null && interceptorClasses.length > 0) {
            for (Class<?> interceptorClass : interceptorClasses) {
                this.addInterceptor(interceptorClass);
            }
        }
        if (encoderClass != null && !encoderClass.isInterface() && ForestEncoder.class.isAssignableFrom(encoderClass)) {
            this.encoder = this.configuration.getForestObjectFactory().getObject(encoderClass);
        }
        if (decoderClass != null && !encoderClass.isInterface() && ForestConverter.class.isAssignableFrom(decoderClass)) {
            this.decoder = this.configuration.getForestObjectFactory().getObject(decoderClass);
        }
    }

    private void processParameters(Parameter[] parameters, Type[] genericParamTypes, Annotation[][] paramAnns) {
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            Class<?> paramType = param.getType();
            Annotation[] anns = paramAnns[i];
            MappingParameter parameter = new MappingParameter(paramType);
            parameter.setIndex(i);
            parameter.setName(param.getName());
            this.parameterTemplateArray[i] = parameter;
            if (OnSuccess.class.isAssignableFrom(paramType)) {
                this.onSuccessParameter = parameter;
                Type genType = genericParamTypes[i];
                this.onSuccessClassGenericType = ForestMethod.getGenericClassOrType(genType, 0);
            } else if (OnError.class.isAssignableFrom(paramType)) {
                this.onErrorParameter = parameter;
            } else if (OnRedirection.class.isAssignableFrom(paramType)) {
                this.onRedirectionParameter = parameter;
            } else if (OnProgress.class.isAssignableFrom(paramType)) {
                this.onProgressParameter = parameter;
            } else if (OnSaveCookie.class.isAssignableFrom(paramType)) {
                this.onSaveCookieParameter = parameter;
            } else if (OnLoadCookie.class.isAssignableFrom(paramType)) {
                this.onLoadCookieParameter = parameter;
            }
            this.processParameterAnnotation(parameter, anns);
        }
    }

    private void processParameterAnnotation(MappingParameter parameter, Annotation[] anns) {
        for (int i = 0; i < anns.length; ++i) {
            ParamLifeCycle paramLifeCycleAnn;
            Annotation ann = anns[i];
            Class<? extends Annotation> annType = ann.annotationType();
            if (annType.getPackage().getName().startsWith("java.")) continue;
            Annotation[] subAnnArray = annType.getAnnotations();
            if (subAnnArray.length > 0) {
                this.processParameterAnnotation(parameter, subAnnArray);
            }
            if ((paramLifeCycleAnn = annType.getAnnotation(ParamLifeCycle.class)) == null) continue;
            Class<? extends ParameterAnnotationLifeCycle> interceptorClass = paramLifeCycleAnn.value();
            if (!Interceptor.class.isAssignableFrom(interceptorClass)) {
                throw new ForestInterceptorDefineException(interceptorClass);
            }
            ParameterAnnotationLifeCycle lifeCycle = this.addInterceptor(interceptorClass);
            lifeCycle.onParameterInitialized(this, parameter, ann);
        }
    }

    public void addNamedParameter(MappingParameter parameter) {
        Integer index = parameter.getIndex();
        if (index != null && this.forestParameters[index] != null) {
            return;
        }
        this.namedParameters.add(parameter);
        if (index != null) {
            this.forestParameters[index.intValue()] = parameter;
        }
    }

    public void addVariable(String name, MappingVariable variable) {
        this.variables.put(name, variable);
    }

    public void addMultipartFactory(ForestMultipartFactory multipartFactory) {
        this.multipartFactories.add(multipartFactory);
    }

    public void processParameterFilter(MappingParameter parameter, String filterName) {
        if (StringUtils.isNotEmpty(filterName)) {
            String[] filterNameArray;
            for (String name : filterNameArray = filterName.split(",")) {
                Filter filter = this.configuration.newFilterInstance(name);
                parameter.addFilter(filter);
            }
        }
    }

    private ForestRequestType type(Object[] args) {
        String renderedType = this.typeTemplate.render(args);
        if (StringUtils.isBlank(renderedType)) {
            String typeFromName = this.methodNameItems[0];
            ForestRequestType type = ForestRequestType.findType(typeFromName);
            if (type != null) {
                return type;
            }
            return ForestRequestType.GET;
        }
        ForestRequestType type = ForestRequestType.findType(renderedType);
        if (type != null) {
            return type;
        }
        throw new ForestRuntimeException("Http request type \"" + renderedType + "\" is not be supported.");
    }

    private ForestRequest makeRequest(Object[] args) {
        String dataType;
        int i;
        MetaRequest baseMetaRequest = this.interfaceProxyHandler.getBaseMetaRequest();
        ForestURL baseURL = null;
        ForestQueryMap queries = new ForestQueryMap();
        if (this.baseUrlTemplate != null) {
            baseURL = this.baseUrlTemplate.render(args, queries);
        }
        if (this.urlTemplate == null) {
            throw new ForestRuntimeException("request URL is empty");
        }
        ForestURL renderedURL = this.urlTemplate.render(args, queries);
        ForestRequestType type = this.type(args);
        String baseContentEncoding = null;
        if (this.baseEncodeTemplate != null) {
            baseContentEncoding = this.baseEncodeTemplate.render(args);
        }
        String contentEncoding = null;
        if (this.encodeTemplate != null) {
            contentEncoding = this.encodeTemplate.render(args);
        }
        String baseContentType = null;
        if (this.baseContentTypeTemplate != null) {
            baseContentType = this.baseContentTypeTemplate.render(args);
        }
        String baseUserAgent = null;
        if (this.baseUserAgentTemplate != null) {
            baseUserAgent = this.baseUserAgentTemplate.render(args);
        }
        String charset = null;
        String renderedCharset = this.charsetTemplate.render(args);
        if (StringUtils.isNotBlank(renderedCharset)) {
            charset = renderedCharset;
        } else if (this.baseCharsetTemplate != null) {
            charset = this.baseCharsetTemplate.render(args);
        }
        String responseEncoding = null;
        if (this.responseEncodingTemplate != null) {
            responseEncoding = this.responseEncodingTemplate.render(args);
        }
        String sslProtocol = null;
        String renderedSslProtocol = this.sslProtocolTemplate.render(args);
        sslProtocol = StringUtils.isNotBlank(renderedSslProtocol) && !"null".equals(renderedSslProtocol) ? renderedSslProtocol : (this.baseSslProtocolTemplate != null ? this.baseSslProtocolTemplate.render(args) : this.configuration.getSslProtocol());
        String renderedContentType = null;
        if (this.contentTypeTemplate != null) {
            renderedContentType = this.contentTypeTemplate.render(args).trim();
        }
        String renderedUserAgent = null;
        if (this.userAgentTemplate != null) {
            renderedUserAgent = this.userAgentTemplate.render(args).trim();
        }
        ArrayList<RequestNameValue> nameValueList = new ArrayList<RequestNameValue>();
        String[] headerArray = baseMetaRequest.getHeaders();
        MappingTemplate[] baseHeaders = null;
        if (headerArray != null && headerArray.length > 0) {
            baseHeaders = new MappingTemplate[headerArray.length];
            for (int j = 0; j < baseHeaders.length; ++j) {
                MappingTemplate header;
                baseHeaders[j] = header = new MappingTemplate(BaseRequest.class, "headers", this, headerArray[j], this, this.configuration.getProperties(), this.forestParameters);
            }
        }
        AddressSource addressSource = this.configuration.getBaseAddressSource();
        ForestAddress address = this.configuration.getBaseAddress();
        if (baseURL != null) {
            renderedURL.setBaseURL(baseURL);
            if (address == null) {
                address = DEFAULT_ADDRESS;
            }
        }
        if (address != null) {
            renderedURL.setAddress(address, false);
        }
        boolean autoRedirection = this.configuration.isAutoRedirection();
        String bodyTypeName = "text";
        if (this.bodyTypeTemplate != null) {
            bodyTypeName = this.bodyTypeTemplate.render(args);
        }
        ForestDataType bodyType = ForestDataType.findByName(bodyTypeName);
        ForestRequest request = new ForestRequest(this.configuration, this, args);
        request.url(renderedURL).type(type).bodyType(bodyType).addAllQuery(queries).charset(charset).autoRedirects(autoRedirection).setSslProtocol(sslProtocol).setLogConfiguration(this.logConfiguration).setAsyncMode(this.configuration.getAsyncMode()).setAsync(this.async);
        if (addressSource != null) {
            address = addressSource.getAddress(request);
            request.address(address);
        }
        if (StringUtils.isNotEmpty(responseEncoding)) {
            request.setResponseEncode(responseEncoding);
        }
        if (StringUtils.isNotEmpty(renderedContentType)) {
            request.setContentType(renderedContentType);
        }
        if (StringUtils.isNotEmpty(contentEncoding)) {
            request.setContentEncoding(contentEncoding);
        }
        if (StringUtils.isNotEmpty(renderedUserAgent)) {
            request.setUserAgent(renderedUserAgent);
        }
        for (int i2 = 0; i2 < this.namedParameters.size(); ++i2) {
            String name;
            SubVariableScope scope;
            VariableScope parentScope;
            int target;
            MappingParameter parameter = this.namedParameters.get(i2);
            if (parameter.isObjectProperties()) {
                Object body;
                target = parameter.isUnknownTarget() ? type.getDefaultParamTarget() : parameter.getTarget();
                Object obj = args[parameter.getIndex()];
                if (obj == null && StringUtils.isNotEmpty(parameter.getDefaultValue())) {
                    obj = parameter.getConvertedDefaultValue(this.configuration.getJsonConverter());
                }
                if (parameter.isJsonParam()) {
                    String json = "";
                    if (obj != null) {
                        ForestJsonConverter jsonConverter = this.configuration.getJsonConverter();
                        obj = parameter.getFilterChain().doFilter(this.configuration, obj);
                        json = jsonConverter.encodeToString(obj);
                    }
                    if (MappingParameter.isHeader(target)) {
                        request.addHeader(new RequestNameValue(parameter.getJsonParamName(), json, target).setDefaultValue(parameter.getDefaultValue()));
                        continue;
                    }
                    nameValueList.add(new RequestNameValue(parameter.getJsonParamName(), json, target, parameter.getPartContentType()).setDefaultValue(parameter.getDefaultValue()));
                    continue;
                }
                if (!parameter.getFilterChain().isEmpty()) {
                    obj = parameter.getFilterChain().doFilter(this.configuration, obj);
                    if (obj == null && StringUtils.isNotEmpty(parameter.getDefaultValue())) {
                        obj = parameter.getDefaultValue();
                    }
                    if (obj == null) continue;
                    if (MappingParameter.isHeader(target)) {
                        request.addHeader(new RequestNameValue(null, obj, target));
                        continue;
                    }
                    if (MappingParameter.isQuery(target)) {
                        request.addQuery(obj.toString(), (Object)null, parameter.isUrlEncode(), parameter.getCharset());
                        continue;
                    }
                    if (MappingParameter.isBody(target)) {
                        body = RequestBodyBuilder.type(obj.getClass()).build(obj, parameter.getDefaultValue());
                        request.addBody((ForestRequestBody)body);
                        continue;
                    }
                    nameValueList.add(new RequestNameValue(obj.toString(), target, parameter.getPartContentType()).setDefaultValue(parameter.getDefaultValue()));
                    continue;
                }
                if (obj instanceof CharSequence) {
                    if (MappingParameter.isQuery(target)) {
                        request.addQuery((SimpleQueryParameter)ForestQueryParameter.createSimpleQueryParameter(obj).setDefaultValue(parameter.getDefaultValue()));
                        continue;
                    }
                    if (!MappingParameter.isBody(target)) continue;
                    request.addBody(new StringRequestBody(obj.toString()).setDefaultValue(parameter.getDefaultValue()));
                    continue;
                }
                if (obj instanceof Map) {
                    Map map = (Map)obj;
                    if (MappingParameter.isQuery(target)) {
                        request.addQuery(map, parameter.isUrlEncode(), parameter.getCharset());
                        continue;
                    }
                    if (MappingParameter.isBody(target)) {
                        request.addBody(map, parameter.getPartContentType());
                        continue;
                    }
                    if (!MappingParameter.isHeader(target)) continue;
                    request.addHeader(map);
                    continue;
                }
                if (obj instanceof Iterable || obj != null && (obj.getClass().isArray() || ReflectUtils.isPrimaryType(obj.getClass()))) {
                    if (MappingParameter.isQuery(target)) {
                        if (parameter.isJsonParam()) {
                            request.addQuery(parameter.getName(), obj, parameter.isUrlEncode(), parameter.getCharset());
                            continue;
                        }
                        if (obj instanceof Iterable) {
                            for (Object subItem : (Iterable)obj) {
                                if (subItem instanceof SimpleQueryParameter) {
                                    request.addQuery((SimpleQueryParameter)subItem);
                                    continue;
                                }
                                request.addQuery(ForestQueryParameter.createSimpleQueryParameter(subItem));
                            }
                            continue;
                        }
                        if (!obj.getClass().isArray() || !(obj instanceof SimpleQueryParameter[])) continue;
                        request.addQuery((SimpleQueryParameter[])obj);
                        continue;
                    }
                    if (!MappingParameter.isBody(target)) continue;
                    body = RequestBodyBuilder.type(obj.getClass()).build(obj, parameter.getDefaultValue());
                    request.addBody((ForestRequestBody)body);
                    continue;
                }
                if (MappingParameter.isBody(target)) {
                    body = RequestBodyBuilder.type(obj.getClass()).build(obj, parameter.getDefaultValue());
                    request.addBody((ForestRequestBody)body);
                    continue;
                }
                try {
                    List<RequestNameValue> list = this.getNameValueListFromObjectWithJSON(parameter, this.configuration, obj, type);
                    if (list == null) continue;
                    for (RequestNameValue nameValue : list) {
                        if (nameValue.isInHeader()) {
                            request.addHeader(nameValue);
                            continue;
                        }
                        nameValueList.add(nameValue);
                    }
                    continue;
                }
                catch (Throwable th) {
                    throw new ForestRuntimeException(th);
                }
            }
            if (parameter.getIndex() == null) continue;
            target = parameter.isUnknownTarget() ? type.getDefaultParamTarget() : parameter.getTarget();
            RequestNameValue nameValue = new RequestNameValue(parameter.getName(), target, parameter.getPartContentType()).setDefaultValue(parameter.getDefaultValue());
            Object obj = args[parameter.getIndex()];
            if (obj == null && StringUtils.isNotEmpty(nameValue.getDefaultValue())) {
                obj = parameter.getConvertedDefaultValue(this.configuration.getJsonConverter());
            }
            if (obj == null) continue;
            if (MappingParameter.isQuery(target) && obj.getClass().isArray() && !(obj instanceof byte[]) && !(obj instanceof Byte[])) {
                int len = Array.getLength(obj);
                for (int idx = 0; idx < len; ++idx) {
                    Object arrayItem = Array.get(obj, idx);
                    SimpleQueryParameter queryParameter = new SimpleQueryParameter(parameter.getName(), arrayItem, parameter.isUrlEncode(), parameter.getCharset());
                    request.addQuery(queryParameter);
                }
                continue;
            }
            nameValue.setValue(obj);
            if (MappingParameter.isHeader(target)) {
                request.addHeader(nameValue);
                continue;
            }
            if (MappingParameter.isQuery(target)) {
                if (!parameter.isJsonParam() && obj instanceof Iterable) {
                    int index = 0;
                    MappingTemplate template = this.makeTemplate(parameter);
                    parentScope = template.getVariableScope();
                    for (Object subItem : (Iterable)obj) {
                        scope = new SubVariableScope(parentScope);
                        scope.addVariableValue("_it", subItem);
                        scope.addVariableValue("_index", index++);
                        template.setVariableScope(scope);
                        name = template.render(args);
                        request.addQuery(name, subItem, parameter.isUrlEncode(), parameter.getCharset());
                    }
                    continue;
                }
                if (parameter.isJsonParam()) {
                    request.addJSONQuery(parameter.getName(), obj);
                    continue;
                }
                request.addQuery(parameter.getName(), obj, parameter.isUrlEncode(), parameter.getCharset());
                continue;
            }
            MappingTemplate template = this.makeTemplate(parameter);
            if (obj instanceof Iterable && template.hasIterateVariable()) {
                int index = 0;
                parentScope = template.getVariableScope();
                for (Object subItem : (Iterable)obj) {
                    scope = new SubVariableScope(parentScope);
                    template.setVariableScope(scope);
                    scope.addVariableValue("_it", subItem);
                    scope.addVariableValue("_index", index++);
                    name = template.render(args);
                    nameValueList.add(new RequestNameValue(name, subItem, target, parameter.getPartContentType()).setDefaultValue(parameter.getDefaultValue()));
                }
                continue;
            }
            nameValueList.add(nameValue);
        }
        if (request.getContentType() == null && StringUtils.isNotEmpty(baseContentType)) {
            request.setContentType(baseContentType);
        }
        if (request.getContentEncoding() == null && StringUtils.isNotEmpty(baseContentEncoding)) {
            request.setContentEncoding(baseContentEncoding);
        }
        if (request.getUserAgent() == null && StringUtils.isNotEmpty(baseUserAgent)) {
            request.setUserAgent(baseUserAgent);
        }
        ArrayList<ForestMultipart> multiparts = new ArrayList<ForestMultipart>(this.multipartFactories.size());
        String contentType = request.getContentType();
        if (!this.multipartFactories.isEmpty()) {
            if (StringUtils.isBlank(contentType)) {
                String boundary = StringUtils.generateBoundary();
                request.setContentType("multipart/form-data; boundary=" + boundary);
            } else if ("multipart/form-data".equalsIgnoreCase(contentType) && request.getBoundary() == null) {
                request.setBoundary(StringUtils.generateBoundary());
            }
        }
        for (int i3 = 0; i3 < this.multipartFactories.size(); ++i3) {
            ForestMultipartFactory factory = this.multipartFactories.get(i3);
            MappingTemplate nameTemplate = factory.getNameTemplate();
            MappingTemplate fileNameTemplate = factory.getFileNameTemplate();
            int index = factory.getIndex();
            Object data = args[index];
            factory.addMultipart(nameTemplate, fileNameTemplate, data, multiparts, args);
        }
        request.setMultiparts(multiparts);
        if (this.sslKeyStoreId != null) {
            SSLKeyStore sslKeyStore = null;
            String keyStoreId = this.sslKeyStoreId.render(args);
            if (StringUtils.isNotEmpty(keyStoreId)) {
                sslKeyStore = this.configuration.getKeyStore(keyStoreId);
                request.setKeyStore(sslKeyStore);
            }
        }
        if (this.encoder != null) {
            request.setEncoder(this.encoder);
        }
        if (this.decoder != null) {
            request.setDecoder(this.decoder);
        }
        if (this.progressStep >= 0L) {
            request.setProgressStep(this.progressStep);
        }
        if (this.configuration.getDefaultParameters() != null) {
            request.addNameValue(this.configuration.getDefaultParameters());
        }
        if (baseHeaders != null && baseHeaders.length > 0) {
            for (MappingTemplate baseHeader : baseHeaders) {
                String name;
                String headerText = baseHeader.render(args);
                String[] headerNameValue = headerText.split(":", 2);
                if (headerNameValue.length <= 1 || request.getHeader(name = headerNameValue[0].trim()) != null) continue;
                request.addHeader(name, headerNameValue[1].trim());
            }
        }
        if (this.configuration.getDefaultHeaders() != null) {
            request.addHeaders(this.configuration.getDefaultHeaders());
        }
        ArrayList<RequestNameValue> dataNameValueList = new ArrayList<RequestNameValue>();
        renderedContentType = request.getContentType();
        if (renderedContentType == null || renderedContentType.equalsIgnoreCase("application/x-www-form-urlencoded")) {
            for (i = 0; i < this.dataTemplateArray.length; ++i) {
                MappingTemplate dataTemplate = this.dataTemplateArray[i];
                String data = dataTemplate.render(args);
                String[] paramArray = data.split("&");
                for (int j = 0; j < paramArray.length; ++j) {
                    String dataParam = paramArray[j];
                    String[] dataNameValue = dataParam.split("=", 2);
                    if (dataNameValue.length <= 0) continue;
                    String name = dataNameValue[0].trim();
                    RequestNameValue nameValue = new RequestNameValue(name, type.getDefaultParamTarget());
                    if (dataNameValue.length == 2) {
                        nameValue.setValue(dataNameValue[1].trim());
                    }
                    nameValueList.add(nameValue);
                    dataNameValueList.add(nameValue);
                }
            }
        } else {
            for (i = 0; i < this.dataTemplateArray.length; ++i) {
                MappingTemplate dataTemplate = this.dataTemplateArray[i];
                String data = dataTemplate.render(args);
                request.addBody(data);
            }
        }
        request.addNameValue(nameValueList);
        for (i = 0; i < this.headerTemplateArray.length; ++i) {
            MappingTemplate headerTemplate = this.headerTemplateArray[i];
            String header = headerTemplate.render(args);
            String[] headNameValue = header.split(":", 2);
            if (headNameValue.length <= 0) continue;
            String name = headNameValue[0].trim();
            RequestNameValue nameValue = new RequestNameValue(name, 3);
            if (headNameValue.length == 2) {
                nameValue.setValue(headNameValue[1].trim());
            }
            request.addHeader(nameValue);
        }
        if (this.timeout != null) {
            request.setTimeout(this.timeout);
        } else if (this.baseTimeout != null) {
            request.setTimeout(this.baseTimeout);
        } else if (this.configuration.getTimeout() != null) {
            request.setTimeout(this.configuration.getTimeout());
        }
        if (this.connectTimeout != null) {
            request.setConnectTimeout(this.connectTimeout);
        } else if (this.baseConnectTimeout != null) {
            request.setConnectTimeout(this.baseConnectTimeout);
        } else if (this.configuration.getConnectTimeout() != null) {
            request.setConnectTimeout(this.configuration.getConnectTimeout());
        }
        if (this.readTimeout != null) {
            request.setReadTimeout(this.readTimeout);
        } else if (this.baseReadTimeout != null) {
            request.setReadTimeout(this.baseReadTimeout);
        } else if (this.configuration.getReadTimeout() != null) {
            request.setReadTimeout(this.configuration.getReadTimeout());
        }
        if (this.retryCount != null) {
            request.setMaxRetryCount(this.retryCount);
        } else if (this.baseRetryCount != null) {
            request.setMaxRetryCount(this.baseRetryCount);
        } else if (this.configuration.getMaxRetryCount() != null) {
            request.setMaxRetryCount(this.configuration.getMaxRetryCount());
        }
        if (this.maxRetryInterval >= 0L) {
            request.setMaxRetryInterval(this.maxRetryInterval);
        } else if (this.baseMaxRetryInterval != null) {
            request.setMaxRetryInterval(this.baseMaxRetryInterval);
        } else if (this.configuration.getMaxRetryInterval() >= 0L) {
            request.setMaxRetryInterval(this.configuration.getMaxRetryInterval());
        }
        Class globalRetryerClass = this.configuration.getRetryer();
        if (this.retryerClass != null && ForestRetryer.class.isAssignableFrom(this.retryerClass)) {
            request.setRetryer(this.retryerClass);
        } else if (this.baseRetryerClass != null && ForestRetryer.class.isAssignableFrom(this.baseRetryerClass)) {
            request.setRetryer(this.baseRetryerClass);
        } else if (globalRetryerClass != null && ForestRetryer.class.isAssignableFrom(globalRetryerClass)) {
            request.setRetryer(globalRetryerClass);
        }
        if (this.onSuccessParameter != null) {
            OnSuccess onSuccessCallback = (OnSuccess)args[this.onSuccessParameter.getIndex()];
            request.setOnSuccess(onSuccessCallback);
        }
        if (this.onErrorParameter != null) {
            OnError onErrorCallback = (OnError)args[this.onErrorParameter.getIndex()];
            request.setOnError(onErrorCallback);
        }
        if (this.onRedirectionParameter != null) {
            OnRedirection onRedirectionCallback = (OnRedirection)args[this.onRedirectionParameter.getIndex()];
            request.setOnRedirection(onRedirectionCallback);
        }
        if (this.onProgressParameter != null) {
            OnProgress onProgressCallback = (OnProgress)args[this.onProgressParameter.getIndex()];
            request.setOnProgress(onProgressCallback);
        }
        if (this.onSaveCookieParameter != null) {
            OnSaveCookie onSaveCookieCallback = (OnSaveCookie)args[this.onSaveCookieParameter.getIndex()];
            request.setOnSaveCookie(onSaveCookieCallback);
        }
        if (this.onLoadCookieParameter != null) {
            OnLoadCookie onLoadCookieCallback = (OnLoadCookie)args[this.onLoadCookieParameter.getIndex()];
            request.setOnLoadCookie(onLoadCookieCallback);
        }
        if (StringUtils.isEmpty(dataType = this.dataTypeTemplate.render(args))) {
            request.setDataType(ForestDataType.TEXT);
        } else {
            dataType = dataType.toUpperCase();
            ForestDataType forestDataType = ForestDataType.findByName(dataType);
            request.setDataType(forestDataType);
        }
        if (this.interceptorAttributesList != null && this.interceptorAttributesList.size() > 0) {
            for (InterceptorAttributes attributes : this.interceptorAttributesList) {
                InterceptorAttributes newAttrs = attributes.clone();
                request.addInterceptorAttributes(newAttrs.getInterceptorClass(), newAttrs);
                request.getInterceptorAttributes(newAttrs.getInterceptorClass()).render(args);
            }
        }
        if (this.globalInterceptorList != null && this.globalInterceptorList.size() > 0) {
            for (Interceptor item : this.globalInterceptorList) {
                request.addInterceptor(item);
            }
        }
        if (this.baseInterceptorList != null && this.baseInterceptorList.size() > 0) {
            for (Interceptor item : this.baseInterceptorList) {
                request.addInterceptor(item);
            }
        }
        if (this.interceptorList != null && this.interceptorList.size() > 0) {
            for (Interceptor item : this.interceptorList) {
                request.addInterceptor(item);
            }
        }
        return request;
    }

    private List<RequestNameValue> getNameValueListFromObjectWithJSON(MappingParameter parameter, ForestConfiguration configuration, Object obj, ForestRequestType type) {
        if (obj == null) {
            return null;
        }
        Map propMap = ReflectUtils.convertObjectToMap(obj, configuration);
        ArrayList<RequestNameValue> nameValueList = new ArrayList<RequestNameValue>();
        for (Map.Entry entry : propMap.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            RequestNameValue nameValue = new RequestNameValue(name, value, parameter.isUnknownTarget() ? type.getDefaultParamTarget() : parameter.getTarget(), parameter.getPartContentType());
            nameValueList.add(nameValue);
        }
        return nameValueList;
    }

    public Object invoke(Object[] args) {
        Object rType = this.getReturnType();
        ForestRequest request = this.makeRequest(args);
        MethodLifeCycleHandler lifeCycleHandler = null;
        request.setBackend(this.configuration.getBackend());
        if (ForestRequest.class.isAssignableFrom(this.returnClass)) {
            Type retType = this.getReturnType();
            if (retType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)retType;
                Type[] genTypes = parameterizedType.getActualTypeArguments();
                if (genTypes.length > 0) {
                    Type targetType = genTypes[0];
                    rType = targetType;
                } else {
                    rType = String.class;
                }
                if (rType instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)rType;
                    Type[] bounds = wildcardType.getUpperBounds();
                    rType = bounds.length > 0 ? bounds[0] : String.class;
                }
                Class<String> successType = rType;
                if (this.onSuccessClassGenericType != null) {
                    successType = this.onSuccessClassGenericType;
                }
                lifeCycleHandler = new MethodLifeCycleHandler((Type)rType, (Type)((Object)successType));
                request.setLifeCycleHandler(lifeCycleHandler);
                lifeCycleHandler.handleInvokeMethod(request, this, args);
                return request;
            }
            lifeCycleHandler = new MethodLifeCycleHandler((Type)rType, this.onSuccessClassGenericType);
            request.setLifeCycleHandler(lifeCycleHandler);
            lifeCycleHandler.handleInvokeMethod(request, this, args);
            return request;
        }
        lifeCycleHandler = new MethodLifeCycleHandler((Type)rType, this.onSuccessClassGenericType);
        request.setLifeCycleHandler(lifeCycleHandler);
        lifeCycleHandler.handleInvokeMethod(request, this, args);
        return request.execute();
    }

    private static Type getGenericClassOrType(Type genType, int index) {
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (params[index] instanceof ParameterizedType) {
            return params[index];
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return params[index];
    }

    public void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    public Type getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.method.getGenericReturnType();
        }
        return this.returnType;
    }

    public MappingParameter getReturnTypeParameter() {
        return this.returnTypeParameter;
    }

    public void setReturnTypeParameter(MappingParameter returnTypeParameter) {
        this.returnTypeParameter = returnTypeParameter;
    }

    public Type getResultType() {
        Type[] types;
        Type type = this.getReturnType();
        if (type == null) {
            return Void.class;
        }
        Class<?> clazz = ReflectUtils.toClass(type);
        if (ForestResponse.class.isAssignableFrom(clazz) && type instanceof ParameterizedType && (types = ((ParameterizedType)type).getActualTypeArguments()).length > 0) {
            return types[0];
        }
        return type;
    }

    private static class ForestAnnotation {
        private final Annotation annotation;
        private final Class<? extends Interceptor> interceptor;

        private ForestAnnotation(Annotation annotation, Class<? extends Interceptor> interceptor) {
            this.annotation = annotation;
            this.interceptor = interceptor;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public Class<? extends Interceptor> getInterceptor() {
            return this.interceptor;
        }
    }
}

